/*****************************************************************************/
/*                                                                           */
/* COLORS.E.  Color setting is concentrated here.  This does two things:     */
/*                                                                           */
/* 1. Defines mnemonic constants for the color numbers,                      */
/*    so the rest of the files can refer to "RED" rather than 4.             */
/* 2. Configures the standard colors, by defining mnemonic field names       */
/*    such as STATUSCOLOR.                                                   */
/*                                                                           */
/* To configure your colors, change only this file (the lower half).         */
/*                                                                           */
/*****************************************************************************/

const
   BLACK          =  0
   BLUE           = 01
   GREEN          = 02
   CYAN           = 03
   RED            = 04
   MAGENTA        = 05
   BROWN          = 06
   LIGHT_GREY     = 07
   DARK_GREY      = 08
   LIGHT_BLUE     = 09
   LIGHT_GREEN    = 10
   LIGHT_CYAN     = 11
   LIGHT_RED      = 12
   LIGHT_MAGENTA  = 13
   YELLOW         = 14
   WHITE          = 15
   BLACKB         =  0
   BLUEB          = 16
   GREENB         = 32
   CYANB          = 48
   REDB           = 64
   MAGENTAB       = 80
   BROWNB         = 96
   YELLOWB        = 96
   WHITEB         =112

   BLINK          =128        /* qualities */
   UNDERLINE      =  1
   HIGH_INTENSITY =  8
   NORMAL         =  7
   INVERSE        =112
   INVISIBLE      =  0

/*********************** Configure your colors here. *************************/
; Note:  COMMANDCOLOR is used for the status line and filename in zoom
;        window style 3.
const
   STATUSCOLOR              = LIGHT_GREEN   + GREENB
   MONOSTATUSCOLOR          = NORMAL
   FILENAMECOLOR            = LIGHT_CYAN    + GREENB
   MONOFILENAMECOLOR        = NORMAL
   COMMANDCOLOR             = WHITE         + BROWNB
   MONOCOMMANDCOLOR         = INVERSE
   FUNCTIONKEYTEXTCOLOR     = CYAN          + BLACKB
   MONOFUNCTIONKEYTEXTCOLOR = NORMAL
   WINDOWCOLOR              = LIGHT_GREY    + BLUEB
   MONOWINDOWCOLOR          = NORMAL
   BOXCOLOR                 = YELLOW        + BLACKB
   MONOBOXCOLOR             = NORMAL
   CURSORCOLOR              = LIGHT_CYAN    + BROWNB
   MONOCURSORCOLOR          = UNDERLINE     + HIGH_INTENSITY
   MARKCOLOR                = BLUE          + WHITEB
   MONOMARKCOLOR            = INVERSE
   MESSAGECOLOR             = GREEN         + BLUEB
   MONOMESSAGECOLOR         = NORMAL

