----- E3 PROCS appended at 21:04:00 on 88/08/26 GMT (by JOHN at CAMBRIDG) -----
; imm.e:  Immediate line move, copy, shift left & right
;
; Some useful immediate-action keys, operating on the line the cursor
; is on when no marked is present:
;
;    alt+c:   Replicate line
;    alt+m:   Move line down one
;    alt+F7:  Shift line right
;    alt+F8:  Shift line left
;
; The "non-marked" function corresponds closely to the action taken when
; a mark does exist.   All four keys maintain their normal function when a
; marked area exists.
;
; Add this to mykeys.e, and you should be all set
;
; John Richard Jensen (JOHN at CAMBRIDG)

-- Shift line left/right
def a_F7= if marktype() = '' then            -- If nothing marked
             markline                        -- mark the "cursor" line,
             shift_left                      -- Shift the line
             unmark                          -- reset to a no-mark state
          else
             shift_left                      -- Shift the mark
             endif
def a_F8= if marktype() = '' then            -- If nothing marked
             markline                        -- mark the "cursor" line,
             shift_right                     -- Shift the line
             unmark                          -- reset to a no-mark state
          else
             shift_right                     -- Shift the mark
             endif

-- Replicate current line if nothing marked
def a_c= if marktype() = '' and .line then   -- If nothing marked
            markline                         -- mark the "cursor" line,
            call pcopy_mark(p1,p2,p3,p4)     -- copy it, and
            unmark                           -- reset to a no-mark state
            down                             -- Move to new line
         else
            call pcopy_mark(p1,p2,p3,p4)     -- Business as usual
            endif

-- Move current line down one line, have cursor tag along
def a_m= if marktype() = '' and .line then   -- If nothing marked
            markline                         -- mark the "cursor" line,
            down                             -- move cursor to next line,
            call pmove_mark(p1,p2,p3,p4)     -- move it,
            key s_f4                         -- Keep surrounding txt fixed
            unmark                           -- reset to a no-mark state
         else
            call pmove_mark(p1,p2,p3,p4)     -- Business as usual
            endif

; John Richard Jensen (JOHN at CAMBRIDG)

