/* Yet another implementation of
   RETRIEVE's CTRL-W function in E3 - Russ Williams         Ctrl-Y
   Adapted from a procedure by Paul Giangarra

   This procedure defines a key to pop up a window containing the file of
   saved commands, COMS.E.  The window is scrollable and the currently
   selected command line is marked.  The following operations are
   available while the saved-commands window is displayed:

     Enter - execute the marked command and remove the popup window.
     Ctrl-Backspace - delete the marked command from COMS.E.
     Esc  - remove the popup window without executing a command.
     F2   - save the commands file to the default file defined in "retr_file"
	    below.
     F8   - append the commands in the default file to the current COMS.E. --was F9
     c_Y  - copy the selected command to the command without executing it, --was F10
	    and remove the popup window.
     Up, Down, - scroll the displayed commands file a line at a time.
     PgUp, PgDn - scroll the displayed commands file a page at a time.
     Home, Ctrl-Home - scroll to the top of the commands file.
     End, Ctrl-End - scroll to the end of the commands file.

   Note that while the window is displayed, the currently-suspended
   window shows "COMS.E" as the file id.  This will be restored to
   the proper contents when the command window is dropped.

   Additionally, the following commands are defined:

     SAVECMDS [fileid] - saves COMS.E to the specified file, or to the
	                 default file if the operand is omitted.
     RESTCMDS [fileid] - appends to COMS.E from the specified file, or
	                 from the default file if the operand is omitted.

   To install, add an include for this file in your MYKEYS.E file.
   E3.11 is required, but if you remove the DISPLAY commands in
   SAVECMDS and RESTCMDS it could be used in earlier releases (at the
   cost of some flicker in those commands).
*/

const
   retr_file = TEMP_PATH'coms.eee'    /* this is the default save file */
   retr_msg = 'up,dn=select  ENTER=execute  ESC=Quit  F2=Save  F8=Edit'

; Ŀ
;  Pop-up the saved commands file COMS.E in a window. 
; 
def c_y=
  /* This method of menu selection is from Clark Maurer's E3SPELL */
  newwindow 'e 'argsep'w 'argsep'n coms.e'
  bottom       /*@@*/

  /* .boxx = 45; .boxwidth = 35; .box = 1; .boxy = 11; .boxheight = 15 */
  sw=screenwidth(); sh=screenheight()  /* jbl 6/21/89 */
  .boxwidth=sw/2; .boxx=sw-.boxwidth
  .box = 1
  .boxheight=sh/2; .boxy=sh+1-.boxheight

  .windowx = .boxx+1; .windowy = .boxy+1
  .windowwidth = .boxwidth-2; .windowheight = .boxheight-2
  .linex=0;.colx=0;.insertx=0;.statusx = 0
  .cursory=1;.line=1

  line=select_a_command()
  sayerror 0
  if line<>0 then
    line
  endif
  cursorcommand

;Ŀ
; SAVECMDS fileid  saves coms.e to the specified file 
; or to the default file if no operand specified.     
;
defc savecmds  /*save coms.e to a temp file*/
  if arg(1)='' then temp=retr_file else temp=arg(1) endif
  /* display 0 */
  'e 'argsep'n coms.e'
  r=savefile(temp)
  .modify=0
  'q'
  /* display 1 */
  if r=0 then sayerror 'Commands saved to' temp endif

;Ŀ
; RESTCMDS fileid  appends to coms.e from the 
; specified file or from the default file if  
; no operand specified.                       
;
defc restcmds  /* restore coms.e from a file */
  if arg(1)='' then temp=retr_file else temp=arg(1) endif
  findfile file,temp
  if rc = 0 then
    /* display 0 */
    'e 'argsep'n coms.e'
    bottom
    'get' file
    .modify=0
    'q'
    /* display 1 */
    sayerror file 'appended to commands list'
  else sayerror temp 'not found' endif

defproc select_a_command
   call psave_mark(save_mark)
   cursor_data
   /*@@ .line=0;begin_line;down;unmark;mark_line */
   bottom; begin_line; unmark; mark_line
   msg = retr_msg
   loop
     sayerror msg
     msg = retr_msg
     k=getkey()
     if k=esc then
       sayerror 0
       .modify=0
       'q'
       leave
     elseif k=up then
       if .line<>1 then
	 unmark;up;mark_line
       endif
     elseif k=down then
       unmark;down;mark_line
     elseif k=pgup then
       unmark;page_up;mark_line
     elseif k=pgdn then
       unmark;page_down;mark_line
     elseif k=c_home or k=home then
       unmark;top;mark_line
     elseif k=c_end or k=end then
       unmark;bottom;mark_line
     elseif k=c_backspace then
       delete_mark;down;mark_line
     elseif k=c_y then
       getline line
       unmark
       .modify=0
       'q'
       cursor_command
       begin_line;erase_end_line
       keyin line
       Leave
     elseif k=f8 then
       unmark;bottom;line=.line
       findfile file,retr_file
       if rc = 0 then 'get' file
       else msg = file 'not found' endif
       .line=line;down;mark_line
     elseif k=f2 then
       unmark
       rc=savefile(retr_file)
       mark_line
     elseif k=enter then
       getline line
       unmark
       call prestore_mark(save_mark)
       .modify=0
       'q'
       return(line)
     endif
   endloop
   call prestore_mark(save_mark)
   return(0)

