/* SORTAIX.E     Calls SORT that comes with AIX.  Thanks to Dick Ryniker  */
/*                for original.                                           */

defc SORT =
   TypeMark=marktype()
   if TypeMark='' then  /* if no mark, default to entire file */
      getfileid fileid
      firstline=1 ; lastline=.last ; firstcol=1; lastcol = 20
   else
      getmark firstline,lastline,firstcol,lastcol,fileid
   endif

   /* If it was a line mark, the LastCol value can be 255.  Can't */
   /* imagine anyone needing a key longer than 40.                */
   if TypeMark='LINE' then lastcol=40 endif

   sayerror 'Sorting' lastline-firstline+1 'lines ... '

   /* Pass the sort switches, if any, as a sixth argument to sort(). */
   call sort(firstline,lastline,firstcol,lastcol,fileid, arg(1) )
   sayerror 0



defproc sort(firstline,lastline,firstcol,lastcol,fileid)
   universal StateBeforeSort    /* optional sixth arg = reverse switches "r" */

   Reverse = 0        /* Did user specify Reverse? */
   IgnoreCase=0
   if arg() > 5 then  /* if sixth argument was passed ... */
      if upcase(substr(arg(6),1,1))=='R' then
	 Reverse=1
      endif
      if verify('C',upcase(arg(6)))=0 then  /* C anywhere. */
	 IgnoreCase=1
      endif
   endif

   /* If only 1 line do nothing.  Enables us to treat 1 line as error later.*/
   if lastline = firstline then return sorterror("") endif

   OldCommandState = command_state()

   if RESTORE_MARK_AFTER_SORT then
      call psave_mark(savemark)
      call prestore_mark(savemark)
   endif
   OldCol=.col; OldLine=.line; OldX=.cursorx; OldY=.cursory
   StateBeforeSort = OldCommandState OldCol OldLine OldX OldY

   in_name = TEMP_PATH'SORTIN.TMP'     /* jbl:  don't use $ on AIX */
   out_name= TEMP_PATH'SORTOUT.TMP'

   /*  We want to copy the complete lines, not a piece.  Change to line mark.*/
   pset_mark(firstline,lastline,firstcol,lastcol,'LINE',fileid)
   'xcom e 'argsep'n'           /*  Create a temporary file.  */
   getfileid tempofid
   call pcopy_mark(a,b,c,d) /* Dummy parameters, must have 4. */
   top; deleteline         /* Always extra blank line at top of new file.  */
   activatefile tempofid
   'xcom save 'argsep'q 'in_name
   if rc<>0 then           /* Not saved?  */
      .modify=0; 'xcom q'
      activatefile fileid
      return sorterror("Can't write the input file, probably out of disk space.")
   endif

   .modify=0 ; 'xcom q'

   /* Notice that we must specify that it's an external command with XCOM, */
   /* else E3 tries to re-execute this SORT command and gets into a loop.  */
   cmdline='xcom sort '
   if IgnoreCase then
      CmdLine= CmdLine' -f'
   endif
   if Reverse then
      CmdLine= CmdLine' -r'
   endif
   CmdLine = CmdLine '-o' out_name '+.'firstcol-1 '-.'lastcol-1 in_name
   quiet_shell CmdLine     /* Thar she blows! */
   x=rc
   if rc<>0 then
      activatefile fileid
      return sorterror("Unexpected error.")
   endif

   /* Try to load output file now, before deleting anything.  */
   'xcom edit 'argsep'q 'out_name
   if rc=sayerror('New file') then           /* Doesn't exist?  */
      .modify=0; 'xcom q'
      activatefile fileid
      return sorterror("Can't find the output file!")
   endif

   getfileid tempofid
   /* If number of lines in output is 1, may be an error message. */
   bottom
   if .line<=1 then
      getline line
      .modify=0; 'xcom q'
      activatefile fileid
      return sorterror("Sort error:  "line)
   endif
   if .line=0 then
      .modify=0; 'xcom q'
      activatefile fileid
      return sorterror('Sort error.')
   endif

   /* If not same number of lines as we sent, error. */
   if .line <> lastline-firstline+1 then
      /* Leave the output file in the ring. */
      call select_edit_keys()
      return sorterror("Output file is wrong size!  Please examine the results.")
   endif

   -- 2.4:  Work correctly with E3.11D or earlier versions.  Don't depend on
   -- the marked area staying behind after a copy_mark.  Explicitly re-mark.
   unmark
   activatefile fileid
   pset_mark(firstline,lastline,firstcol,lastcol,'LINE',fileid)
   delete_mark             /* Now it MUST be safe to delete the original. */
   activatefile tempofid

   top; mark_line          /* Copy the new lines.  */
   bottom; mark_line
   activatefile fileid
   firstline-1
   call pcopy_mark(a,b,c,d)
   activatefile tempofid   /* Release temporary file. */
   .modify=0; 'xcom q'

   /* Always erase temp files. */
   call erasetemp("SORT*.TMP")

   if RESTORE_MARK_AFTER_SORT then
      call prestore_mark(savemark)
   endif
   return sorterror("")


/* Common routine to save space. */
defproc sorterror(msg)
   universal StateBeforeSort
   if msg<>"" then
      sayerror msg "  Press any key ... "
      k=getkey()
   endif
   parse value StateBeforeSort with OldCommandState OldCol OldLine OldX OldY
   .cursorx = OldX
   .cursory = OldY
   .col     = OldCol
   .line    = OldLine
   if OldCommandState then cursor_command endif
   /* Return a value testable by the caller. */
   if msg="" then return 0 else return 1 endif


/*
; Sample call of sort as a procedure, for testing.
defc testsort
   getfileid fileid
   call sort(1,2,1,20,fileid)
   sayerror 0
*/

