; STDCMDS.E            Alphabetized by command name.
;

;  Put and append work the same, and the same as XEdit's PUT.
;  If the file already exists, append to it.
;  If no file is specified, use same file as last specified.
;  If no mark, use append the entire file.
defc app, append, put =
   universal last_append_file

   if arg(1) = '' then
      app_file=last_append_file
   else
      app_file=parse_file_n_opts(arg(1))
      last_append_file=app_file
   endif
   if app_file='' then
      sayerror 'No filename specified'
      stop
   endif
   getfileid fileid
   if marktype() then
      had_mark = 1
      call psave_mark(save_mark)
      call prestore_mark(save_mark)
   elseif .last = 0 then sayerror 'File is empty'; stop
   else
      had_mark = 0
      call pset_mark(1,.last,1,1,'LINE',fileid)
   endif
   /* If file is already in memory, we'll leave it there for speed. */
   already_in_ring = 1
   'e 'argsep'q 'argsep'n' app_file   /* look for file already in ring */
   if rc=sayerror("New file") then
      already_in_ring = 0
      'q'
      'e 'argsep'q' app_file  /* not 'xcom e', so we can append to host files */
      if rc=sayerror("New file") then
         if marktype()='LINE' then deleteline endif
      elseif rc then
         stop
      endif
   endif
   getfileid tempofid
   if marktype()<>'LINE' then
      insertline '',tempofid.last+1
   endif
   tempofid.line=tempofid.last
   copyrc=pcopy_mark(destfirstline,destlastline,destfirstcol,destlastcol)
   if copyrc then /* Check memory full, invalid path, etc. */
      .modify=0; 'xcom q'
      sayerror copyrc
      stop
   endif
;  .messagey=screenheight()   /* No longer needed, not using hidden ring.*/
   aborted=0
   /* If the app_file was already in memory, don't file it. */
   if not already_in_ring then
      'save'
      if rc then aborted=1 endif
      activatefile tempofid; tempofid.modify=0; 'xcom q'
   endif
   activatefile fileid
   if had_mark then
      call prestore_mark(save_mark)
   else
      unmark
   endif
   if not aborted then
      sayerror 'Marked area written to 'app_file
   endif
   return 0

defc asc=
   parse arg i '=' .
   if i='' then
      getline line
      i=substr(line,.col,1)
   endif
   setcommand 'asc 'i'='asc(i)

defc autosave=
   universal autosave
   uparg=upcase(arg(1))
   if uparg='ON' then                  /* If only says AUTOSAVE ON,  */
      autosave = 10                    /* default is every 10 lines. */
   elseif uparg='OFF' then
      autosave = 0
   elseif isnum(uparg) then            /* Check whether numeric argument. */
      autosave = uparg
   elseif uparg='' then
      cursor_command;begin_line;eraseendline
      keyin 'autosave 'autosave
   else
      sayerror 'AUTOSAVE <number>  to set number of Enters between saves.  0 = off.'
      stop
   endif
   if autosave > 0 then
      TempName=MakeTempName(.filename)
      sayerror 'Name of the AutoSave file:  'TempName
   endif

defc bottom,bot=
   bottom

defc box=  /* give height width style */
   universal tempofid

   uparg=upcase(arg(1))
   msg =  'Args: 1= 2= 3=| 4= 5= 6= B=Spc /Any  P=Pas C=C  A=Asm  E=Erase  R=Reflow'
   if not length(uparg) then
      sayerror msg
      cursor_command;begin_line;erase_end_line;keyin 'Box '
      stop
   endif
   if marktype()<>'BLOCK' then
      sayerror 'Block mark required'
      stop
   endif
   flg=0
   for ptr = 1 to length(uparg)
      if flg then
         style=substr(arg(1),ptr,1)
      else
         style=substr(uparg,ptr,1)
      endif
      if style='/' then
         flg=1; iterate
      endif
      if not flg and verify(uparg,"123456BCPAER") then
         sayerror msg
         cursor_command;begin_line;erase_end_line;keyin 'Box '
         stop
      endif
      call psave_pos(save_pos)
      getmark firstline,lastline,firstcol,lastcol,fileid
      if style='E' then
         getline tline,firstline,fileid
         getline bline,lastline,fileid
         msg='Marked area is not inside a box'
         if firstcol=1 or firstline=1 or lastline=fileid.last then
            sayerror msg
            stop
         endif

         brc=substr(bline,lastcol+1,1)
         lside=substr(tline,firstcol-1,1)
         if lside='' or lside='' or lside=';' or lside='|' or lside=''  then
            sl=1
         elseif lside='*' and firstcol>2 then
            if substr(tline,firstcol-2,2)='{*' or substr(tline,firstcol-2,2)='/*' then
               sl=2
            else
               if brc=lside then
                  sl=1
               else
                  sayerror msg
                  stop
               endif
            endif
         elseif brc=lside then
            sl=1
         else
            sayerror msg
            stop
         endif
         for i=firstline to lastline
            getline line,i,fileid
            replaceline substr(line,1,firstcol-sl-1)||substr(line,firstcol,lastcol+1-firstcol)||substr(line,lastcol+sl+1),i,fileid
         endfor
         deleteline lastline+1,fileid
         deleteline firstline-1,fileid
         call prestore_pos(save_pos)
         call pset_mark( firstline-1,lastline-1,firstcol-sl,lastcol-sl,marktype(),fileid)
      elseif style='R' then
         if not pblock_reflow(0,space,tempofid) then
            call pblock_reflow(1,space,tempofid)
         endif
         call prestore_pos(save_pos)
      else
         if flg then
            lside=style;rside=style;tside=style;tlc=style;trc=style;blc=style;brc=style
         else
            if style='P' then lside='{*';rside='*}';tside='*';tlc='{*';trc='*}';blc='{*';brc='*}'
            elseif style='A' then lside=';';rside=' ';tside='*';tlc=';';trc=' ';blc=';';brc=' '
            elseif style='C' then lside='/*';rside='*/';tside='*';tlc='/*';trc='*/';blc='/*';brc='*/'
            elseif style=1 then lside='';rside='';tside='';tlc='';trc='';blc='';brc=''
            elseif style=2 then lside='';rside='';tside='';tlc='';trc='';blc='';brc=''
            elseif style=3 then lside='|';rside='|';tside='-';tlc='+';trc='+';blc='+';brc='+'
            elseif style=4 then lside='';rside='';tside='';tlc='';trc='';blc='';brc=''
            elseif style=5 then lside='';rside='';tside='';tlc='';trc='';blc='';brc=''
            elseif style=6 then lside='';rside='';tside='';tlc='';trc='';blc='';brc=''
            else   style='B';lside=' ';rside=' ';tside=' ';tlc=' ';trc=' ';blc=' ';brc=' '
            endif
         endif
         sl=length(lside)
         width=1+lastcol-firstcol   /* width of inside of box */
         side=substr('',1,width,tside)
         line = substr('',1,firstcol-1)||blc||side||brc
         insertline line,lastline+1,fileid
         insertline substr('',1,firstcol-1)||tlc||side||trc,firstline,fileid
         for i=firstline+1 to lastline+1
            getline line,i,fileid
            replaceline substr(line,1,firstcol-1)||lside||substr(line,firstcol,width)||rside||substr(line,lastcol+1),i,fileid
         endfor
         call prestore_pos(save_pos)
         call pset_mark(firstline+1,lastline+1,firstcol+sl,lastcol+sl,marktype(),fileid)
      endif
      flg=0
   endfor

defc c,change=
   universal lastchangeargs, default_search_options
   /* Insert default_search_options just before supplied options (if any)    */
   /* so the supplied options will take precedence.                          */
   args=strip(arg(1),'L')  /* Delimiter = 1st char, ignoring leading spaces. */
   user_options=''
   if args<>'' then        /* If args blank, use lastchangeargs. */
      if default_search_options='' then
         lastchangeargs=args
      else
         delim=substr(args,1,1)
         p=pos(delim,args,2)   /* find last delimiter of 2 or 3 */
         if p then
            p=pos(delim,args,p+1)   /* find last delimiter of 2 or 3 */
            if p>0 then
               user_options=substr(args,p+1)
               args=substr(args,1,p-1)
            endif
         else
            sayerror 'No replacement string specified'; stop
         endif
         if marktype() then
            all=''
         else           -- No mark, so override if default is M.
            all='A'
         endif
         lastchangeargs=args || delim || default_search_options || all || user_options
      endif
   endif
   if verify(upcase(user_options),'M','M') then
      call checkmark()
      /* Put this line back in if you want the M choice to force */
      /* the cursor to the start of the mark.                    */
;;;   call pbegin_mark()  /* mark specified - make sure at top of mark */
   endif
   'xcom c 'lastchangeargs

defc cd=
   universal home_directory

   rc=0
   if arg(1)='' then
      dir= directory()
   else
      -- jbl 6/22/89:  recognize ~ and ` as home; see defproc parse_filename.
      dir = arg(1)
      if verify(substr(dir,1,1), '~`', 'M') then
         dir = home_directory || substr(dir,2)
      endif
      dir= directory(dir)
   endif
   if not rc then
      call select_edit_keys()
      sayerror 'Current directory is 'dir
   endif

defc center=
   call pcenter_mark()

defc chr=
   parse arg i '=' .
   setcommand 'chr 'i'='chr(i)

;  This command is the same function that has been attached to
;  the key Alt-equal.  Moved here as a separate command to make key
;  binding more flexible.  And to allow execution without a key binding.
defc dolines=
   rc=0
   found_error=0
   if marktype()='LINE' then
      sayerror 'Execute all marked lines Y/N ?'
      loop
         k=upcase(getkey())
         if k=esc then return '' endif
         if k='N' or k='Y' then leave endif
      endloop
      if k='Y' then
         getmark firstline,lastline,i,i,fileid
         for i=firstline to lastline
            getline line,i,fileid
            line
            if rc then found_error=1 endif
         endfor
         if not found_error then
            sayerror 'Commands executed without error'
         endif
         sayerror 0
         return ''
      endif
      sayerror 0
   endif
   getline line
   line

/* This DEFC EDIT eventually calls the built-in edit command, by calling      */
/* loadfile(), but does additional processing for messy-desk windowing (moves */
/* each file to its own window), and ends by calling select_edit_keys().      */
; Ver. 3.09:  Parse off each file individually.  Files can optionally be
; followed by one or more commands, each in quotes.  The first file that
; follows a host file must be separated by a comma, an option, or a
; (possibly null) command.
defc e,ed,edit=
   universal messy

   rest=strip(arg(1))

   if rest='' then   /* 'edit' by itself goes to next file */
      call pnextfile()
      call select_edit_keys()
      return 0
   endif

   options=''
   new_files=''
   not_found=''
   bad_paths=''
   files_loaded=0; first_file_loaded=''
   new_files_loaded=0

   do while rest<>''
      rest=strip(rest,'L')
      if substr(rest,1,1)=',' then rest=strip(substr(rest,2),'L'); endif
      ch=substr(rest,1,1)
      if ch='"' then           -- Command
         parse value rest with '"'cmd'"' rest
         cmd
      elseif ch=argsep /* '/' */  then       -- Option
         parse value rest with opt rest
         options=options upcase(opt)
      else
         files_loaded=files_loaded+1  -- Number of files we tried to load
            parse value rest with file rest2
            if pos(',',file) then parse value rest with file ',' rest
            else rest=rest2; endif
         call parse_filename(file,.filename)
         if messy then                            -- messy-desk style?
            .windowoverlap=1
            if pos('H',options) then      -- hidden option used?
               call loadfile(file,options)
            else
               if not verify(file,'?*','M') and   -- If no wildcards
                  not pos('D',options)    -- and not /D,
               then
                  if verify(file,':\','M') then   -- get fully qualified file
                     getfileid newfileid,file
                  else
                     getfileid newfileid,directory()'\'file -- (add path if necessary).
                     if newfileid='' then getfileid newfileid,file; endif
                  endif
                  if newfileid<>'' then           -- If it's already loaded,
                     .box=1
                     /*@@ if newfileid.windowid=0 then   -- (in the hidden ring?)
                        newwindow 'e 'argsep'w' options file -- (Yes, have to edit it.)
                     else */
                        activatefile newfileid       -- then just activate it.
                     /*@@ endif */
                     iterate
                  endif
               endif
               newwindow 'e 'argsep'w 'argsep'n'  /* start a new file */
               /* Newwindow 'e' creates an empty file just like E startup. */
               getfileid emptyfileid
               if not (rc and rc<>sayerror('new file')) then
                  if pos('Q',options) then sayerror 1; endif
                  call loadfile(file,options argsep||'w')
                  loadrc=rc
                  if loadrc=sayerror('Not enough memory') then
                     deletewindow
                     stop
                  endif
                  getfileid newfileid
                  call create_window_for_each_file(emptyfileid)
                  .windowoverlap=1
                  if not loadrc or loadrc=sayerror('New file') then
                     /* Normal results, normal cleanup:  discard empty file. */
                     activatefile emptyfileid
                     quitview
                     activatefile newfileid
                  else     /* Unexpected error! */
                     deletewindow
                  endif
               endif
               prevwindow; .box=1; nextwindow
            endif
         else      -- not messy
            call loadfile(file,options)
            prevfile;.box=1;nextfile
         endif -- if messy

         if rc=sayerror('Path not found') then
            bad_paths=bad_paths',' file
         elseif rc=sayerror('File not found') then
            not_found=not_found',' file
         elseif rc=sayerror('New file') then
            new_files=new_files',' file
            new_files_loaded=new_files_loaded+1
         endif
         if first_file_loaded='' then
            if rc<>sayerror('Path not found') &
               rc<>sayerror('File not found')
            then
               getfileid first_file_loaded
            endif
         endif
      endif  -- not "cmd"
   end    -- while rest<>''
   if files_loaded>1 then  -- If only one file, leave E3's message
      if new_files_loaded>1 then p='New files:'; else p='New file:'; endif
      if new_files || bad_paths || not_found <>
         not_found || bad_paths || new_files
      then                                        -- More than one.
         if new_files then say p substr(new_files,2); endif
         if not_found then say 'Not found:' substr(not_found,2); endif
         if bad_paths then say 'Bad path:' substr(bad_paths,2); endif
         pause
      elseif new_files then sayerror p substr(new_files,2)
      elseif bad_paths then sayerror 'Path not found:' substr(bad_paths,2)
      elseif not_found then sayerror 'Not found:' substr(not_found,2)
      endif
      if first_file_loaded<>'' then activatefile first_file_loaded endif
   endif
   if first_file_loaded<>'' then activatefile first_file_loaded endif
   /* Save the edit RC through select_edit_keys, since it might get reset  */
   /* by some command like 'tabs' or 'margins'.  This used to be in        */
   /* select_edit_keys, but that made configurability hard.                */
   saverc=rc
   call select_edit_keys()
   rc=saverc
   .box=2

defc echo=
   if arg(1) = '' then
      echo 'ON'
   else
      echo arg(1)
   endif

defc et=
   sayerror 'Compiling'
   infile=arg(1); if infile='' then infile=MAINFILE endif
   quietshell 'xcom et 'argsep'e' TEMP_FILENAME infile
   if rc=-2 then sayerror 'ET.Exe not found';stop endif
   if rc then
      call ec_position_on_error()
   else
      sayerror 'Compilation completed successfully.'
   endif

defc exit=
   if askyesno("About to exit without saving! ") = 'Y' then
      exit
   endif
   sayerror 0

defc expand=
   universal expand_on
   uparg=upcase(arg(1))
   if uparg='ON' then
      expand_on = 1
;     call select_edit_keys()
   elseif uparg='OFF' then
      expand_on = 0
   elseif uparg='' then
      cursor_command;begin_line;eraseendline
      if expand_on then
         keyin 'expand on'
      else
         keyin 'expand off';left
      endif
      left;left
   else
      sayerror 'Invalid arguments (On/Off)'
      stop
   endif

defc f,file=
   's 'arg(1)
   if not rc then
      if arg(1)<>'' then
         .modify=0            /* if saved to a different file turn modify */
      endif                   /* flag off anyway */
      'q'
      call select_edit_keys()
   endif

defc get=
   get_file = strip(arg(1))
   if get_file='' then sayerror 'No filename specified for get'; stop endif
   if pos(argsep,get_file) then
      sayerror 'Invalid option'
      stop
   endif
   call parse_filename(get_file,.filename)
   getfileid fileid
   call psave_mark(save_mark)
   s_last=.last
   'e 'argsep'q 'argsep'h 'argsep'd 'get_file
   editrc=rc
   getfileid gfileid
   if editrc=sayerror('New file') | .last=0 then
      'q'
      call prestore_mark(save_mark)
      if editrc=sayerror('New file') then
         sayerror 'File 'get_file' not found'
      else
         sayerror 'File 'get_file' is empty'
      endif
      stop
   endif
   if editrc then
      call prestore_mark(save_mark)
      sayerror editrc
      stop
   endif
   top
   mark_line
   bottom
   mark_line
   activatefile fileid
   rc=0
   copy_mark
   copy_rc=rc           -- Test for memory too full for copy_mark.
   activatefile gfileid
   'q'
   parse value save_mark with s_firstline s_lastline s_firstcol s_lastcol s_mkfileid s_mt
   if fileid=s_mkfileid then           -- May have to move the mark.
      diff=fileid.last-s_last          -- (Adjustment for difference in size)
      if fileid.line<s_firstline then s_firstline=s_firstline+diff; endif
      if fileid.line<s_lastline then s_lastline=s_lastline+diff; endif
   endif
   call prestore_mark(s_firstline s_lastline s_firstcol s_lastcol s_mkfileid s_mt)
   if copy_rc then
      sayerror 'Not enough memory for two copies of' get_file
   else
      call message(1)
   endif
   activatefile fileid
   call select_edit_keys()

/* Uses findfile statement to search EPATH for the helpfile.              */
/* Its syntax: findfile destfilename,searchfilename[,envpathvar][,['P']]  */
defc help=
   universal messy

   findfile destfilename, HELPFILENAME,EPATH
   if rc then
      /* If all that fails, try the standard path. */
      findfile destfilename, HELPFILENAME, 'PATH'
      if rc then
         sayerror  'Help file 'helpfilename' not found'
         return ''
      endif
   endif
   if messy then
      newwindow 'e 'argsep'w 'destfilename  /* load one view only */
      call setzoomwindow(1,1,1,screenheight() /* 25*/ ,screenwidth())
      .windowoverlap=1
   else
      'e 'argsep'w 'destfilename  /* load one view of help only */
   endif

defc key=
   if not isnum(arg(1)) then sayerror 'Need number argument';stop endif
   prompt='Type key to repeat.  Esc to cancel.'
   k=mgetkey(prompt)    /* Accept key from macro. */
   if k<>esc then
      cursor_data
      for i=1 to arg(1)
         executekey k
      endfor
      cursor_command
   endif
   sayerror 0

defc l=  /* Note:  this DEFC also gets executed by the slash ('/') command. */
   universal default_search_options
   r=rc /* This little trick tells us whether we're in a macro or on command */
        /* line, so we'll know where to leave the cursor at end.             */
   /* Insert default_search_options just before supplied options (if any)    */
   /* so the supplied options will take precedence.                          */
   args=strip(arg(1),'L')
   if default_search_options<>'' then
      delim=substr(args,1,1)
      p=pos(delim,args,2)
      user_options=''
      if p then
         user_options=substr(args,p+1)
         args=substr(args,1,p-1)
      endif
      if marktype() then
         all=''
      else           -- No mark, so override if default is M.
         all='A'
      endif
      args=args|| delim || default_search_options || all || user_options
   endif
   'xcom l 'args
   if not rc and r then
      cursor_data
   else
      call leave_last_command(r,rc)
   endif

defc list, findfile, filefind=
   call save_command_state(cstate)
   fn_b4_list= upcase(.filename)
   parse value fn_b4_list with name '.' ext
   /* If I say "list c:\util" I mean the whole util directory.  But we */
   /* have to tell SubDir that explicitly by appending "\*.*".         */

   spec = arg(1)
   fname = ''
   if spec='' then    /* If no argument at all, assume current directory. */
      spec="*"    /* for aix */
      fname = directory()
   elseif not verify(spec,'*?','M') then -- If no wildcards, assume directory
      fname = resolve_path(spec)
      if fname == '' then return; endif
      -- jbl 9/1/89:  Don't append "/*" to spec; causes ls to list child dirs.
   else
      -- User gave a wildcard file pattern.  Separate the directory and
      -- file pattern with a space, so the Alt-1 key can easily interpret.
      i=lastpos(FILESEP,spec)
      if i=0 then       -- No directory given, assume current.
         fname = directory() spec
      else
         -- Resolve the pathname.  We don't want a relative path like "..",
         -- because if we changed our current directory the Alt-1 key wouldn't
         -- work any more.
         dirname = substr(spec,1,i-1)
         fname = substr(spec,i+1)
         fulldir = resolve_path(dirname)
         if fulldir == '' then return; endif
         fname = fulldir fname
      endif
   endif
   call subdir(spec' >'TEMP_FILENAME)  -- Moved /Q option to defproc subdir

   'e 'argsep'q 'TEMP_FILENAME
   call erasetemp(TEMP_FILENAME)
   if .last then
      if machine()="RTAIX" then
         -- AIX sometimes puts the path spec in front of the filenames.
         -- Hard to deal with, since sometimes it's full path like
         -- /u/blewis/e3/stdcmds.e; sometimes it's relative like ../stdcmds.e.
         -- So strip path from the list; it's remembered in .filename.
         .filename='.ls 'fname      -- for aix.  was:  '.DIR 'dirname
         for l=1 to .last
            getline line, l
            i = lastpos(FILESEP,line)
            if i>0 then
               replaceline substr(line,i+1), l
            else
               leave
            endif
         endfor
      endif
      .modify=0
   else
      'xcom q'
      call restore_command_state(cstate)
      sayerror 'No matching file found'
   endif
   call select_edit_keys()

defc loopkey=
   finish=arg(1)
   if upcase(finish)='ALL' then
      finish= .last-.line+1
   endif
   if not isnum(finish) then sayerror 'Need number argument';stop endif
   prompt='Type key to repeat.  Esc to cancel.'
   k=mgetkey(prompt)    /* Accept key from macro. */
   oldcol=.col
   if k<>esc then
      cursor_data
      for i=1 to finish
         executekey k;down;.col=oldcol
      endfor
      cursor_command
   endif
   sayerror 0

defc lowercase=
   call plowercase()

defc matchtab=
   universal matchtab_on
   uparg=upcase(arg(1))
   if uparg='ON' then
      matchtab_on = 1
   elseif uparg='OFF' then
      matchtab_on = 0
   elseif uparg='' then
      cursor_command;begin_line;eraseendline
      if matchtab_on then
         keyin 'matchtab on'
      else
         keyin 'matchtab off';left
      endif
      left;left
   else
      sayerror 'Invalid arguments (On/Off)'
      stop
   endif

defc n,name=
   /* Name with no args supplies current name, thanks BILL. */
   if arg(1)='' then
      setcommand 'Name' .filename,6
   else
      oldname = .filename
      call namefile(arg(1))
      if oldname <> .filename then .modify = 1 endif
   endif
   call select_edit_keys()

defc newwindow=
   universal messy
   if messy then opt=argsep' w'; else opt=''; endif
   rest=parse_file_n_opts(arg(1))
   newwindow 'e'opt rest
   call select_edit_keys()

;  Print just the marked area, if there is one.
defc print=  /* Save the users current file to the printer */
   if not printer_ready() then
      sayerror 'Printer not ready'
      stop
   endif
   if marktype() then
      getmark firstline,lastline,firstcol,lastcol,markfileid
      getfileid fileid
      if fileid<>markfileid then
         sayerror "You have a marked area in another file.  Unmark or edit" markfileid.filename
         stop
      endif
      mt=marktype()
      'xcom e 'argsep'n'             /*  Create a temporary no-name file. */
      if rc=sayerror("New file") then
         if marktype()='LINE' then deleteline endif
      elseif rc then
         stop
      endif
      getfileid tempofid
      call pcopy_mark(a,b,c,d)
      if rc then stop endif
      call pset_mark(firstline,lastline,firstcol,lastcol,mt,markfileid)
      activatefile tempofid
      sayerror 'Printing marked area.'
   else
      sayerror 'Printing '.filename
   endif

   -- jbl 8/22/89:  don't save to PRN on aix.  Use /dev/lp0 or whatever was
   -- specified in PRINTER_NAME.
   if PRINTER_NAME=='' then   -- Do it the old way if no name set.
      -- The -q option here tells E not to show the message "Saving ..."
      -- and not to lower the .modify flag.
      'xcom save 'argsep'q prn'
   else
      -- But if the first word is "exec", execute that program instead, with
      -- whatever arguments the user supplied with this command.
      -- So if PRINTER_NAME="exec myprint", and the user says "print -tl=foo",
      -- the result will be:  save the file under its own name;
      --                      execute "myprint -tl=foo <filename>".
      parse value PRINTER_NAME with word1 word2
      if upcase(word1)=='EXEC' and word2<>'' then
         -- Perhaps this should be saved to a temp file instead, but then
         -- the filename going to the remote printer would be wrong.
         'xcom save 'argsep'q'
         quiet_shell 'xcom' word2 arg(1) .filename
      else
         'xcom save 'argsep'q 'PRINTER_NAME
      endif
   endif

   if marktype() then .modify=0; 'xcom q' endif
   sayerror 0    /* clear 'printing' message */

defc q,quit=
   call quitfile()
   call select_edit_keys()
   .box=2

defc qs,quietshell,quiet_shell=
   quietshell arg(1)

defc rc=
  arg(1)
  sayerror 'rc='rc

defc s,save=
   universal save_with_tabs
   name=arg(1)
   call parse_leading_options(name,options)
   if name='' then
      name=.filename
   else
      call parse_filename(name)
   endif
   if save_with_tabs then
      options = options argsep't'
   endif

   /* jbl 10/25/89:  turn on tabs if filename starts with Makefile or makefile,
    * which is the important filename to catch if we want to leave
    * save_with_tabs off by default.
    */
   i=lastpos(FILESEP,name)
   if i>0 then       -- No directory given, assume current.
      upfname = upcase(substr(name,i+1))
      if substr(upfname,1,8)="MAKEFILE" then
         rc=savefilewithtabs(name)
         if rc then call message(rc) endif
         return rc
      endif
   endif

   if isoption(options,'t') then
      rc=savefilewithtabs(name)
   else
      rc=savefile(name,options)
   endif
   if rc then call message(rc) endif
   return rc

defc top=
   top

defc uppercase=
   call puppercase()

