; Cursor size:  pairs of values for top/bottom scan line.
; Ver 3.021:  cursor size changes with insert mode now, but we don't have
; the flexibility we had on DOS.  The only lines relevant to e3aix
; are the last two "mono" lines.  And the hft driver allows only a few shapes.
;     if (bottom-top) <= 2      (e.g. 11, 12) we use double-underscore cursor.
;     if (bottom-top) == 3 to 6 (e.g.  6, 12) we use a half-blob.
;     if (bottom-top) >= 7      (e.g.  1, 12) we use a full-blob.
;
set cursors
   3  7                 /*color monitor cursor type for insert mode */
   6  7                 /*color monitor cursor type for replace mode */
   6  12                /*mono monitor cursor type for insert mode */
   11 12                /*mono monitor cursor type for replace mode */

set insert_state 1

; Set the number to 1 if you want the command stack saved between sessions.
; Set the string to some directory where you want coms.e to be saved between
; sessions, with trailing backslash.  Like '/u/blewis/e3/'.
set coms 0 ''


const
; jbl for version 3.021:  The constant EVERSION is automatically predefined.
; Just as the constant ARGSEP was always automatically predefined,
; to '-' in e3aix and '/' in e3dos.
; We could also use predefined constants FILESEP = '/'  or '\'
;                                        PATHSEP = ':'  or ';'
; but those aren't used in the standard macro set, so there's no compatibility
; benefit in predefining them.  For now define them here:
FILESEP = '/'
PATHSEP = ':'


; jbl 8/22/89:  define name of printer.  On AIX it's something like '/dev/lp0'
; or '/dev/rp0'; look at your /etc/qconfig.  On DOS and OS/2 it's 'PRN'.
;
; Special case:  if the first word is "exec", execute that program instead,
; with whatever arguments the user supplies after the print command.
; So if PRINTER_NAME="exec myprint", and the user says "print -tl=foo",
; the result will be:  save the file under its own name,
; and execute "myprint -tl=foo <filename>".
;
PRINTER_NAME = '/dev/lp0'        /* 'exec print' for me */


; It's best to put this temp file in a specific directory,
; like '/u/blewis/e3/e.tmp'.  Else it's put in your current directory.
TEMP_FILENAME= 'e.tmp'

TEMP_PATH=''
	                -- Some applications (external sorts, autosave)
	                --   need to create more than one temp file.
	                --   Like '/u/blewis/'.  Don't forget last backslash.

HELPFILENAME= 'ehelp.hlp'      /* Set help filename */
EPATH= 'epath'                 /* Set environment variable name */
MAINFILE= 'e.e'                /* Set main file for ET compiles */

-- This constant tells the compiler which host-support method
-- to include.  Only modify the first copy.  Typical values are:
--   'STD'  uses the original E3 method (mytecopy, etc.).
--   ''     loads no host-file support at all.
HOST_SUPPORT = ''


-- These constants specify what actions should be taken for the
-- Enter and C_Enter keys.  Possible values for ENTER_ACTION are:
--    'ADDLINE'   Insert a line after the current line.
--    'NEXTLINE'  Move to the next line without inserting a line.
--    'ADDATEND'  ADDLINE if on last line, else NEXTLINE.      (New in 3.09)
--    'DEPENDS'   ADDLINE if in insert_mode, else NEXTLINE.
--    'DEPENDS+'  ADDLINE if on last line, else DEPENDS.       (New in 3.09)
--    ''          Don't define; user will supply a routine (in MYSTUFF.E).
-- Possible values for C_ENTER_ACTION are the same, except that the action
-- taken for DEPENDS is reversed.
ENTER_ACTION   = 'ADDLINE'
;; On AIX we can't get the Ctrl-Enter key.  But leave it defined.
C_ENTER_ACTION = 'NEXTLINE'


-- Set to 1 the flags appropriate to the programming filetypes you often edit.
C_SYNTAX_ASSIST = 1
E_SYNTAX_ASSIST = 1
P_SYNTAX_ASSIST = 1
-- Set the margins and tabs for each type.
E_TABS = '3'
E_MARGINS = '1 254 1'
C_TABS = '3'
C_MARGINS = '1 254 1'
P_TABS = '3'
P_MARGINS = '1 254 1'

-- Set this to the desired indentation for each filetype with syntax-assist.
-- Normal values are 2, 3, 8.  Has no effect if not using assist.
-- You'll probably want to set this to the same value as TABS for each type.
C_SYNTAX_INDENT = 3
P_SYNTAX_INDENT = 3
E_SYNTAX_INDENT = 3

-- Set this to 1 if you like PE2's method of reflowing a paragraph -- moving
-- the cursor to the next paragraph.
REFLOW_LIKE_PE = 0

-- Ver.3.09:  Set this to 1 if you want the FILE key to quit rather than
-- save the file if the file was not modified.  Has the side effect that
-- the Name command sets .modify to 1.
SMARTFILE = 1

-- Ver.3.09:  Set this to 1 if you want the QUIT key to let you press the
-- FILE key if the file was modified.  You must also set the FILEKEY to be
-- the key you use.
SMARTQUIT = 1
FILEKEY   = F4

-- Ver.3.09:  Set this to 1 for Jim Hurley-style windows -- messy mode, so
-- you have the snazzy ability to size and drag -- but without the
-- disadvantage of a useless border around a full-screen window.  Also makes
-- messy mode respect window-style; recommended if you use messy.
JHwindow = 1

-- Ver.3.09:  This determines if SLIMDRAW will be included.  Set to 'F6'
-- if you want it associated with that key; set to 1 if you want the DRAW
-- command but no key set; set to 0 to have SLIMDRAW omitted completely.
WANT_DRAW = 'F6'


-- Ver.3.09:  Pick the name of the sort utility you prefer.  Choices are:
--   ''    for none:  no sort command at all.
--   'E'   for the standard internal (E-language) sort.  Good for small jobs,
--         no external utility, no disk access.  Runs in OS/2 protect mode.
--   'AIX' to use the external AIX "sort" program.
SORT_TYPE = 'AIX'

-- Set this to 0 if you want the marked area left unmarked after the sort.
compile if SORT_TYPE
RESTORE_MARK_AFTER_SORT = 1
compile endif


-- Ver. 3.11d:  This constant lets the user specify where the cursor should
-- be when starting E.  0 means in the file area, 1 means on the command line.
CURSOR_ON_COMMAND = 0

-------------------------------------------------------------------------------

definit
   universal expand_on,matchtab_on,ZoomWindowStyle,autosave
   universal maxint
   universal messy
   universal default_search_options,comsfileid
compile if HOST_SUPPORT
   universal hostcopy
compile endif
   universal save_with_tabs

   expand_on = 1            /* set default syntax assist to on */
   matchtab_on = 0          /* set default matchtab to off */
   ZoomWindowStyle=2        /* set default zoom window style */
   autosave=0               /* set autosave initial value */
   messy = 0
   save_with_tabs = 0       /* default is 0 now, for speed.  If we save a 
			       Makefile it's turned back on. */


-- Default options for locate and change commands.  Pick from:
--
--   E  Exact match (case sensitive)    C  Case-insensitive (ignore case)
--   A  All text (ignore marks)         M  Marked area only
--   +  Advance thru file, top->bott    -  Backward, bottom -> top
--   F  Forward in line, left->right    R  Reverse in line, right->left
--
-- The standard is 'EA+F' to be compatible with previous releases; that's
-- what you get if you leave this blank.  Many users will prefer 'C'.
default_search_options=''


compile if HOST_SUPPORT
   hostcopy='mytecopy'
	                -- Could be mytecopy, e78copy, bondcopy, cp78copy.
	                -- Add options if necessary (e.g., 'mytecopy /nowsf')
	                -- (Don't know if this'll be useful on aix....)
compile endif


-- This option CENTER_SEARCH specifies how the cursor moves
--   during a search or replace operation.
-- 0 :  Hold the cursor fixed; move the word to the cursor.  Like old E.
-- 1 :  Move the cursor to the word if it's visible on the current screen,
--      to minimize text motion.  Else center the word in mid-screen.
center_search = 1

-- This option JOIN_AFTER_WRAP specifies whether to join the
-- next line after a word-wrap.  To see its effect:  set margins to 1 79 1;
-- go into insert mode; type a few characters into this line to cause a wrap.
-- (sample next line)
-- If join_after_wrap = 1, you'll get:
--    wrap. -- (sample next line)
-- If join_after_wrap = 0, you'll get:
--    wrap.
--    -- (sample next line)
join_after_wrap = 1


-- This option TOP_OF_FILE_FIXED specifies whether the
--   "Top of File" line is allowed to move down from the top of the window.
-- 0 :  Allow the line to move down, so that cursor operations act the same
--      regardless of proximity to top of file.  For example, the key Shift-F5
--      (center the current line) will move the top-of-file line down if that's
--      what's needed to center the current line in a small file.
-- 1 :  Hold the line fixed; some cursor operations will change their behavior
--      as the cursor approaches the top of file.  Shift-F5 will not center the
--      current line in a small file.
top_of_file_fixed = 1

'xcom tabs 8'
'xcom margins 1 254 1'

   compile if (WANT_DRAW = F6 | WANT_DRAW = 'F6')
function_key_text  = "F1=Help  2=Save  3=Quit  4=File         "||
	             " 6=Draw  7=Name  8=Edit  9=Undo 10=Next"
   compile else
function_key_text  = "F1=Help  2=Save  3=Quit  4=File         "||
	             "         7=Name  8=Edit  9=Undo 10=Next"
   compile endif


------------ Rest of this file isn't normally changed. ------------------------

if machine()='RTAIX' then
   maxint=  '2147483647'
else
   maxint=  32767
endif

last_append_file = ''   -- Initialize for DEFC APPEND.

'xcom e -n -h coms.e'   -- jbl 7/10/89:  use - for options
getfileid comsfileid    -- initialize comsfileid for other macros

-- Make sure the top ring is active.  This E command (any old file
-- would do) activates the top ring.
'xcom e -n coms.e'; 'xcom q'

-- Ver 3.11:  move color initializations to init_window() in WINDOW.E.
-- Much of it was repeated there anyway.
call start_screen()
