/*
	           ͻ
	             Tiled  WINDOWING   
	           ͼ
	                    and
	         ͻ
	           Messy desk WINDOWING   
	         ͼ
*/
/**********************   KEYS  **********************************************/
;  The following definitions occur in STDKEYS.E
; def c_w = call pnextwindow()
; def c_z= call pzoom()
; def c_a =call pnextwindowstyle()
; def f10= call pnextfile()
; def a_f10=call pprevfile()
; def c_v=call psplitv()
; def c_h=call psplith()
; def a_4=call psplit4()


/**********************   PROCEDURES   ***************************************/
defproc start_screen /*Ver. 3.09:  Set stage & call remove_all_but_one for messy, also.*/
   universal stage
   universal ZoomWindowStyle
   universal messy

   stage = 1
   call remove_all_but_one()
   call setzoomwindow(ZoomWindowStyle,1,1,screenheight(),screenwidth())
   if JHwindow then
      if not messy then
	 .boxheight=screenheight()+10
      endif
   else
      if messy then
	 call sizepopup(1,1,screenwidth(),screenheight()-1)
      else
	 .boxheight=screenheight()+10
      endif
   endif

defproc set_window(x,y,w,h)
   call init_window(x+1,y+1,w-2,h-2)
   .box          = 1
   .boxx         = x
   .boxy         = y
   .boxheight    = h
   .messagex     = 1
   .messagey     = screenheight()
   .commandy     = screenheight()-1
   .commandx     = 1
   .commandwidth = screenwidth()
   .filenamey    = y
   .filenamex    = x+2
   .filenamewidth= min(w-4,screenwidth()/2)
   .statuswidth  = .filenamewidth         /* min(w-4,screenwidth()%2) */
   .statusy      = y+h-1
   .statusx      = .filenamex             /* x+2            */
   call make_status_fit()

defproc vertical2  /* Ver. 3.09:  handle messy also */
   universal messy
   wdiv2=screenwidth()/2
   call remove_all_but_one()
   call set_window(1,1,wdiv2,screenheight()-2)
   newwindow 'A'
   call set_window(wdiv2+1,1,wdiv2,screenheight()-2)
   if messy then prevwindow; .box=2
   else call pnextwindow() endif

defproc horizontal2  /* Ver. 3.09:  handle messy also */
   universal messy
   hdiv2=screenheight()/2
   call remove_all_but_one()
   call set_window(1,1,screenwidth(),hdiv2)
   newwindow 'A'
   call set_window(1,hdiv2+1,screenwidth(),screenheight()-hdiv2-2)
   if messy then prevwindow; .box=2
   else call pnextwindow() endif

defproc four_guys  /* Ver. 3.09:  handle messy also */
   universal messy
   wdiv2=screenwidth()/2
   hdiv2=screenheight()/2
   call remove_all_but_one()
   call set_window(1,1,wdiv2,hdiv2)
   newwindow 'A'
   call set_window(wdiv2+1,1,wdiv2,hdiv2)
   newwindow 'A'
   call set_window(wdiv2+1,hdiv2+1,wdiv2,screenheight()-hdiv2-2)
   newwindow 'A'
   call set_window(1,hdiv2+1,wdiv2,screenheight()-hdiv2-2)
   if messy then prevwindow; prevwindow; prevwindow; .box=2
   else call pnextwindow() endif

defproc make_status_fit  /* Ver. 3.09:  Added E version number */
   sw = .statuswidth
;  if sw>37 then
;     .linex        = .statusx+9
;     .colx         = .statusx+20
;     .insertx      = .statusx+29
;     .insertwidth  = 7
;     .statustext="    Line        Col"
  if sw>38 then
    /* Sample:                                        */
    /*' Line nnnnn  Col nnnnn  Replace  E vvvv '      */
    /* 0*1*2*3*4      */
    /* 0         0         0         0         0      */
    .linex        = .statusx+6
    .colx         = .statusx+17
    .insertx      = .statusx+24
    .insertwidth  = 7
    .statustext=' Line        Col                 E'EVERSION' '
   elseif sw>25 then
      .linex        = .statusx+7
      .colx         = .statusx+18
      .insertx      = .statusx+24
      .statustext   = ' Line        Col '
      if sw>30 then
	 .insertwidth=7
      elseif sw>27 then
	 .insertwidth=3
      else
	 .insertwidth=1
      endif
   elseif sw >15 then
     .linex        = .statusx+2
     .colx         = .statusx+9
     .insertx      = .statusx+15
     .statustext   = 'L       C  '
     .insertwidth=1
   elseif sw>9 then
      .linex        = .statusx+1
      .colx         = .statusx+7
      .insertx      = 0
      .statustext   = ''
   endif

/*@@ this is the new way, .windowid doesn't work.
defproc remove_all_but_one  /* Ver. 3.09:  from Jim Hurley */
   /* delete multiple views of all files in all windows but current */
   getfileid start_fid
   startw=.windowid
   nextwindow
   loop        /* for all windows */
      getfileid s
      w=.windowid
      /* done? */
      if w=startw then leave endif
      /* get the first file in the next window in case we delete
	 this window */
      nextwindow
      getfileid nextw
      activatefile s
      loop       /* for all files in the window */
	 if .views > 1 then
	    quitview
	    /* quitting changes window if it's the last file */
	    if .windowid<> w then
	       /* next window before the quitview */
	       activatefile nextw
	       leave
	    endif
	    getfileid s
	    iterate
	 endif
	 nextfile
	 getfileid n
	 /* done? */
	 if n==s then nextwindow; leave endif
      endloop
   endloop
@@*/

defproc remove_all_but_one
  universal messy
   if not messy then
      getfileid start_fid
      fid = start_fid
      loop
	 nextwindow
	 getfileid fid
	 if fid=start_fid then
	    leave
	 else
	    getfileid fileid
	    deletewindow
	 endif
      endloop
   endif


defproc pnextwindow()   /* next window */
   .box = 1
   nextwindow
   .box =2
   call select_edit_keys()

defproc pzoom()   /* zoom window */
   call start_screen()

defproc pnextwindowstyle()  /* Ver. 3.09:  Handle messy also */
   universal stage
   if  stage=1 then
      stage=2
      call vertical2()
   elseif stage=2 then
      stage=3
      call four_guys()
   elseif stage=3 then
      stage=4
      call horizontal2()
   else
      call start_screen()
   endif

defproc pnextfile()
   universal ZoomWindowStyle,messy
   if messy then
      .box = 1
      nextwindow
      .box=2
   else
      next_file
   endif
   call select_edit_keys()
   if JHwindow then
      if messy & (ZoomWindowStyle=5) then   -- Make sure filename is displayed
	 refresh
	 command_toggle; command_toggle
      endif
   endif

defproc pprevfile()
   universal ZoomWindowStyle,messy
   if messy then
      .box = 1
      prevwindow
      .box=2
   else
      prevfile
;;    call select_edit_keys()  /* Don't call twice! */
   endif
   call select_edit_keys()
   if JHwindow then
      if messy & (ZoomWindowStyle=5) then   -- Make sure filename is displayed
	 refresh
	 command_toggle; command_toggle
      endif
   endif

defproc psplitv()  /* Ver. 3.09:  Handle messy also */
   universal stage
   stage=2
   getfileid fileid
   call vertical2()

defproc psplith()  /* Ver. 3.09:  Handle messy also */
   universal stage
   stage=4
   getfileid fileid
   call horizontal2()

defproc psplit4()  /* Ver. 3.09:  New */
   universal stage
   stage=3
   getfileid fileid
   call four_guys()

; Ver. 3.09:  Added WS 5, from Jim Hurley.
defproc setzoomwindow(style,x,y,scrheight,scrwidth)
    universal messy
   .messagewidth= scrwidth

   if style=1 then
      call windowstyle1(x,y,scrheight,scrwidth)
      .filenamecolor=FILENAMECOLOR;.monofilenamecolor=MONOFILENAMECOLOR
      .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
      .commandcolor=COMMANDCOLOR;.monocommandcolor=MONOCOMMANDCOLOR
   elseif style=2 then
      call windowstyle1(x,y,scrheight,scrwidth)
      .windowheight=.windowheight+1
      .commandy=.commandy+1
      .commandwidth=scrwidth-.statuswidth
      .commandcolor=COMMANDCOLOR; .monocommandcolor=MONOCOMMANDCOLOR
      .filenamecolor=.commandcolor;.monofilenamecolor=.monocommandcolor
      .statuscolor=.commandcolor;.monostatuscolor=.monocommandcolor
   elseif style=3 then
      /* how about filename and status at the top */
      call setzoomwindow(2,x,y,scrheight,scrwidth)
      .windowy=.windowy+1
      .windowheight=.windowheight-1
      .commandwidth=scrwidth
      .filenamey=y;.statusy=y
      .filenamecolor=FILENAMECOLOR;.monofilenamecolor=MONOFILENAMECOLOR
      .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
      .commandcolor=COMMANDCOLOR;.monocommandcolor=MONOCOMMANDCOLOR
   elseif style=4 then
      /* how about filename and status at the top */
      /* and the command line at the top */
      call setzoomwindow(3,x,y,scrheight,scrwidth)
      .windowy=.windowy+1
      .commandy=2
   elseif style=5 then        /* Ver. 3.09:  Minimalist style from Jim Hurley*/
; Only one display line used for non-file display.  Messages may be truncated.
      call windowstyle1(x,y,scrheight,scrwidth)
      .windowheight=.windowheight+2
      .commandy=.commandy+2
      .statusy=.statusy+1
      .filenamey=.filenamey+1
      .commandwidth=scrwidth-.statuswidth
      .messagewidth=.commandwidth
      .messagex=.commandx;.messagey=.commandy
      .filenamecolor=.commandcolor;.monofilenamecolor=.monocommandcolor
      .statuscolor=.commandcolor;.monostatuscolor=.monocommandcolor
      .functionkeytextcolor=.commandcolor
      .monofunctionkeytextcolor=.monocommandcolor
      .messagecolor=.commandcolor;.monomessagecolor=.monocommandcolor
      /* We want only a single display line */
      .functionkeytextheight=0
   endif

defproc sizepopup(x,y,w,h)     /*box */
   universal ZoomWindowStyle,messy
   sw=screenwidth()
   sh=screenheight()
   oldboxwidth=.boxwidth
   oldboxx = .boxx

   .boxx         = max(min(x,sw-3),0)
   .boxwidth     = max(10,min(w,sw+2 - .boxx))

   if .boxwidth<17 then
     .boxx = oldboxx
     .boxwidth=oldboxwidth
     return ''
   endif
   .box          = 2
   .boxy         = max(min(y,sh-5),0)
   if JHwindow then
      minboxheight= sh-.boxy
      if messy then
	 if ZoomWindowStyle<>2 and ZoomWindowStyle<>5 then
	    minboxheight=minboxheight-1
	 elseif ZoomWindowStyle=5 then
	    minboxheight=minboxheight+1
	 endif
      endif
      .boxheight    = max(4,min(h,minboxheight))  -- JHWindow
   else
      .boxheight    = max(4,min(h,sh-1 - .boxy))
   endif
   .windowx      = .boxx+1
   .windowy      = .boxy+1
   .windowwidth  = .boxwidth-2
   .windowheight = .boxheight-2
   if JHwindow then
      .filenamey    = .boxy+.boxheight-1   /* put name   on bottom of box */ -- JHW
   else
      .filenamey    = .boxy
   endif
   .filenamex    = .boxx+2
   .filenamewidth= min(.boxwidth-4,40)
   .statuswidth  =.filenamewidth
   .statusx      =.filenamex
   if JHwindow then
      .statusy      = .boxy                /* put status on top    of box */ -- JHW
   else
      .statusy      =.boxy+.boxheight-1    /* put status on bottom of box */
   endif
   call make_status_fit()
   if .commandy<screenheight()-1 then
      .commandy=screenheight()-1
   endif
   .commandwidth=sw; .messagewidth=sw
   .filenamecolor = FILENAMECOLOR; .monofilenamecolor = MONOFILENAMECOLOR
   .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
   if ZoomWindowStyle=1 and not messy then
      .commandy=.commandy-1
   endif

defproc windowstyle1(x,y,scrheight,scrwidth)
   call init_window(x,y,scrwidth,scrheight-3)
   .box          = 0
   .boxx         = .windowx      -1
   .boxy         = .windowy      -1
   .boxheight    = .windowheight +4
   .commandy     = scrheight-2
   .commandx     = x
   .commandwidth = scrwidth
   .filenamey    = scrheight-1
   .filenamex    = x
   .filenamewidth= scrwidth/2
   .statusy      = .filenamey         /* scrheight-1  */
   .statusx      = .filenamewidth+1   /* scrwidth/2+1 */
   .statuswidth  = .filenamewidth     /* scrwidth/2   */
   .statuscolor  = STATUSCOLOR; .monostatuscolor = MONOSTATUSCOLOR
   .functionkeytextheight=1
   call make_status_fit()

/**********************   COMMANDS  ******************************************/

defc windowstyle,ws=  /* Ver. 3.09:  Added WS 5.  Permit execution in messy mode.*/
   universal ZoomWindowStyle,messy
   w=arg(1)
   if w=1 or w=2 or w=3 or w=4 or w=5 then
      ZoomWindowStyle=w
      call start_screen()
   else
      sayerror 'Your current Zoom window style is 'ZoomWindowStyle'  choices are 1,2,3,4 or 5'
   endif


defc drag=
   universal messy

   if messy then
      sayerror 'Use arrows to drag window.  Press ENTER or ESC when done'
      loop
	hit_key = getkey()
	if hit_key=enter or hit_key=esc then
	  leave
	endif
	if hit_key=right then
	  call sizepopup(.boxx+1,.boxy,.boxwidth,.boxheight)
	elseif hit_key=left then
	  call sizepopup(.boxx-1,.boxy,.boxwidth,.boxheight)
	elseif hit_key=up then
	  call sizepopup(.boxx,.boxy-1,.boxwidth,.boxheight)
	elseif hit_key=down then
	  call sizepopup(.boxx,.boxy+1,.boxwidth,.boxheight)
	endif
	refresh
	while testkey()<>'' do
	  k=getkey()
	endwhile
      endloop
      sayerror 0
   else
      sayerror 'DRAG may only be used with overlapping (messy-desk) windows'
   endif

defc size=
   universal messy

   if messy then
    sayerror 'Use arrows to size window.  Press ENTER or ESC when done'
      loop
	 hit_key = getkey()
	 if hit_key=enter or hit_key=esc then
	    leave
	 endif
	 if hit_key=right then
	    call sizepopup(.boxx,.boxy,.boxwidth+1,.boxheight)
	 elseif hit_key=left then
	    call sizepopup(.boxx,.boxy,.boxwidth-1,.boxheight)
	 elseif hit_key=up then
	    call sizepopup(.boxx,.boxy,.boxwidth,.boxheight-1)
	 elseif hit_key=down then
	    call sizepopup(.boxx,.boxy,.boxwidth,.boxheight+1)
	 endif
	 refresh
	 while testkey()<>'' do
	    k=getkey()
	 endwhile
      endloop
      sayerror 0
   else
      sayerror 'SIZE may only be used with overlapping (messy-desk) windows'
   endif


;  SZOOM   This command gets executed automatically by E, whenever E detects
;          that the screen size (rows or columns) has changed after a DOS
;          shell.  This does automatic resizing.
;          It tries to preserve whatever window configuration the user had.
defc szoom
   universal stage                /* window type */
   universal ZoomWindowStyle      /* 4 different window style types */
   universal messy                /* messy or tiled windows */

   if JHWindow=0 then
      if messy then                  /* messy windows */
	 call setzoomwindow(ZoomWindowStyle,1,1,screenheight(),screenwidth())
	 sizepopup(1,1,screenwidth(),screenheight()-1)
      else                                      /* tiled windows */
	 if stage=1 then        /* what type of window ? */
	    call start_screen() /* regular */
	 elseif stage=2 then
	    call vertical2()    /* vertical window (2 view boxes) */
	 elseif stage=3 then
	    call four_guys()    /* four view boxes */
	 elseif stage=4 then
	    call horizontal2()  /* horizontal window (2 view boxes) */
	 else
	    call start_screen() /* default regular */
	 endif
      endif
   endif

defproc init_window(x,y,w,h)
   .windowcolor     =WINDOWCOLOR
   .monowindowcolor =MONOWINDOWCOLOR
   .boxcolor        =BOXCOLOR
   .monoboxcolor    =MONOBOXCOLOR
   .cursorcolor     =CURSORCOLOR
   .monocursorcolor =MONOCURSORCOLOR
   .markcolor       =MARKCOLOR
   .monomarkcolor   =MONOMARKCOLOR
   .messagecolor    =MESSAGECOLOR
   .monomessagecolor=MONOMESSAGECOLOR
   .messagey        =screenheight()
   .windowx         =x
   .windowy         =y
   .windowwidth     =w
   .windowheight    =h
   .boxwidth        =w+2

