/* 3270 graphics resource widget

   This widget is a sub-class of the X3270 widget.  Its only
   purpose is to hold the graphic color resources for text
   windows when graphics are enabled.  When graphics aren't
   enabled, then an X3270 widget is used instead of this one.
   This prevents the color cells from being allocated needlessly
   when graphics aren't enabled.				*/


#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "Gr3270P.h"

static void SetgColor1(), SetgColor2(), SetgColor3(), SetgColor4(),
  SetgColor5(), SetgColor6(), SetgColor7(), SetgColor8(), SetgColor9(),
  SetgColor10(), SetgColor11(), SetgColor12(), SetgColor13(),
  SetgColor14(), SetgColor15(), SetgColor16();

#define offset(field) XtOffset(Gr3270Widget, gr3270.field)

static XtResource resources[] = {
  {XtNgColor1, XtCGColor1, XtRPixel, sizeof(Pixel),
     offset(gColor1), XtRCallProc, (caddr_t) SetgColor1},
  {XtNgColor2, XtCGColor2, XtRPixel, sizeof(Pixel),
     offset(gColor2), XtRCallProc, (caddr_t) SetgColor2},
  {XtNgColor3, XtCGColor3, XtRPixel, sizeof(Pixel),
     offset(gColor3), XtRCallProc, (caddr_t) SetgColor3},
  {XtNgColor4, XtCGColor4, XtRPixel, sizeof(Pixel),
     offset(gColor4), XtRCallProc, (caddr_t) SetgColor4},
  {XtNgColor5, XtCGColor5, XtRPixel, sizeof(Pixel),
     offset(gColor5), XtRCallProc, (caddr_t) SetgColor5},
  {XtNgColor6, XtCGColor6, XtRPixel, sizeof(Pixel),
     offset(gColor6), XtRCallProc, (caddr_t) SetgColor6},
  {XtNgColor7, XtCGColor7, XtRPixel, sizeof(Pixel),
     offset(gColor7), XtRCallProc, (caddr_t) SetgColor7},
  {XtNgColor8, XtCGColor8, XtRPixel, sizeof(Pixel),
     offset(gColor8), XtRCallProc, (caddr_t) SetgColor8},
  {XtNgColor9, XtCGColor9, XtRPixel, sizeof(Pixel),
     offset(gColor9), XtRCallProc, (caddr_t) SetgColor9},
  {XtNgColor10, XtCGColor10, XtRPixel, sizeof(Pixel),
     offset(gColor10), XtRCallProc, (caddr_t) SetgColor10},
  {XtNgColor11, XtCGColor11, XtRPixel, sizeof(Pixel),
     offset(gColor11), XtRCallProc, (caddr_t) SetgColor11},
  {XtNgColor12, XtCGColor12, XtRPixel, sizeof(Pixel),
     offset(gColor12), XtRCallProc, (caddr_t) SetgColor12},
  {XtNgColor13, XtCGColor13, XtRPixel, sizeof(Pixel),
     offset(gColor13), XtRCallProc, (caddr_t) SetgColor13},
  {XtNgColor14, XtCGColor14, XtRPixel, sizeof(Pixel),
     offset(gColor14), XtRCallProc, (caddr_t) SetgColor14},
  {XtNgColor15, XtCGColor15, XtRPixel, sizeof(Pixel),
     offset(gColor15), XtRCallProc, (caddr_t) SetgColor15},
  {XtNgColor16, XtCGColor16, XtRPixel, sizeof(Pixel),
     offset(gColor16), XtRCallProc, (caddr_t) SetgColor16},
};


Gr3270ClassRec gr3270ClassRec = {
  /* Core fields */
  { /* superclass		*/	(WidgetClass) &x3270ClassRec,
    /* class_name		*/	"Gr3270",
    /* widget_size		*/	sizeof(Gr3270Rec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize	  	*/	NULL,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	FALSE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	NULL,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL,
  },
  /* Win3270 fields */
  { /* empty			*/	0 },
  /* X3270 fields */
  { /* empty			*/	0 },
  /* Gr3270 fields */
  { /* empty			*/	0 }
};

WidgetClass gr3270WidgetClass = (WidgetClass) &gr3270ClassRec;


/* The default color values are set dynamically.  Since they aren't
   used on a monochrome display, they are set to "XtDefaultForeground".
   Otherwise, the Toolkit would print warning messages about not being
   able to allocate colormap entries.  */

#define setc(func, colorval) \
  /*ARGSUSED*/ static void func(widget, closure, value)			\
       Widget widget; int closure; XrmValue *value;			\
  {									\
    XrmValue fromval;							\
    fromval.addr = CellsOfScreen(XtScreen(widget)) > 2 ?		\
                     colorval : "XtDefaultForeground";			\
    fromval.size = strlen(fromval.addr) + 1;				\
    XtConvert(widget, XtRString, &fromval, XtRPixel, value);		\
  }

setc (SetgColor1,  "Blue")
setc (SetgColor2,  "Red")
setc (SetgColor3,  "Magenta")
setc (SetgColor4,  "Green")
setc (SetgColor5,  "Turquoise")
setc (SetgColor6,  "Yellow")
setc (SetgColor7,  "White")
setc (SetgColor8,  "Black")
setc (SetgColor9,  "DarkSlateBlue")
setc (SetgColor10, "Orange")
setc (SetgColor11, "Plum")
setc (SetgColor12, "DarkGreen")
setc (SetgColor13, "DarkTurquoise")
setc (SetgColor14, "Wheat")
setc (SetgColor15, "Gray")
setc (SetgColor16, "Brown")
