/* 3270 Image widget

   This widget is a sub-class of the Win3270 widget used for
   image windows.  It differs from the Win3270 widget in that it
   has imTranslations and colormap resources and also some new
   translation table entries.	*/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "Im3270P.h"

#define offset(field) XtOffset(Im3270Widget, field)

static XtResource resources[] = {
  {XtNimTranslations, XtCTranslations, XtRTranslationTable,
     sizeof(XtTranslations), offset(im3270.imTranslations), XtRImmediate,
     NULL},
  {XtNcolormap, XtCColormap, XtRPointer, sizeof(Colormap),
     offset(core.colormap), XtRImmediate, NULL},
};


static char newTranslations[] = 
    "<Btn1Up>:	image-save() \n\
     <Btn2Up>:	image-destroy()";


static void Initialize(), Realize();

Im3270ClassRec im3270ClassRec = {
  /* Core fields */
  { /* superclass		*/	(WidgetClass) &win3270ClassRec,
    /* class_name		*/	"Im3270",
    /* widget_size		*/	sizeof(Im3270Rec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	FALSE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	NULL,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL,
  },
  /* Win3270 fields */
  { /* empty			*/	0 },
  /* Im3270 fields */
  { /* empty			*/	0 }
};

WidgetClass im3270WidgetClass = (WidgetClass) &im3270ClassRec;


/*ARGSUSED*/ static void Initialize(request, new)
     Widget request, new;
{
  Im3270Widget xw = (Im3270Widget) new;

  /* Add Im3270-specific translations */
  XtOverrideTranslations(new, XtParseTranslationTable(newTranslations));

  /* Add any user-specified translations.  It would be nice if this
     could be done using the "*im3270.translations" resource, but
     that would be overriden by newTranslations.  Therefore, a new
     "*im3270.imTranslations" resource was defined.  */

  if (xw->im3270.imTranslations)
    XtOverrideTranslations(new, xw->im3270.imTranslations);
}


static void Realize(w, value_mask, attributes)
     Widget w;
     Mask *value_mask;
     XSetWindowAttributes *attributes;
{
  Im3270Widget xw = (Im3270Widget) w;

  attributes->cursor = xw->win3270.cursor;
  attributes->colormap = xw->core.colormap;
  *value_mask |= (CWCursor | CWColormap);

  XtCreateWindow(w, InputOutput, (Visual *) CopyFromParent, *value_mask,
		 attributes);
}
