/* Menu button widget

   This is the same as a command button widget except that it
   uses whatever width it is given rather than shrinking to
   fit the width of the text.					*/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "MenuBtnP.h"

static Boolean SetValues();

MenuBtnClassRec menuBtnClassRec = {
  /* Core fields */
  { /* superclass		*/	(WidgetClass) &commandClassRec,
    /* class_name		*/	"MenuBtn",
    /* widget_size		*/	sizeof(MenuBtnRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize	  	*/	NULL,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	NULL,
    /* num_resources		*/	0,
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	FALSE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	NULL,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL,
  },
  /* Simple fields */
  { /* change_sensitive		*/	XtInheritChangeSensitive },
  /* Label fields */
  { /* empty			*/	0 },
  /* Command fields */
  { /* empty			*/	0 },
  /* MenuBtn fields */
  { /* empty			*/	0 }
};

WidgetClass menuBtnWidgetClass = (WidgetClass) &menuBtnClassRec;

static Boolean SetValues(current, request, new)
     Widget current, request, new;
{
  MenuBtnWidget curmw = (MenuBtnWidget) current;
  MenuBtnWidget reqmw = (MenuBtnWidget) request;
  MenuBtnWidget newmw = (MenuBtnWidget) new;

  if (new->core.width == request->core.width) return False;

  /* Don't let the Label widget change the width */
  if (XtMakeResizeRequest(current,
			  (Dimension) reqmw->core.width,
			  (Dimension) reqmw->core.height,
			  (Dimension *) &newmw->core.width,
			  (Dimension *) &newmw->core.height) == XtGeometryNo)
    {
      newmw->core.width = curmw->core.width;
      newmw->core.height = curmw->core.height;
    }
  return False;
}
