/* 3270 text screen widget

   This widget is a sub-class of the Win3270 widget.  It is
   used for the main 3270 text window.  Since most of the work
   is done by the client, the main purpose of this widget is
   for holding resources.					*/


#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "X3270P.h"

#define IBORD 1

static Pixel defColor = ~0; /* Value for color that hasn't been set */

static void SetpnColor(), SetpiColor(), SetunColor(), SetuiColor(),
  SetextDefault(), SetextDefIntense(), SetextBlue(), SetextRed(),
  SetextPink(), SetextGreen(), SetextTurquoise(), SetextYellow(),
  SetextWhite();

#define offset(field) XtOffset(X3270Widget, x3270.field)

static XtResource resources[] = {
  {XtNcols, XtCCols, XtRDimension, sizeof(Dimension),
     offset(cols), XtRImmediate, (caddr_t) 80},
  {XtNrows, XtCRows, XtRDimension, sizeof(Dimension),
     offset(rows), XtRImmediate, (caddr_t) 24},
  {XtNpnColor, XtCPNColor, XtRPixel, sizeof(Pixel),
     offset(pnColor), XtRCallProc, (caddr_t) SetpnColor},
  {XtNpiColor, XtCPIColor, XtRPixel, sizeof(Pixel),
     offset(piColor), XtRCallProc, (caddr_t) SetpiColor},
  {XtNunColor, XtCUNColor, XtRPixel, sizeof(Pixel),
     offset(unColor), XtRCallProc, (caddr_t) SetunColor},
  {XtNuiColor, XtCUIColor, XtRPixel, sizeof(Pixel),
     offset(uiColor), XtRCallProc, (caddr_t) SetuiColor},
  {XtNextDefault, XtCExtDefault, XtRPixel, sizeof(Pixel),
     offset(extDefault), XtRCallProc, (caddr_t) SetextDefault},
  {XtNextDefIntense, XtCExtDefIntense, XtRPixel, sizeof(Pixel),
     offset(extDefIntense), XtRCallProc, (caddr_t) SetextDefIntense},
  {XtNextBlue, XtCExtBlue, XtRPixel, sizeof(Pixel),
     offset(extBlue), XtRCallProc, (caddr_t) SetextBlue},
  {XtNextRed, XtCExtRed, XtRPixel, sizeof(Pixel),
     offset(extRed), XtRCallProc, (caddr_t) SetextRed},
  {XtNextPink, XtCExtPink, XtRPixel, sizeof(Pixel),
     offset(extPink), XtRCallProc, (caddr_t) SetextPink},
  {XtNextGreen, XtCExtGreen, XtRPixel, sizeof(Pixel),
     offset(extGreen), XtRCallProc, (caddr_t) SetextGreen},
  {XtNextTurquoise, XtCExtTurquoise, XtRPixel, sizeof(Pixel),
     offset(extTurquoise), XtRCallProc, (caddr_t) SetextTurquoise},
  {XtNextYellow, XtCExtYellow, XtRPixel, sizeof(Pixel),
     offset(extYellow), XtRCallProc, (caddr_t) SetextYellow},
  {XtNextWhite, XtCExtWhite, XtRPixel, sizeof(Pixel),
     offset(extWhite), XtRCallProc, (caddr_t) SetextWhite},
  {XtNcursorColor, XtCCursorColor, XtRPixel, sizeof(Pixel),
     offset(cursorColor), XtRPixel, (caddr_t) &defColor},
#ifdef ISOFONT
  {XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(font), XtRString,
     "-adobe-courier-medium-r-*-*-12-120-75-75-m-70-iso8859-1"},
  {XtNboldFont, XtCBoldfont, XtRFontStruct, sizeof(XFontStruct *),
     offset(boldFont), XtRString,
     "-adobe-courier-bold-r-*-*-12-120-75-75-m-70-iso8859-1"},
  {XtNzoomFont, XtCZoomFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(zoomFont), XtRString,
     "-adobe-courier-medium-r-*-*-24-240-75-75-m-150-iso8859-1"},
  {XtNboldZoomFont, XtCBoldZoomFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(boldZoomFont), XtRString,
     "-adobe-courier-bold-r-*-*-24-240-75-75-m-150-iso8859-1"},
  {XtNiconFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(iconFont), XtRString,
     "-adobe-courier-medium-r-*-*-12-120-75-75-m-70-iso8859-1"},
#else
  {XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(font), XtRString, "Rom14.500"},
  {XtNboldFont, XtCBoldfont, XtRFontStruct, sizeof(XFontStruct *),
     offset(boldFont), XtRString, "Bld14.500"},
  {XtNzoomFont, XtCZoomFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(zoomFont), XtRString, "Rom22.500"},
  {XtNboldZoomFont, XtCBoldZoomFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(boldZoomFont), XtRString, "Rom22.500"},
  {XtNiconFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(iconFont), XtRString, "Rom14.500"},
#endif
  {XtNautoRaise, XtCBoolean, XtRBoolean, sizeof(Boolean),
     offset(autoRaise), XtRImmediate, (caddr_t) False},
  {XtNwarp, XtCBoolean, XtRBoolean, sizeof(Boolean),
     offset(warp), XtRImmediate, (caddr_t) False},
  {XtNdeIconifyWarp, XtCBoolean, XtRBoolean, sizeof(Boolean),
     offset(deIconifyWarp), XtRImmediate, (caddr_t) False},
  {XtNzoom, XtCBoolean, XtRBoolean, sizeof(Boolean),
     offset(zoom), XtRImmediate, (caddr_t) False},
  {XtNtune, XtCTune, XtRString, sizeof(caddr_t),
     offset(tune), XtRString, NULL},
  {XtNspecialCursor, XtCSpecialCursor, XtRCursor, sizeof(Cursor),
     offset(specialCursor), XtRString, "hand1"},
};


static void Initialize(), Realize();
static Boolean SetValues();

X3270ClassRec x3270ClassRec = {
  /* Core fields */
  { /* superclass		*/	(WidgetClass) &win3270ClassRec,
    /* class_name		*/	"X3270",
    /* widget_size		*/	sizeof(X3270Rec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	FALSE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	NULL,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL,
  },
  /* Win3270 fields */
  { /* empty			*/	0 },
  /* X3270 fields */
  { /* empty			*/	0 }
};

WidgetClass x3270WidgetClass = (WidgetClass) &x3270ClassRec;


/* The default color values are set dynamically.  Since they aren't
   used on a monochrome display, they are set to "XtDefaultForeground".
   Otherwise, the Toolkit would print warning messages about not being
   able to allocate colormap entries.  */

#define setc(func, colorval) \
  /*ARGSUSED*/ static void func(widget, closure, value)			\
       Widget widget; int closure; XrmValue *value;			\
  {									\
    XrmValue fromval;							\
    fromval.addr = CellsOfScreen(XtScreen(widget)) > 2 ?		\
                     colorval : "XtDefaultForeground";			\
    fromval.size = strlen(fromval.addr) + 1;				\
    XtConvert(widget, XtRString, &fromval, XtRPixel, value);		\
  }

setc (SetpnColor,       "Cyan")
setc (SetpiColor,       "White")
setc (SetunColor,       "Green")
setc (SetuiColor,       "Red")
setc (SetextDefault,    "Green")
setc (SetextDefIntense, "White")
setc (SetextBlue,       "Cyan")
setc (SetextRed,	"Red")
setc (SetextPink,       "Pink")
setc (SetextGreen,      "Green")
setc (SetextTurquoise,  "Turquoise")
setc (SetextYellow,     "Yellow")
setc (SetextWhite,      "White")


static void Initialize(request, new)
     Widget request, new;
{
  X3270Widget xw = (X3270Widget) new;
  XFontStruct *tfont;

  /* If cursor color wasn't specified, set to foreground color */
  if (xw->x3270.cursorColor == defColor)
    xw->x3270.cursorColor = xw->win3270.foreground;

  /* If size wasn't specified, set it according to number of cols and rows */
  tfont = xw->x3270.zoom ? xw->x3270.zoomFont : xw->x3270.font;
  if (tfont && xw->core.width == 0)
    xw->core.width = xw->x3270.cols * tfont->max_bounds.width + 2 * IBORD;
  if (tfont && xw->core.height == 0)
    xw->core.height = xw->x3270.rows * (tfont->max_bounds.ascent +
					tfont->max_bounds.descent) + 2 * IBORD;
}


static void Realize(w, value_mask, attributes)
     Widget w;
     Mask *value_mask;
     XSetWindowAttributes *attributes;
{
  X3270Widget xw = (X3270Widget) w;
  XColor fcolor, bcolor;

  /* Call realize procedure of Win3270.  We can't just use XtSuperclass
   here because the Gr3270 widget inherits this procedure, and Gr3270's
   superclass is this widget, not Win3270 as we require.  */

  (*(win3270ClassRec.core_class.realize)) (w, value_mask, attributes);

  /* Set special cursor color to the proper value */
  fcolor.pixel = xw->win3270.mouseColor;
  XQueryColor(XtDisplay(w), xw->core.colormap, &fcolor);
  bcolor.pixel = xw->core.background_pixel;
  XQueryColor(XtDisplay(w), xw->core.colormap, &bcolor);
  XRecolorCursor(XtDisplay(w), xw->x3270.specialCursor, &fcolor, &bcolor);
}


/*ARGSUSED*/ static Boolean SetValues(current, request, new)
     Widget current, request, new;
{
  return False;
}
