/* This file defines the protocol used by the application program
   interface library routines to communicate with an XANT server.	*/


/* Function codes */
#define API_VERSION	0	/* Get version */
#define API_DISC	1	/* Disconnect */
#define API_STATUS	2	/* Get status */
#define API_SENDKEY	3	/* Send keystrokes */
#define API_WAIT	4	/* Wait for keyboard unlock */
#define API_COPYPS	5	/* Copy presentation space to string */
#define API_SETCURS	6	/* Set cursor position */
#define API_COPYSTR	7	/* Copy string to presentation space */
#define API_GETFIELD	8	/* Get information about field */


#define API_VERSION_NUM 1


/* The first byte of a message from client is the function code.  Optional
   data follows (see table below).  The client always waits for a reply
   from the server before proceeding.  The first byte of a reply is always
   a return code.  Possible values are:  0 = success, 1 = unsupported function
   code, and 2 = other error.  All positions are specified using zero as
   the start of screen.


  Function	Sent			Returned
  --------------------------------------------------------------------
  API_VERSION	N/A			0    Return code
					1    API version number

  API_DISC	N/A			0    Return code

  API_STATUS	N/A			0    Return code
                        		1-2  Row count
  					3-4  Column count
  					5-6  Cursor position
					7    Extended mode flag
					8    Keyboard locked

  API_SENDKEY   One or more of:		0    Return code
		     Key function
		     Key value

  API_WAIT	1  Zero to do timeout	0    Return code
					1    Zero if unlocked

  API_COPYPS	1-2  Starting pos	0    Return code
		3-4  Length		1    Zero if unlocked
					2-n  String of requested length

  API_SETCURS	1-2  New position	0    Return code

  API_COPYSTR	1-2  Starting pos	0    Return code
		3-n  String to copy	1    Error code:
					         0 = no error
					         1 = inhibited
						 2 = too long
						 3 = invalid pos

  API_GETFIELD	1-2  Position		0    Return code
		3    Direction:		1-2  Starting position of field
		       0 = this field	         (first byte after attribute)
		       1 = next field	3-4  Field length
		       2 = previous	          (not counting attribute)
		4    Field type:	5    3270 field attribute
		       0 = don't care		  (zero if unformatted screen)
		       1 = protected
		       2 = unprotected
*/
