/* EHLLAPI definitions */


/* Function numbers */

#define HA_CONNECT_PS		 1	/* Connect Presentation Space */
#define HA_DISCONNECT_PS	 2	/* Disconnect Presentation Space */
#define HA_SENDKEY		 3	/* Send Key */
#define HA_WAIT			 4	/* Wait */
#define HA_COPY_PS		 5	/* Copy Presentation Space */
#define HA_SEARCH_PS		 6	/* Search Presentation Space */
#define HA_QUERY_CURSOR_LOC	 7	/* Query Cursor Location */
#define HA_COPY_PS_TO_STR	 8	/* Copy PS to String */
#define HA_SET_SESSION_PARMS	 9	/* Set Session Parameters */
#define HA_QUERY_SESSIONS	 10	/* Query Sessions */
#define HA_RESERVE		 11	/* Reserve */
#define HA_RELEASE		 12	/* Release */
#define HA_COPY_OIA		 13	/* Copy OIA */
#define HA_QUERY_FIELD_ATTR	 14	/* Query Field Attribute */
#define HA_COPY_STR_TO_PS	 15	/* Copy String to PS */
#define HA_STORAGE_MGR		 17	/* Storage Manager */
#define HA_PAUSE		 18	/* Pause */
#define HA_QUERY_SYSTEM		 20	/* Query System */
#define HA_RESET_SYSTEM		 21	/* Reset System */
#define HA_QUERY_SESSION_STATUS	 22	/* Query Session Status */
#define HA_START_HOST_NOTIFY	 23	/* Start Host Notification */
#define HA_QUERY_HOST_UPDATE	 24	/* Query Host Update */
#define HA_STOP_HOST_NOTIFY	 25	/* Stop Host Notification */
#define HA_SEARCH_FIELD		 30	/* Search Field */
#define HA_FIND_FIELD_POS	 31	/* Find Field Position */
#define HA_FIND_FIELD_LEN	 32	/* Find Field Length */
#define HA_COPY_STR_TO_FIELD	 33	/* Copy String to Field */
#define HA_COPY_FIELD_TO_STR	 34	/* Copy Field to String */
#define HA_SET_CURSOR		 40	/* Set Cursor */
#define HA_START_CLOSE_INTERCEPT 41	/* Start Close Intercept */
#define HA_QUERY_CLOSE_INTERCEPT 42	/* Query Close Intercept */
#define HA_STOP_CLOSE_INTERCEPT	 43	/* Stop Close Intercept */
#define HA_START_KEY_INTERCEPT	 50	/* Start Keystroke Intercept */
#define HA_GET_KEY		 51	/* Get Key */
#define HA_POST_INTERCEPT_STATUS 52	/* Post Intercept Status */
#define HA_STOP_KEY_INTERCEPT	 53	/* Stop Keystroke Intercept */
#define HA_SEND_FILE		 90	/* Send File */
#define HA_RECEIVE_FILE		 91	/* Receive file */
#define HA_CONVERT_POS_ROW_COL	 99	/* Convert Position or Row Column */
#define HA_CONNECT_PM_SRVCS	101	/* Connect PM Window Services */
#define HA_DISCONNECT_PM_SRVCS	102	/* Disconnect PM Window Services */
#define HA_QUERY_WINDOW_COORDS	103	/* Query PM Window Coordinates */
#define HA_PM_WINDOW_STATUS	104	/* PM Window Status */
#define HA_CHANGE_SWITCH_NAME	105	/* Change Switch List LT Name */
#define HA_CHANGE_WINDOW_NAME	106	/* Change PS Window Name */


/* Return codes */

#define HARC_SUCCESS		    0	/* Function successfully executed */
#define HARC_INVALID_PS		    1	/* Invalid PS ID or not connected */
#define HARC_BAD_PARM		    2	/* A parameter error occurred */
#define HARC_BUSY		    4	/* Target PS was busy */
#define HARC_LOCKED		    5	/* Function inhibited */
#define HARC_TRUNCATION		    6	/* Data error due to invalid param */
#define HARC_INVALID_PS_POS	    7	/* PS position was invalid */
#define HARC_NO_PRIOR_START	    8	/* Prerequisite function not issued */
#define HARC_SYSTEM_ERROR	    9	/* A system error occured */
#define HARC_UNSUPPORTED	   10	/* Function number is not supported */
#define HARC_UNAVAILABLE	   11	/* Resource is unavailable */
#define HARC_SESSION_STOPPED	   12	/* Session was stopped */
#define HARC_BAD_MNEMONIC	   20	/* Invalid keystroke */
#define HARC_OIA_UPDATE		   21	/* OIA was updated */
#define HARC_PS_UPDATE		   22	/* PS was updated */
#define HARC_STR_NOT_FOUND_UNFM_PS 24	/* String not found or PS not fmted */
#define HARC_NO_KEYS_AVAIL	   25	/* Keystrokes were not available */
#define HARC_HOST_UPDATE	   26	/* A host event occurred */
#define HARC_CTRL_BREAK		   27	/* File transfer ended by Ctrl+Break */
#define HARC_FIELD_LEN_ZERO	   28	/* Field length was zero */
#define HARC_QUEUE_OVERFLOW	   31	/* Keystroke queue overflow */
#define HARC99_INVALID_INP	    0	/* Incorrect input for function 99 */
#define HARC99_INVALID_PS	 9998	/* Invalid PS ID or system error */
#define HARC99_INVALID_CONV_OPT	 9999	/* Character 2 is neither P nor R */
