/* Table of codes for 3270 functions */

#define k_undefined	0
#define k_string	1
#define k_cursor_move	2

#define k_up		3
#define k_down		4
#define k_left		5
#define k_right		6
#define k_newline	7
#define k_home		8
#define k_tab		9
#define k_backtab	10
#define k_end		11
#define k_forward_word	12
#define k_backward_word	13

#define k_insert	14
#define k_delete	15
#define k_backspace	16
#define k_kill_word	17
#define k_backward_kill_word 18

#define k_erase_eof	19
#define k_erase_input	20
#define k_dup		21
#define k_field_mark	22
#define k_cent		23

#define k_pf1		24
#define k_pf2		25
#define k_pf3		26
#define k_pf4		27
#define k_pf5		28
#define k_pf6		29
#define k_pf7		30
#define k_pf8		31
#define k_pf9		32
#define k_pf10		33
#define k_pf11		34
#define k_pf12		35
#define k_pf13		36
#define k_pf14		37
#define k_pf15		38
#define k_pf16		39
#define k_pf17		40
#define k_pf18		41
#define k_pf19		42
#define k_pf20		43
#define k_pf21		44
#define k_pf22		45
#define k_pf23		46
#define k_pf24		47

#define k_clear		48
#define k_enter		49
#define k_pa1		50
#define k_pa2		51
#define k_pa3		52
#define k_sysreq	53
#define k_attn		54

#define k_reset		55
#define k_unlock	56
#define k_dumpfields	57
#define k_print_screen	58

#define k_stringa	59
#define k_stringa_	60
#define k_hex		61
#define k_hex_ge	62

#define k_lastcode	62


#ifdef KEYS_DECLARE
static void
  c_undefined(),
  c_string(),
  c_cursor_move(),

  c_up(),
  c_down(),
  c_left(),
  c_right(),
  c_newline(),
  c_home(),
  c_tab(),
  c_backtab(),
  c_end(),
  c_forward_word(),
  c_backward_word(),

  c_insert(),
  c_delete(),
  c_backspace(),
  c_kill_word(),
  c_backward_kill_word(),

  c_erase_eof(),
  c_erase_input(),
  c_dup(),
  c_field_mark(),
  c_cent(),

  c_pf1(),
  c_pf2(),
  c_pf3(),
  c_pf4(),
  c_pf5(),
  c_pf6(),
  c_pf7(),
  c_pf8(),
  c_pf9(),
  c_pf10(),
  c_pf11(),
  c_pf12(),
  c_pf13(),
  c_pf14(),
  c_pf15(),
  c_pf16(),
  c_pf17(),
  c_pf18(),
  c_pf19(),
  c_pf20(),
  c_pf21(),
  c_pf22(),
  c_pf23(),
  c_pf24(),

  c_clear(),
  c_enter(),
  c_pa1(),
  c_pa2(),
  c_pa3(),
  c_sysreq(),
  c_attn(),

  c_reset(),
  c_unlock(),
  c_dumpfields(),
  c_print_screen(),

  c_stringa(),
  c_stringa_(),
  c_hex(),
  c_hex_ge();
#endif


/* Functions for APL characters which really use stringa and stringa_ */
#ifdef KEYS_APL
static void
  c_a_underbar(),
  c_alpha(),
  c_b_underbar(),
  c_c_underbar(),
  c_circle_bar(),
  c_circle_slope(),
  c_circle_star(),
  c_circle_stile(),
  c_circle(),
  c_d_underbar(),
  c_del(),
  c_del_stile(),
  c_del_tilde(),
  c_delta(),
  c_delta_stile(),
  c_delta_underbar(),
  c_diamond(),
  c_dieresis(),
  c_dieresis_dot(),
  c_divide(),
  c_down_arrow(),
  c_down_carat(),
  c_down_carat_tilde(),
  c_down_shoe(),
  c_down_stile(),
  c_down_tack(),
  c_down_tack_jot(),
  c_e_underbar(),
  c_epsilon(),
  c_epsilon_underbar(),
  c_equal_underbar(),
  c_f_underbar(),
  c_g_underbar(),
  c_h_underbar(),
  c_i_beam(),
  c_i_underbar(),
  c_iota(),
  c_iota_underbar(),
  c_j_underbar(),
  c_jot(),
  c_k_underbar(),
  c_l_underbar(),
  c_left_arrow(),
  c_left_bracket(),
  c_left_shoe(),
  c_left_tack(),
  c_m_underbar(),
  c_n_underbar(),
  c_not_equal(),
  c_not_greater(),
  c_not_less(),
  c_o_underbar(),
  c_omega(),
  c_overbar(),
  c_p_underbar(),
  c_q_underbar(),
  c_quad(),
  c_quad_divide(),
  c_quad_jot(),
  c_quad_quote(),
  c_quad_slope(),
  c_quote_dot(),
  c_r_underbar(),
  c_rho(),
  c_right_arrow(),
  c_right_bracket(),
  c_right_shoe(),
  c_right_tack(),
  c_s_underbar(),
  c_slash_bar(),
  c_slope(),
  c_slope_bar(),
  c_squad(),
  c_stile(),
  c_t_underbar(),
  c_tilde(),
  c_times(),
  c_u_underbar(),
  c_up_arrow(),
  c_up_carat(),
  c_up_carat_tilde(),
  c_up_shoe(),
  c_up_shoe_jot(),
  c_up_stile(),
  c_up_tack(),
  c_up_tack_jot(),
  c_v_underbar(),
  c_w_underbar(),
  c_x_underbar(),
  c_y_underbar(),
  c_z_underbar(),

  /* Functions for box characters which really use stringa */
  c_upper_left_box_corner(),
  c_upper_right_box_corner(),
  c_lower_left_box_corner(),
  c_lower_right_box_corner(),
  c_top_box_tee(),
  c_bottom_box_tee(),
  c_left_box_tee(),
  c_right_box_tee(),
  c_box_cross(),
  c_horizontal_box_bar(),
  c_vertical_box_bar();
#endif


#ifdef KEYS_TABLE
typedef void (*func_addr)();

/* The following entries must be kept in order by key code */
static func_addr key_function[] =
{
  c_undefined,
  c_string,
  c_cursor_move,

  c_up,
  c_down,
  c_left,
  c_right,
  c_newline,
  c_home,
  c_tab,
  c_backtab,
  c_end,
  c_forward_word,
  c_backward_word,

  c_insert,
  c_delete,
  c_backspace,
  c_kill_word,
  c_backward_kill_word,

  c_erase_eof,
  c_erase_input,
  c_dup,
  c_field_mark,
  c_cent,

  c_pf1,
  c_pf2,
  c_pf3,
  c_pf4,
  c_pf5,
  c_pf6,
  c_pf7,
  c_pf8,
  c_pf9,
  c_pf10,
  c_pf11,
  c_pf12,
  c_pf13,
  c_pf14,
  c_pf15,
  c_pf16,
  c_pf17,
  c_pf18,
  c_pf19,
  c_pf20,
  c_pf21,
  c_pf22,
  c_pf23,
  c_pf24,

  c_clear,
  c_enter,
  c_pa1,
  c_pa2,
  c_pa3,
  c_sysreq,
  c_attn,

  c_reset,
  c_unlock,
  c_dumpfields,
  c_print_screen,

  c_stringa,
  c_stringa_,
  c_hex,
  c_hex_ge,
};
#endif
