/* Tables for the XANT program */


/* ASCII to EBCDIC translation table */
unsigned char atoe[] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F,
    /*08*/  0x16, 0x05, 0x25, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    /*10*/  0x10, 0x11, 0x12, 0x13, 0x3C, 0x3D, 0x32, 0x26,
    /*18*/  0x18, 0x19, 0x3F, 0x27, 0x22, 0x1D, 0x35, 0x1F,
    /*20*/  0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,
    /*28*/  0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,
    /*30*/  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    /*38*/  0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,
    /*40*/  0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    /*48*/  0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
    /*50*/  0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
    /*58*/  0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,
    /*60*/  0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    /*68*/  0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
    /*70*/  0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
    /*78*/  0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07,
    /*80*/  0x68, 0xDC, 0x51, 0x42, 0x43, 0x44, 0x47, 0x48,
    /*88*/  0x52, 0x53, 0x54, 0x57, 0x56, 0x58, 0x63, 0x67,
    /*90*/  0x71, 0x9C, 0x9E, 0xCB, 0xCC, 0xCD, 0xDB, 0xDD,
    /*98*/  0xDF, 0xEC, 0xFC, 0x70, 0xB1, 0x80, 0xBF,    0,
    /*A0*/  0x45, 0x55, 0xCE, 0xDE, 0x49, 0x69, 0x9A, 0x9B,
    /*A8*/  0xAB, 0xAF, 0x5F, 0xB8, 0xB7, 0xAA, 0x8A, 0x8B,
    /*B0*/     0,    0,    0,    0,    0, 0x65, 0x62, 0x64,
    /*B8*/  0xB4,    0,    0,    0,    0, 0x4A, 0xB2,    0,
    /*C0*/     0,    0,    0,    0,    0,    0, 0x46, 0x66,
    /*C8*/     0,    0,    0,    0,    0,    0,    0, 0x9F,
    /*D0*/  0x8C, 0xAC, 0x72, 0x73, 0x74,    0, 0x75, 0x76,
    /*D8*/  0x77,    0,    0,    0,    0, 0x6A, 0x78,    0,
    /*E0*/  0xEE, 0x59, 0xEB, 0xED, 0xCF, 0xEF, 0xA0, 0x8E,
    /*E8*/  0xAE, 0xFE, 0xFB, 0xFD, 0x8D, 0xAD, 0xBC, 0xBE,
    /*F0*/  0xCA, 0x8F,    0, 0xB9, 0xB6, 0xB5, 0xE1, 0x9D,
    /*F8*/  0x90, 0xBD, 0xB3, 0xDA, 0xFA, 0xEA,    0,    0 };


/* ASCII to graphic-escaped APL 3270-EBCDIC translation table

   Non-zero entries require a GE in inbound data stream.
   Zero entries should be translated using "atoe".

   ASCII    IBM Corporate Code Page 910
   APL2/TN  IBM Corporate Code Page 310

   Note:  ASCII "!|~^\" to APL, not to their "national use", codes.
	  See also 'atoge_a_'.						*/

unsigned char atoge_a[] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/     0,    0,    0,    0,    0,    0,    0, 0xA3,
    /*08*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*10*/     0,    0,    0,    0, 0xD8, 0xC8,    0,    0,
    /*18*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*20*/     0, 0xDB,    0,    0,    0,    0,    0,    0,
    /*28*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*30*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*38*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*40*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*48*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*50*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*58*/     0,    0,    0, 0xAD, 0xB7, 0xBD, 0x71,    0,
    /*60*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*68*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*70*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*78*/     0,    0,    0,    0, 0xBF,    0, 0x80,    0,
    /*80*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*88*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*90*/  0x90, 0xDE, 0xEE,    0,    0,    0,    0,    0,
    /*98*/  0xBC,    0,    0,    0,    0, 0xAC,    0, 0xDA,
    /*A0*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*A8*/     0, 0x8D,    0,    0, 0xAB,    0, 0xEF, 0xFE,
    /*B0*/     0,    0,    0, 0x85, 0xD6, 0xFD, 0xBB, 0xBA,
    /*B8*/  0x8F,    0,    0,    0,    0, 0x9F, 0x8E, 0xD5,
    /*C0*/  0xC4, 0xC7, 0xD7, 0xC6, 0xA2, 0xD3, 0x8A, 0x8B,
    /*C8*/     0,    0,    0,    0,    0,    0,    0, 0xE0,
    /*D0*/  0x74, 0x75, 0xEC, 0xCC, 0xCE, 0x73, 0x76, 0x77,
    /*D8*/  0x70, 0xD4, 0xC5, 0x95, 0x94, 0x91, 0x92, 0x93,
    /*E0*/  0xB0,    0, 0x9B, 0x9A, 0xDF, 0xCA, 0xB3, 0xCB,
    /*E8*/  0xCD, 0xED, 0x9D, 0x78, 0xB2, 0xCF, 0xB1, 0xAA,
    /*F0*/  0xEA, 0xEB, 0xAE, 0x8C, 0xBE, 0xB6, 0xB8, 0xFC,
    /*F8*/  0xAF, 0xB4, 0xFB, 0xDD, 0xDC, 0xA0, 0x72,    0 };


/* ASCII to graphic-escaped APL 3270-EBCDIC translation table

   Non-zero entries require a GE in inbound data stream.
   Zero entries should be translated using "atoe".

   ASCII    IBM Corporate Code Page 910
   APL2/TN  IBM Corporate Code Page 310

   Note:  ASCII lowercase alphabet mapped to APL underscored alphabet
	  and "!|~^\" to APL, not to their "national use", codes.
	  See-also 'atoge_a'.						*/

unsigned char atoge_a_[] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/     0,    0,    0,    0,    0,    0,    0, 0xA3,
    /*08*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*10*/     0,    0,    0,    0, 0xD8, 0xC8,    0,    0,
    /*18*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*20*/     0, 0xDB,    0,    0,    0,    0,    0,    0,
    /*28*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*30*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*38*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*40*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*48*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*50*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*58*/     0,    0,    0, 0xAD, 0xB7, 0xBD, 0x71,    0,
    /*60*/     0, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    /*68*/  0x48, 0x49, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    /*70*/  0x57, 0x58, 0x59, 0x62, 0x63, 0x64, 0x65, 0x66,
    /*78*/  0x67, 0x68, 0x69, 0xC0, 0xBF, 0xD0, 0x80,    0,
    /*80*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*88*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*90*/  0x90, 0xDE, 0xEE,    0,    0,    0,    0,    0,
    /*98*/  0xBC,    0,    0,    0,    0, 0xAC,    0, 0xDA,
    /*A0*/     0,    0,    0,    0,    0,    0,    0,    0,
    /*A8*/     0, 0x8D,    0,    0, 0xAB,    0, 0xEF, 0xFE,
    /*B0*/     0,    0,    0, 0x85, 0xD6, 0xFD, 0xBB, 0xBA,
    /*B8*/  0x8F,    0,    0,    0,    0, 0x9F, 0x8E, 0xD5,
    /*C0*/  0xC4, 0xC7, 0xD7, 0xC6, 0xA2, 0xD3, 0x8A, 0x8B,
    /*C8*/     0,    0,    0,    0,    0,    0,    0, 0xE0,
    /*D0*/  0x74, 0x75, 0xEC, 0xCC, 0xCE, 0x73, 0x76, 0x77,
    /*D8*/  0x70, 0xD4, 0xC5, 0x95, 0x94, 0x91, 0x92, 0x93,
    /*E0*/  0xB0,    0, 0x9B, 0x9A, 0xDF, 0xCA, 0xB3, 0xCB,
    /*E8*/  0xCD, 0xED, 0x9D, 0x78, 0xB2, 0xCF, 0xB1, 0xAA,
    /*F0*/  0xEA, 0xEB, 0xAE, 0x8C, 0xBE, 0xB6, 0xB8, 0xFC,
    /*F8*/  0xAF, 0xB4, 0xFB, 0xDD, 0xDC, 0xA0, 0x72,    0 };


/* EBCDIC to ASCII translation table (Code Page 37) */
#define U 0xA8
char etoa[] = {
    /*      +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/   ' ',    U,    U,    U,    U,    U,    U,    U,
    /*08*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*10*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*18*/     U,    U,    U,    U, 0x0F,    U, 0x1A,    U,
    /*20*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*28*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*30*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*38*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*40*/   ' ',  ' ', 0x83, 0x84, 0x85, 0xA0, 0xC6, 0x86,
    /*48*/  0x87, 0xA4, 0xBD,  '.',  '<',  '(',  '+',  '|',
    /*50*/   '&', 0x82, 0x88, 0x89, 0x8A, 0xA1, 0x8C, 0x8B,
    /*58*/  0x8D, 0xE1,  '!',  '$',  '*',  ')',  ';', 0xAA,
    /*60*/   '-',  '/', 0xB6, 0x8E, 0xB7, 0xB5, 0xC7, 0x8F,
    /*68*/  0x80, 0xA5, 0xDD,  ',',  '%',  '_',  '>',  '?',
    /*70*/  0x9B, 0x90, 0xD2, 0xD3, 0xD4, 0xD6, 0xD7, 0xD8,
    /*78*/  0xDE,  '`',  ':',  '#',  '@', 0x27,  '=',  '"',
    /*80*/  0x9D,  'a',  'b',  'c',  'd',  'e',  'f',  'g',
    /*88*/   'h',  'i', 0xAE, 0xAF, 0xD0, 0xEC, 0xE7, 0xF1,
    /*90*/  0xF8,  'j',  'k',  'l',  'm',  'n',  'o',  'p',
    /*98*/   'q',  'r', 0xA6, 0xA7, 0x91, 0xF7, 0x92, 0xCF,
    /*A0*/  0xE6,  '~',  's',  't',  'u',  'v',  'w',  'x',
    /*A8*/   'y',  'z', 0xAD, 0xA8, 0xD1, 0xED, 0xE8, 0xA9,
    /*B0*/  0x5E, 0x9C, 0xBE, 0xFA, 0xB8, 0xF5, 0xF4, 0xAC,
    /*B8*/  0xAB, 0xF3,  '[',  ']', 0xEE, 0xF9, 0xEF, 0x9E,
    /*C0*/   '{',  'A',  'B',  'C',  'D',  'E',  'F',  'G',
    /*C8*/   'H',  'I', 0xF0, 0x93, 0x94, 0x95, 0xA2, 0xE4,
    /*D0*/   '}',  'J',  'K',  'L',  'M',  'N',  'O',  'P',
    /*D8*/   'Q',  'R', 0xFB, 0x96, 0x81, 0x97, 0xA3, 0x98,
    /*E0*/  0x5C, 0xF6,  'S',  'T',  'U',  'V',  'W',  'X',
    /*E8*/   'Y',  'Z', 0xFD, 0xE2, 0x99, 0xE3, 0xE0, 0xE5,
    /*F0*/   '0',  '1',  '2',  '3',  '4',  '5',  '6',  '7',
    /*F8*/   '8',  '9', 0xFC, 0xEA, 0x9A, 0xEB, 0xE9,    U };


/* EBCDIC graphic escape to ASCII translation table (Code Page 310) */
char getoa[] = {
    /*      +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/   ' ',    U,    U,    U,    U,    U,    U,    U,
    /*08*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*10*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*18*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*20*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*28*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*30*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*38*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*40*/   ' ',  'a',  'b',  'c',  'd',  'e',  'f',  'g',
    /*48*/   'h',  'i',    U,    U,    U,    U,    U,    U,
    /*50*/     U,  'j',  'k',  'l',  'm',  'n',  'o',  'p',
    /*58*/   'q',  'r',    U,    U,    U,    U,    U,    U,
    /*60*/     U,    U,  's',  't',  'u',  'v',  'w',  'x',
    /*68*/   'y',  'z',    U,    U,    U,    U,    U,    U,
    /*70*/  0xD8, 0x5E, 0xFE, 0xD5, 0xD0, 0xD1, 0xD6, 0xD7,
    /*78*/  0xEB,    U,    U,    U,    U,    U,    U,    U,
    /*80*/  0x7E,    U,    U,    U,    U, 0xB3,    U,    U,
    /*88*/     U,    U, 0xC6, 0xC7, 0xF3, 0xA9, 0xBE, 0xB8,
    /*90*/  0x90, 0xDD, 0xDE, 0xDF, 0xDC, 0xDB,    U,    U,
    /*98*/     U,    U, 0xE3, 0xE2,    U, 0xEA,    U, 0xBD,
    /*A0*/  0xFD, 0xF8, 0xC4, 0x07,    U,    U,    U,    U,
    /*A8*/     U,    U, 0xEF, 0xAC, 0x9D,  '[', 0xF2, 0xF8,
    /*B0*/  0xE0, 0xEE, 0xEC, 0xE6, 0xF9,    U, 0xF5, 0x5C,
    /*B8*/  0xF6,    U, 0xB7, 0xB6, 0x98,  ']', 0xF4, 0x7C,
    /*C0*/   '{',    U,    U,    U, 0xC0, 0xDA, 0xC3, 0xC1,
    /*C8*/  0x15,    U, 0xE5, 0xE7, 0xD3, 0xE8, 0xD4, 0xED,
    /*D0*/   '}',    U,    U, 0xC5, 0xD9, 0xBF, 0xB4, 0xC2,
    /*D8*/  0x14,    U, 0x9F,  '!', 0xFC, 0xFB, 0x91, 0xE4,
    /*E0*/  0xCF,    U,    U,    U,    U,    U,    U,    U,
    /*E8*/     U,    U, 0xF0, 0xF1, 0xD2, 0xE9, 0x92, 0xAE,
    /*F0*/     U,    U,    U,    U,    U,    U,    U,    U,
    /*F8*/     U,    U,    U, 0xFA, 0xF7, 0xB5, 0xAF,    U };


/* A list of alphanumeric EBCDIC characters */
char alphanum[] = {
    /*       +0   +1   +2   +3   +4   +5   +6   +7 */
    /*00*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*08*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*10*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*18*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*20*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*28*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*30*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*38*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*40*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*48*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*50*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*58*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*60*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*68*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*70*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*78*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*80*/    0,   1,   1,   1,   1,   1,   1,   1,
    /*88*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*90*/    0,   1,   1,   1,   1,   1,   1,   1,
    /*98*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*A0*/    0,   0,   1,   1,   1,   1,   1,   1,
    /*A8*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*B0*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*B8*/    0,   0,   0,   0,   0,   0,   0,   0,
    /*C0*/    0,   1,   1,   1,   1,   1,   1,   1,
    /*C8*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*D0*/    0,   1,   1,   1,   1,   1,   1,   1,
    /*D8*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*E0*/    0,   0,   1,   1,   1,   1,   1,   1,
    /*E8*/    1,   1,   0,   0,   0,   0,   0,   0,
    /*F0*/    1,   1,   1,   1,   1,   1,   1,   1,
    /*F8*/    1,   1,   0,   0,   0,   0,   0,   0 };


/* Binary value to graphic symbol conversion table */
unsigned char addrconv[] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x40, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    /*08*/  0xC8, 0xC9, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    /*10*/  0x50, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
    /*18*/  0xD8, 0xD9, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    /*20*/  0x60, 0x61, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    /*28*/  0xE8, 0xE9, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    /*30*/  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    /*38*/  0xF8, 0xF9, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F };


/* The following tables are for 3277-GA emulation.  They are based
   on the tables used in the 3277-GA emulator written by Michael
   Goodfellow for the Quicksilver operating systems and on the
   tables used by the MYTE/PCGA package. 			*/


/* GA RPQ ordinal to extended EBCDIC */
unsigned char otoe[64] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    /*08*/  0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
    /*10*/  0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
    /*18*/  0xE7, 0xE8, 0xE9, 0xAD, 0xB7, 0xBD, 0xB0, 0x6D,
    /*20*/  0xBF, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    /*28*/  0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
    /*30*/  0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
    /*38*/  0xA7, 0xA8, 0xA9, 0x9B, 0x4F, 0x9A, 0x5F, 0xBA };


/* GA RPQ ordinals that need GE in front when converting to EBCDIC */
unsigned char otoge[64] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*08*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*10*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*18*/  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    /*20*/  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*28*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*30*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*38*/  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF };


/* Extended EBCDIC to GA RPQ ordinal */
unsigned char etoo[256] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*08*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*10*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*18*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*20*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*28*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*30*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*38*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*40*/  0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00,
    /*48*/  0x03, 0x00, 0x0D, 0x2E, 0x3C, 0x28, 0x2B, 0x7C,
    /*50*/  0x26, 0x00, 0x04, 0x00, 0x06, 0x00, 0x0E, 0x00,
    /*58*/  0x0F, 0x00, 0x21, 0x24, 0x2A, 0x29, 0x3B, 0x7E,
    /*60*/  0x2D, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*68*/  0x00, 0x00, 0x00, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,
    /*70*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*78*/  0x00, 0x00, 0x3A, 0x23, 0x40, 0x27, 0x3D, 0x22,
    /*80*/  0x00, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    /*88*/  0x68, 0x69, 0x0B, 0x00, 0x05, 0x07, 0x0A, 0x09,
    /*90*/  0x0C, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,
    /*98*/  0x71, 0x72, 0x7D, 0x7B, 0xD0, 0x1A, 0xD1, 0x08,
    /*A0*/  0x10, 0x22, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    /*A8*/  0x79, 0x7A, 0x1B, 0x1C, 0x1D, 0x5B, 0x1E, 0x1F,
    /*B0*/  0x5E, 0x11, 0x12, 0x13, 0x14, 0x00, 0x15, 0x5C,
    /*B8*/  0x16, 0x00, 0x7F, 0x17, 0x18, 0x5D, 0x19, 0x60,
    /*C0*/  0x8C, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    /*C8*/  0x48, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*D0*/  0x8D, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    /*D8*/  0x51, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*E0*/  0x00, 0x00, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    /*E8*/  0x59, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*F0*/  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    /*F8*/  0x38, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */


/* Extended EBCDIC (after SF) to GA RPQ ordinal */
unsigned char sftoo[256] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*08*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*10*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00,
    /*18*/  0x00, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00,
    /*20*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*28*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*30*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*38*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*40*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*48*/  0x00, 0x00, 0x85, 0x9B, 0x00, 0x00, 0x86, 0x9C,
    /*50*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*58*/  0x00, 0x00, 0x87, 0x9D, 0x00, 0x00, 0x88, 0x9E,
    /*60*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*68*/  0x00, 0x00, 0x89, 0x9F, 0x00, 0x00, 0x00, 0x00,
    /*70*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*78*/  0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x00,
    /*80*/  0x00, 0xA1, 0x00, 0xA2, 0x01, 0xA3, 0x02, 0xA4,
    /*88*/  0x03, 0xA5, 0xFB, 0x00, 0xF0, 0xB6, 0x8B, 0xB7,
    /*90*/  0x8C, 0xA6, 0x04, 0xA7, 0x06, 0xA8, 0x0E, 0xA9,
    /*98*/  0x0F, 0xAA, 0xFA, 0xB8, 0x00, 0xB9, 0x00, 0xBA,
    /*A0*/  0x8D, 0xBB, 0x80, 0xAB, 0x81, 0xAC, 0x82, 0xAD,
    /*A8*/  0x83, 0xAE, 0xF9, 0xBC, 0xF2, 0xBD, 0x8F, 0xBE,
    /*B0*/  0xFF, 0xBF, 0xFC, 0xC0, 0xFD, 0x00, 0xFE, 0xC1,
    /*B8*/  0x90, 0x00, 0xF8, 0x96, 0xF3, 0x97, 0x91, 0x98,
    /*C0*/  0x00, 0x00, 0x92, 0xAF, 0x00, 0x00, 0x93, 0xB0,
    /*C8*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*D0*/  0x00, 0x00, 0x94, 0xB1, 0x00, 0x00, 0x95, 0xB2,
    /*D8*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*E0*/  0x00, 0x00, 0x8A, 0xB3, 0x00, 0x00, 0x8E, 0xB4,
    /*E8*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*F0*/  0x00, 0x00, 0x00, 0xB5, 0x00, 0x00, 0x00, 0x00,
    /*F8*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */


/* Extended EBCDIC (after GE) to GA RPQ ordinal */
unsigned char getoo[256] = {
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
    /*00*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*08*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*10*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*18*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*20*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*28*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*30*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*38*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*40*/  0x00, 0xA1, 0x00, 0xA2, 0x01, 0xA3, 0x02, 0xA4,
    /*48*/  0x03, 0xA5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*50*/  0x00, 0xA6, 0x04, 0xA7, 0x06, 0xA8, 0x0E, 0xA9,
    /*58*/  0x0F, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*60*/  0x00, 0x00, 0x80, 0xAB, 0x81, 0xAC, 0x82, 0xAD,
    /*68*/  0x83, 0xAE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*70*/  0x00, 0x89, 0xAF, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*78*/  0x9F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*80*/  0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*88*/  0x00, 0x00, 0x0B, 0x92, 0x05, 0x07, 0x0A, 0x09,
    /*90*/  0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /*98*/  0x00, 0x00, 0x7D, 0x7B, 0xB8, 0x1A, 0x84, 0x08,
    /*A0*/  0x10, 0xBB, 0x98, 0xBE, 0xF8, 0x00, 0x00, 0x00,
    /*A8*/  0x00, 0x00, 0x1B, 0x1C, 0x1D, 0x5B, 0x1E, 0x1F,
    /*B0*/  0x5E, 0x11, 0x12, 0x13, 0x14, 0x00, 0x15, 0x5C,
    /*B8*/  0x16, 0x00, 0x7F, 0x17, 0x18, 0x5D, 0x19, 0x60,
    /*C0*/  0x8C, 0xB6, 0x8B, 0xBA, 0xBC, 0xF2, 0xBD, 0x91,
    /*C8*/  0x00, 0x00, 0x85, 0x9B, 0x00, 0x86, 0x00, 0x9C,
    /*D0*/  0x8D, 0xB9, 0xF0, 0xB7, 0x96, 0xF3, 0x8F, 0x97,
    /*D8*/  0x00, 0x00, 0x94, 0xB1, 0x95, 0xB2, 0x87, 0x9D,
    /*E0*/  0x00, 0xFB, 0xFA, 0xF9, 0x00, 0x00, 0x00, 0x00,
    /*E8*/  0x00, 0x00, 0x88, 0x9E, 0x00, 0x8A, 0xB3, 0x8E,
    /*F0*/  0xFF, 0xBF, 0xFC, 0xC0, 0xFD, 0x99, 0xFE, 0xC1,
    /*F8*/  0x90, 0x9A, 0x00, 0x93, 0xB5, 0xB0, 0xB4, 0x00 };
    /*        +0    +1    +2    +3    +4    +5    +6    +7 */
