/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public class AcsByteBufferInputStream
extends InputStream {
    private final ByteBuffer m_buf;

    public AcsByteBufferInputStream(ByteBuffer byteBuffer) {
        this.m_buf = byteBuffer.asReadOnlyBuffer();
        this.m_buf.rewind();
        this.m_buf.mark();
    }

    public AcsByteBufferInputStream(ByteBuffer byteBuffer, boolean bl) {
        this.m_buf = byteBuffer.asReadOnlyBuffer();
        if (bl) {
            this.m_buf.rewind();
        }
        this.m_buf.mark();
    }

    @Override
    public synchronized void mark(int n) {
        this.m_buf.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        try {
            return 0xFF & this.m_buf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_buf.remaining();
        if (0 == n3) {
            return -1;
        }
        int n4 = n2 < n3 ? n2 : n3;
        this.m_buf.get(byArray, n, n4);
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_buf.reset();
    }
}

