/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsDirectoryNames;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
class AcsJarContentsCache
implements Serializable {
    private static volatile transient AcsJarContentsCache m_singleton;
    private static byte[] m_thisProcessUniqueSeed;
    private static final long serialVersionUID = 3L;
    protected static final String JARLOOKASIDE_DONE_FILE = "done.done";
    private volatile transient boolean m_isWriteNeeded = false;
    private final Map<String, ArrayList<String>> m_jarEntries = new ConcurrentHashMap<String, ArrayList<String>>();
    private final Map<String, String> m_manifests = new ConcurrentHashMap<String, String>();
    private byte[] m_uniqueSeed;
    private volatile boolean m_isDevalidated;
    private File m_jarLookasideDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AcsJarContentsCache getCache() {
        if (null != m_singleton) {
            return m_singleton;
        }
        File file = new File(AcsJarContentsCache.getSavedFileName());
        if (!file.exists()) {
            m_singleton = new AcsJarContentsCache();
            AcsJarContentsCache.m_singleton.m_uniqueSeed = AcsJarContentsCache.getThisProcessUniqueSeed();
            return m_singleton;
        }
        boolean bl = false;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            m_singleton = (AcsJarContentsCache)objectInputStream.readObject();
            AcsJarContentsCache.m_singleton.m_isWriteNeeded = false;
            if (!Arrays.equals(AcsJarContentsCache.m_singleton.m_uniqueSeed, AcsJarContentsCache.getThisProcessUniqueSeed())) {
                AcsStartupUtil.addDelayedLog("unique seeds do not match.. not using cache on disk");
                m_singleton = new AcsJarContentsCache();
            }
            AcsStartupUtil.addDelayedLog("Jar cache loaded...");
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
        }
        finally {
            if (bl) {
                file.delete();
                m_singleton = new AcsJarContentsCache();
            }
            try {
                if (null != objectInputStream) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        AcsJarContentsCache.m_singleton.m_uniqueSeed = AcsJarContentsCache.getThisProcessUniqueSeed();
        return m_singleton;
    }

    private static String getSavedFileName() {
        return AcsDirectoryNames.JARCACHE + System.getProperty("file.separator", "/") + ".cache";
    }

    private static synchronized byte[] getThisProcessUniqueSeed() {
        Object object;
        Object object2;
        if (null != m_thisProcessUniqueSeed) {
            return m_thisProcessUniqueSeed;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object3;
            try {
                object2 = new File(AcsLaunchLocator.getLocator().getUrl().toURI());
                byteArrayOutputStream.write(("\n" + new Date(((File)object2).lastModified())).getBytes());
                byteArrayOutputStream.write(("\n" + ((File)object2).length() + "\n").getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2 = new ZipInputStream(AcsJarContentsCache.class.getClassLoader().getResourceAsStream("acsmain.jar"));
                object = null;
                while (null != (object = ((ZipInputStream)object2).getNextEntry())) {
                    byteArrayOutputStream.write(("" + new Date(((ZipEntry)object).getTime()) + "\n").getBytes());
                    byteArrayOutputStream.write(("" + new Date(((ZipEntry)object).getCrc()) + "\n").getBytes());
                }
                ((ZipInputStream)object2).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = AcsProperties.getProperties().getPropertiesList().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                object3 = "" + object.getKey() + "=" + object.getValue() + "\n";
                byteArrayOutputStream.write(((String)object3).getBytes());
            }
            object2 = AcsJarContentsCache.class.getClassLoader();
            object = ((ClassLoader)object2).getParent();
            object3 = null == object ? object2 : object;
            AcsStartupUtil.addDelayedLog("JarCache looking up manifest using classloader: " + object3);
            InputStream inputStream = ((ClassLoader)object3).getResourceAsStream("/jarcacheinfo/acsjarcacheinfo.txt");
            if (null != inputStream) {
                byte[] byArray = new byte[1024];
                int n = 0;
                while (-1 != (n = inputStream.read(byArray))) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = new String((byte[])object2);
        AcsStartupUtil.addDelayedLog("Unique seed:" + (String)object);
        Object object4 = object2;
        m_thisProcessUniqueSeed = (byte[])object4;
        return object4;
    }

    protected AcsJarContentsCache() {
    }

    public AcsJarContentsCache clearJarEntries(URL uRL) {
        this.getOrCreateJarEntries(uRL).clear();
        this.m_isWriteNeeded = true;
        return this;
    }

    public List<String> getJarEntriesForJar(URL uRL) {
        List list = this.m_jarEntries.get(uRL.toString());
        return list;
    }

    public String getManifestOrNull(URL uRL) {
        return this.m_manifests.get(uRL.toString());
    }

    public List<String> getOrCreateJarEntries(URL uRL) {
        ArrayList<String> arrayList = this.m_jarEntries.get(uRL.toString());
        if (null != arrayList) {
            return arrayList;
        }
        arrayList = new ArrayList();
        this.m_isWriteNeeded = true;
        this.m_jarEntries.put(uRL.toString(), arrayList);
        return arrayList;
    }

    public AcsJarContentsCache putJarEntry(URL uRL, String string) {
        this.m_isWriteNeeded = true;
        this.getOrCreateJarEntries(uRL).add(string);
        return this;
    }

    public AcsJarContentsCache putManifest(URL uRL, String string) {
        this.m_isWriteNeeded = true;
        this.m_manifests.put(uRL.toString(), string);
        return this;
    }

    public synchronized AcsJarContentsCache write() throws FileNotFoundException, IOException {
        if (!this.m_isWriteNeeded) {
            AcsStartupUtil.addDelayedLog(" Not writing Jar File Cache. No changes to save.");
            return this;
        }
        if (this.m_isDevalidated) {
            AcsStartupUtil.addDelayedLog(" Not writing Jar File Cache. Cache devalidated.");
            return this;
        }
        File file = new File(AcsJarContentsCache.getSavedFileName());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        objectOutputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
        AcsStartupUtil.addDelayedLog(" Wrote Jar File Cache...");
        this.m_isWriteNeeded = false;
        return this;
    }

    public synchronized void devalidate() {
        this.m_isDevalidated = true;
        new File(AcsJarContentsCache.getSavedFileName()).delete();
    }

    public synchronized File getJarLookasideDir() throws IOException {
        if (null != this.m_jarLookasideDir && new File(this.m_jarLookasideDir.getAbsolutePath() + File.separator + JARLOOKASIDE_DONE_FILE).exists()) {
            return this.m_jarLookasideDir;
        }
        File file = File.createTempFile("acsjar", ".dir");
        file.delete();
        file.mkdirs();
        if (file.isDirectory() && file.exists()) {
            this.m_jarLookasideDir = file;
            this.m_isWriteNeeded = true;
            return this.m_jarLookasideDir;
        }
        throw new IOException("Unable to get Jar lookaside directory");
    }

    static {
        m_thisProcessUniqueSeed = null;
    }
}

