/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.Copyright;
import com.ibm.iaccess.launch.AcsJarContentsCache;
import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsStartupUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

@Copyright(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2012, 2014.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
class AcsLookasideJarsMgr {
    private final List<URL> m_lookasideJars;

    public AcsLookasideJarsMgr(List<URL> list) throws IOException {
        File file = AcsJarContentsCache.getCache().getJarLookasideDir();
        this.m_lookasideJars = new LinkedList<URL>();
        File file2 = new File(file.getAbsolutePath() + File.separator + "done.done");
        boolean bl = !file2.exists();
        int n = 4;
        for (URL uRL : list) {
            if (AcsLaunchPad.isJarFileHiddenFromView(uRL.toString())) continue;
            File file3 = new File(file.getAbsolutePath() + File.separator + ++n + ".dat").getAbsoluteFile();
            if (bl) {
                int n2;
                AcsStartupUtil.addDelayedLog("Creating lookaside data file: " + file3 + "....");
                file3.getParentFile().mkdirs();
                InputStream inputStream = uRL.openConnection().getInputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3), 524288);
                byte[] byArray = new byte[65536];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                }
                inputStream.close();
                ((OutputStream)bufferedOutputStream).close();
                AcsStartupUtil.addDelayedLog("Done creating lookaside data file: " + file3);
            }
            this.m_lookasideJars.add(file3.toURI().toURL());
        }
        if (bl) {
            file2.createNewFile();
        }
    }

    public List<URL> getLookasideJars() {
        return this.m_lookasideJars;
    }
}

