/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsDirectoryNames;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public enum AcsProperties {
    INSTANCE;

    public static final String PREFIX_FOR_ALL_PROPERTIES = "com.ibm.iaccess.";
    Properties m_configProps;
    private volatile File m_userBaseDir;
    private static String m_productHelpSubDir;
    private static final String m_productServiceSubDir = "iAccessClient_Service";
    private static final String m_productSubDir = "iAccessClient";
    private static final String m_propFileResourceName = "AcsConfig.properties";
    private static final String m_propCommandLine = "ibmi.acs.configuration";

    public static AcsProperties getProperties() {
        return INSTANCE;
    }

    /*
     * Exception decompiling
     */
    private AcsProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String processKeywordsForProperty(String string) {
        if (null == string || string.isEmpty()) {
            return string;
        }
        String string2 = string.trim();
        string2 = string2.replaceAll("(?i:\\{USER\\})", Matcher.quoteReplacement(System.getProperty("user.name")));
        try {
            string2 = string2.replaceAll("^(?i:\\{PRODUCTDIR\\})", Matcher.quoteReplacement(this.getProductDirKeywordVal() + File.separatorChar));
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        try {
            string2 = string2.replaceAll("^(?i:\\{ROOT\\})", Matcher.quoteReplacement(this.getRootDirKeywordVal() + File.separatorChar));
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        string2 = string2.replaceAll("^(?i:\\{TEMPDIR\\})", Matcher.quoteReplacement(System.getProperty("java.io.tmpdir") + File.separatorChar));
        string2 = string2.replaceAll("^(?i:\\{CWD\\})", Matcher.quoteReplacement(new File(".").getAbsolutePath() + File.separatorChar));
        string2 = string2.replaceAll("^(?i:\\{HOME\\})", Matcher.quoteReplacement(System.getProperty("user.home") + File.separatorChar));
        string2 = string2.replaceAll("^(?i:\\{DEFAULT\\})", Matcher.quoteReplacement(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath() + File.separatorChar));
        if (string2.contains("{")) {
            String string3 = "Unable to use string '" + string + "' as part of configuration setting! Exiting";
            new IOException(string3).printStackTrace();
            AcsStartupUtil.addDelayedLog(string3);
            AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
            JOptionPane.showMessageDialog(null, string3);
            System.exit(-7);
        }
        return string2;
    }

    private static boolean isFileARoot(File file) {
        File file2 = file;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((FileSystemView.getFileSystemView().isDrive(file2) || FileSystemView.getFileSystemView().isFileSystemRoot(file2)) && FileSystemView.getFileSystemView().isFileSystem(file2)) {
            return true;
        }
        File[] fileArray = File.listRoots();
        if (null != fileArray) {
            for (File file3 : fileArray) {
                if (!file2.equals(file3)) continue;
                return true;
            }
        }
        return file2.getAbsolutePath().matches("^[/]+(dev|mnt|media)[/]+[0-9a-zA-Z]+[/]*$");
    }

    private String getRootDirKeywordVal() throws NullPointerException, SecurityException, URISyntaxException, IOException {
        File file = AcsLaunchLocator.getLocator().getLocationType() == AcsLaunchLocator.LocationType.WEBSTART ? FileSystemView.getFileSystemView().getDefaultDirectory() : new File(AcsLaunchLocator.getLocator().getUrl().toURI());
        File file2 = null;
        while (true) {
            if (AcsProperties.isFileARoot(file)) {
                return file.getAbsolutePath();
            }
            file2 = file.getParentFile();
            if (null == file2) break;
            file = file2;
        }
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        throw new IOException();
    }

    private String getProductDirKeywordVal() throws NullPointerException, SecurityException, URISyntaxException, IOException {
        File file = new File(AcsLaunchLocator.getLocator().getUrl().toURI());
        if ((file = file.getParentFile()).isDirectory()) {
            return file.getAbsolutePath();
        }
        throw new IOException();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.m_configProps.getProperty(string);
        if (null == string3) {
            return string2;
        }
        if ((string3 = string3.trim()).length() == 0) {
            return string2;
        }
        return string3;
    }

    Properties getPropertiesList() {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : this.m_configProps.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public boolean isLmInProcess() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.InProcessLm", Boolean.FALSE.toString()));
    }

    public boolean isJavaAwtDesktopAllowed() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.javaAwtDesktopAllowed", Boolean.TRUE.toString()));
    }

    public boolean isLocalJarCaching() {
        String string = this.getProperty("com.ibm.iaccess.DataCache", Boolean.FALSE.toString());
        if (null != string && string.trim().equalsIgnoreCase("auto")) {
            switch (AcsLaunchLocator.getLocator().getLocationType()) {
                case FILE_PROBABLY_LOCAL: 
                case WEBSTART: 
                case FILE_UNKNOWN: {
                    return false;
                }
                case FILE_PROBABLY_REMOTE: {
                    return true;
                }
            }
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isInMemoryJarCaching() {
        String string = this.getProperty("com.ibm.iaccess.InMemCache", Boolean.FALSE.toString());
        if (null != string && string.trim().equalsIgnoreCase("auto")) {
            switch (AcsLaunchLocator.getLocator().getLocationType()) {
                case FILE_PROBABLY_LOCAL: 
                case WEBSTART: 
                case FILE_UNKNOWN: {
                    return false;
                }
                case FILE_PROBABLY_REMOTE: {
                    return true;
                }
            }
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isGTKAllowed() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.GTKLookAllowed", Boolean.TRUE.toString()));
    }

    public boolean isInProcessDT() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.InProcessDT", Boolean.TRUE.toString()));
    }

    public boolean isKerberosAutoConfig() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.KerberosAutoConfig", Boolean.TRUE.toString()));
    }

    public boolean isKerberosWindowsJGSSMode() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.WindowsJGSS", Boolean.FALSE.toString()));
    }

    public int getFFDCLogSizeInMB() {
        int n = -1;
        try {
            n = Integer.parseInt(this.getProperty("com.ibm.iaccess.FFDCLogSizeMb", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public List<String> getExcludedComps() {
        String string = this.getProperty("com.ibm.iaccess.ExcludeComps", "");
        String[] stringArray = string.split("[,]+");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            String string3 = string2.trim().toLowerCase(Locale.US);
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString() + ":\n");
        for (Map.Entry<Object, Object> entry : this.m_configProps.entrySet()) {
            stringBuilder.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return stringBuilder.toString();
    }

    public File getProductDirectory() {
        File file = new File(this.getIBMDirectory() + AcsProperties.fileSep() + m_productSubDir + AcsProperties.fileSep());
        file.mkdirs();
        return file;
    }

    public synchronized String makeRestrictedDir() throws IOException {
        File file = new File(AcsDirectoryNames.PWCACHES);
        file.mkdirs();
        file.setExecutable(false);
        file.setExecutable(true, true);
        file.setWritable(false);
        file.setWritable(true, true);
        file.setReadable(false);
        file.setReadable(true, true);
        boolean bl = true;
        bl = bl && file.exists();
        bl = bl && file.canRead();
        boolean bl2 = bl = bl && file.canWrite();
        if (!bl) {
            throw new IOException("Unable to create user-restricted directory");
        }
        return file.getCanonicalPath();
    }

    protected File getIBMDirectory() {
        File file = new File(this.getUserBaseDirectory() + AcsProperties.fileSep() + "IBM" + AcsProperties.fileSep());
        file.mkdirs();
        return file;
    }

    public String getMyDocumentsSubDir(String string) {
        String string2 = AcsProperties.fileSep() + "IBM" + AcsProperties.fileSep() + m_productSubDir + AcsProperties.fileSep();
        String string3 = this.getUserBaseDirectory().getAbsolutePath() + string2 + string;
        new File(string3).mkdirs();
        return string3;
    }

    private static String fileSep() {
        return File.separator;
    }

    public File getServiceDirectory() {
        File file = new File(this.getIBMDirectory() + AcsProperties.fileSep() + m_productServiceSubDir + AcsProperties.fileSep());
        file.mkdirs();
        return file;
    }

    public String getHelpDirectory() {
        File file = new File(this.getIBMDirectory() + AcsProperties.fileSep() + m_productHelpSubDir + AcsProperties.fileSep());
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public String getJarCacheDirectory() {
        File file;
        String string = null;
        String string2 = System.getProperty("com.ibm.iaccess.JarCache");
        if (null != string2 && (file = new File(string2)).exists() && file.canWrite()) {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                AcsStartupUtil.addDelayedLog(exception);
                new IOException("Unable to use '" + string2 + "' for JarCache.").printStackTrace();
            }
        }
        if (null == string) {
            string = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        }
        string = string + AcsProperties.fileSep() + "IBM" + AcsProperties.fileSep() + m_productSubDir + AcsProperties.fileSep() + "JarCache";
        new File(string).mkdirs();
        return string;
    }

    private File getUserBaseDirectory() {
        if (null != this.m_userBaseDir) {
            return this.m_userBaseDir;
        }
        String string = null;
        String string2 = this.getProperty("com.ibm.iaccess.AcsBaseDirectory");
        if (null != string2) {
            File file = new File(string2);
            file.mkdirs();
            if (file.exists() && file.canWrite() && file.isDirectory()) {
                try {
                    string = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    AcsStartupUtil.addDelayedLog(exception);
                    String string3 = "Unable to use '" + string2 + "' as base directory for user configuration! Exiting";
                    new IOException(string3).printStackTrace();
                    AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
                    JOptionPane.showMessageDialog(null, string3);
                    System.exit(-7);
                }
            } else {
                String string4 = "Unable to use '" + string2 + "' as base directory for user configuration! Exiting";
                new IOException(string4).printStackTrace();
                AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
                JOptionPane.showMessageDialog(null, string4);
                System.exit(-7);
            }
        }
        if (null == string) {
            string = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        }
        this.m_userBaseDir = new File(string);
        return this.m_userBaseDir;
    }

    private static Properties loadPropertiesFromInputStream(Properties properties, InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string = null;
        while (null != (string = bufferedReader.readLine())) {
            int n;
            if ((string = string.trim()).isEmpty() || string.charAt(0) == '#' || (n = string.indexOf(61)) <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(1 + n);
            if (string3.isEmpty() || string2.isEmpty()) continue;
            properties.setProperty(string2, string3);
        }
        return properties;
    }

    public String getBrowser() {
        return this.getProperty("com.ibm.iaccess.browser", null);
    }

    public String getFileOpenCommand() {
        return this.getProperty("com.ibm.iaccess.fileopen", null);
    }

    public AutoImportFile getAutoImportFile() {
        String string = this.getProperty("com.ibm.iaccess.autoimport.version", null);
        String string2 = this.getProperty("com.ibm.iaccess.autoimport", null);
        return null == string || null == string2 || string.isEmpty() || string2.isEmpty() ? null : new AutoImportFile(string, string2);
    }

    public static boolean checkIfUserDirsAreWriteable() {
        File[] fileArray;
        AcsProperties acsProperties = AcsProperties.getProperties();
        for (File file : fileArray = new File[]{acsProperties.getProductDirectory(), acsProperties.getServiceDirectory(), new File(AcsDirectoryNames.USER_SETTINGS), new File(AcsDirectoryNames.DUMPS)}) {
            if (!file.exists() && !file.mkdirs()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            if (!file.canRead()) {
                return false;
            }
            if (file.canWrite()) continue;
            return false;
        }
        return true;
    }

    public int getKerberosBufferSizeInKB() {
        int n = -1;
        try {
            n = Integer.parseInt(this.getProperty("com.ibm.iaccess.KerberosTicketKb", "256"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n <= 0) {
            n = 256;
        }
        return Math.min(n, 6144);
    }

    public String getTLSProtocolList() {
        return this.getProperty("com.ibm.iaccess.TLSProtos", null);
    }

    public boolean isTLSProviderOrder() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.TLSProviderOrder", Boolean.FALSE.toString()));
    }

    static {
        m_productHelpSubDir = "iAccessClient_Help";
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class AutoImportFile {
        public final String m_version;
        public final String m_file;

        private AutoImportFile(String string, String string2) {
            this.m_version = string;
            this.m_file = string2;
        }
    }
}

