/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public final class AcsStartupUtil {
    private static List<Object> m_delayedLogEntries = new ArrayList<Object>();

    public static void addDelayedLog(Object object) {
        if (null != m_delayedLogEntries) {
            m_delayedLogEntries.add(object);
        }
    }

    public static List<Object> getDelayedLogs() {
        return null == m_delayedLogEntries ? new ArrayList() : m_delayedLogEntries;
    }

    public static void invalidateDelayedLogBuffer() {
        m_delayedLogEntries = null;
    }

    protected static byte[] byteArrayFromByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byte[] byArray = new byte[byteBuffer2.capacity()];
        byteBuffer2.rewind();
        byteBuffer2.get(byArray);
        return byArray;
    }

    private static ByteBuffer readEntireZipEntryToBuffer(ZipInputStream zipInputStream, int n) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
        ReadableByteChannel readableByteChannel = Channels.newChannel(bufferedInputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        for (int i = 0; i < n; i += readableByteChannel.read(byteBuffer)) {
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    protected static ByteBuffer readEntireZipEntryToBuffer(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int n;
        int n2 = (int)zipEntry.getSize();
        if (0 < n2) {
            return AcsStartupUtil.readEntireZipEntryToBuffer(zipInputStream, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        byte[] byArray = new byte[524288];
        while (-1 != (n = zipInputStream.read(byArray, 0, byArray.length))) {
            n3 += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        byteBuffer.put(byteArrayOutputStream.toByteArray(), 0, n3);
        return byteBuffer;
    }

    protected static ByteBuffer readEntireNestedJarToBuffer(String string) throws IOException {
        int n;
        InputStream inputStream = AcsStartupUtil.class.getClassLoader().getResourceAsStream(string.replaceFirst("^/", ""));
        if (null == inputStream) {
            throw new FileNotFoundException(string);
        }
        int n2 = inputStream.available();
        int n3 = n2 > 0 ? n2 : 0x400000;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n4 = Math.min(0x100000, n3);
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (-1 != (n = inputStream.read(byArray, 0, byArray.length))) {
            n5 += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
        byteBuffer.put(byteArrayOutputStream.toByteArray(), 0, n5);
        return byteBuffer;
    }

    private AcsStartupUtil() {
    }

    public static boolean blastFileRecursively(File file) {
        if (null == file || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            boolean bl = true;
            File[] fileArray = file.listFiles();
            if (null != fileArray) {
                for (File file2 : fileArray) {
                    bl = bl && AcsStartupUtil.blastFileRecursively(file2);
                }
            }
            return bl && file.delete();
        }
        return file.delete();
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class AcsPropertyUtf8Control
    extends ResourceBundle.Control {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IOException {
            AcsStartupUtil.addDelayedLog("new bundle requested, name=" + string + ", format=" + string2 + ", loader=" + classLoader + ", locale=" + locale);
            if ("java.properties".equals(string2)) {
                String string3 = this.toResourceName(this.toBundleName(string, locale), "properties");
                PropertyResourceBundle propertyResourceBundle = null;
                InputStream inputStream = null;
                if (bl) {
                    URLConnection uRLConnection;
                    URL uRL = classLoader.getResource(string3);
                    if (null != uRL && null != (uRLConnection = uRL.openConnection())) {
                        uRLConnection.setUseCaches(false);
                        inputStream = uRLConnection.getInputStream();
                    }
                } else {
                    inputStream = classLoader.getResourceAsStream(string3);
                }
                if (inputStream != null) {
                    try {
                        propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
                    }
                    finally {
                        inputStream.close();
                    }
                }
                return propertyResourceBundle;
            }
            if ("java.class".equals(string2)) {
                try {
                    Class<?> clazz = classLoader.loadClass(this.toBundleName(string, locale));
                    if (ResourceBundle.class.isAssignableFrom(clazz)) {
                        return (ResourceBundle)clazz.newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return null;
            }
            throw new IllegalArgumentException(string2);
        }
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2014. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    static class _ {
        private static final String BUNDLE_NAME = "com.ibm.iaccess.launchmri.launch";
        private static final ResourceBundle RESOURCE_BUNDLE;

        private _() {
        }

        protected static String _(String string) {
            String string2 = '!' + string + '!';
            try {
                return null == RESOURCE_BUNDLE ? string2 : RESOURCE_BUNDLE.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return string2;
            }
        }

        static {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault(), AcsStartupUtil.class.getClassLoader(), new AcsPropertyUtf8Control());
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            RESOURCE_BUNDLE = resourceBundle;
        }
    }
}

