#include <sys/types.h>
#include <sys/timeb.h>

static base_64(short x)
{
	if (x <= 9)
		return x + '0';
	x -= 9;
	if (x <= 26)
		return x + 'A';
	x -= 26;
	return x + 'a';
}

new_salt(char *salt)
{
	int             salt_time;
	struct timeb    tms;

	ftime(&tms);
	salt_time = (tms.millitm / 100 + tms.time * 10) & 07777;
	salt[0] = base_64(salt_time & 037);
	salt[1] = base_64((salt_time >> 6) & 037);
	salt[2] = '\0';
}
