/*======================================================================================================*/
/* Telespace map plugin, GUI										*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* - FollowCamera object class										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Nov-19 16:54:50									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <stdio.h>

#include <EMalloc.h>
#include <EPlugins.h>


#include <E3D/EMacros.h>
#include <E3D/3DWindow.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <Xe/Matrix.h>
#include <Xe/Scale.h>


#include "Map.h"

#include "FollowCamera.h"



// FollowCamera Object
//
#define ROffset(field) (void*)(EPtrOffset(E3dFollowCameraInfo, field))
EResource _FollowCameraResources[]=
{
 { "Density",	EResFLOAT32,	ROffset(Density), NULL },
 { "",		EResNULL,	NULL, NULL }
};
#undef ROffset


// Class template
//
E3dFollowCameraInfo	TSMap_FollowCameraInfo;


static Widget		_DensityScaleW;


static Arg		Args[256];
static Cardinal		ArgCnt;


enum
{
 CR_SET_DENSITY
};


/*==============================================*/
/* Widget callback for the FollowCamera class	*/
/*==============================================*/
static void _CB_FollowCamera(Widget LI, XtPointer LClientData, XtPointer LCallData)
{
 E3dFollowCameraInfo*	LInfo;
 unsigned int		LC;


 switch((int)LClientData)
 {
  case CR_SET_DENSITY:
   for(LC=0;LC<_NumOfTelespaceModels;LC++)
   {
    LInfo=(E3dFollowCameraInfo*)E3d_ModelInfoByClass(TSMap_EditedModels[LC], TSMap_FollowCameraInfo.Class);

    if(LInfo)
    {
     LInfo->Density=((XeScaleCallbackStruct*)LCallData)->FloatValue;
     break;
    }
   }
  break;
 }
}


/*==============================================*/
/* Update GUI from the class record		*/
/*==============================================*/
void TS_FollowCameraUpdateGUI()
{
 E3dFollowCameraInfo*	LInfo;
 unsigned int		LC;


 for(LC=0;LC<_NumOfTelespaceModels;LC++)
 {
  LInfo=(E3dFollowCameraInfo*)E3d_ModelInfoByClass(TSMap_EditedModels[LC], TSMap_FollowCameraInfo.Class);

  if(LInfo) { XeScaleSetValueD(_DensityScaleW, LInfo->Density, False);break; }
 }
}


/*==============================================*/
/* Create Matrix widget				*/
/*==============================================*/
Widget TS_FollowCameraCreateMatrix(Widget LParentW)
{
 Widget	LMatrixW;


 EXtStart;
 EXtSetArg(XeNshadowThickness, 0);
 EXtSetArg(XeNbackground, EGUI_BackgroundColor);
 EXtSetArg(XeNorientation, XeVERTICAL);
 EXtSetArg(XeNxSpacing, 4);EXtSetArg(XeNySpacing, 7);
 LMatrixW=XtCreateWidget("FollowCameraMatrixW", xeMatrixWidgetClass, LParentW, Args, ArgCnt);

 EXtStart;
 EXtSetArg(XeNscaleLengthInPixels, 200);
 EXtSetArg(XeNtextFieldDigits, 8);EXtSetArg(XeNdecimalPoints, 2);
 EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000000);EXtSetArg(XeNvalue, (int)(TSMap_FollowCameraInfo.Density*100.0));
 EXtSetArg(XeNincrement, 10);
 EXtSetArg(XeNorientation, XeHORIZONTAL);
 E3dp_SetScaleArgs(Args, &ArgCnt);
 _DensityScaleW=XtCreateManagedWidget("Density:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
 XtAddCallback(_DensityScaleW, XeNvalueChangedCallback, (XtCallbackProc)_CB_FollowCamera, (XtPointer)CR_SET_DENSITY);

 return(LMatrixW);
}


/*==============================================*/
/* EditProc for the "FollowCamera" Model type	*/
/*==============================================*/
static int _EditProc(E3dModel* LModel, E3dModelInfo* LInfo)
{
 TSTmpl_EditProc(E3dFollowCamera, TSMap_FollowCamera);
}


/*==============================================*/
/* Initialize class				*/
/*==============================================*/
void TS_FollowCameraInit()
{
 E3dModelClass	LFollowCameraClass=
   {
    "FollowCamera",			// Name
    sizeof(E3dFollowCameraInfo),	// StructSize
    _EditProc,				// EditProc
    NULL,				// RemoveProc
    NULL,				// DestroyProc
    _FollowCameraResources		// Resources
   };

 TSMap_FollowCameraInfo.Class=E3d_ModelClassRegister(&LFollowCameraClass);
 TSMap_FollowCameraInfo.Density=100.0;
}


/*==============================================*/
/* Deactivate class				*/
/*==============================================*/
void TS_FollowCameraDeactivate()
{
 if(TSMap_FollowCameraInfo.Class) E3d_ModelClassDeactivate(TSMap_FollowCameraInfo.Class);
}
