/*======================================================================================================*/
/* Telespace map plugin header file									*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Nov-23 22:30:49									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#ifndef _TSMap_h
#define _TSMap_h


enum
{
 E3dTS_STATIONARY=1,
 E3dTS_STREETLIGHT,
 E3dTS_MOVER,
 E3dTS_FOLLOWCAMERA
};

enum
{
 E3dTS_DIR_BUILDING=1,
 E3dTS_DIR_VEHICLE,
 E3dTS_DIR_MISC
};



extern EPlugin*			TSMap_Plugin;


extern void			TSMap_CollectModelsToEdit();

extern E3dModel**		TSMap_EditedModels;
extern unsigned int		_NumOfTelespaceModels;


extern int	TSMap_CurrentModelType;
extern int	TSMap_CurrentModelDir;



/*----------------------*/
/* From gui.c		*/
/*----------------------*/
extern void		TSMap_PopupDialog(E3dModel* LModel);


/*----------------------------------------------------------------------*/
/* Template function for setting and initializing the class of a Model	*/
/*----------------------------------------------------------------------*/
#define M_SetClassOnModel(mType, mPrototype)\
 mPrototype##Info.Directory = TSMap_CurrentModelDir;\
/* if(LModel->Info) E3d_ModelInfoRemoveAll(LModel);*/\
 {\
  LInfo=E3d_ModelInfoAdd(LModel, mPrototype##Info.Class);\
  if(LInfo)\
  {\
   memcpy(LInfo, &mPrototype##Info, sizeof(mType##Info));\
  }\
  LNameStr=LInfo->Class->Name;\
  LNewTelespaceModels++;\
 }





/*----------------------------------------------------------------------*/
/* Template EditProc for the Telespace Model classes			*/
/*----------------------------------------------------------------------*/
#define TSTmpl_EditProc(mType, mTemplate)\
{\
 E3dTpl_ModelMinEditProc(mType, mTemplate);\
\
 if(TSMap_EditedModels)\
 {\
  unsigned int	LC;\
\
\
/* Is this Model still being edited?	*/\
\
  for(LC=0;LC<_NumOfTelespaceModels;LC++) if(TSMap_EditedModels[LC]==LModel) return(E3dEDITP_IN_USE);\
 }\
\
 if(TSMap_EditedModels)\
 {\
/* Remove lock from previously edited Models and clear list	*/\
\
  E3d_ModelsDelLock(TSMap_EditedModels, _NumOfTelespaceModels);\
  EFree(TSMap_EditedModels);TSMap_EditedModels=NULL;_NumOfTelespaceModels=0;\
\
/* E3d_PopupDialog will increment this, but the dialog is already up...	*/\
\
  TSMap_Plugin->LockCount-=1;\
 }\
\
 TSMap_CollectModelsToEdit();\
\
 E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);\
\
 TSMap_PopupDialog(LModel);\
\
 return(E3dEDITP_EDITING);\
}


#endif	// _TSMap_h
