/*======================================================================================*/
/* 3DPanel										*/
/*											*/
/* - Time panel										*/
/*											*/
/* AUTHOR:	Gabor Nagy								*/
/* DATE:	1996-Nov-03 23:01:18							*/
/*											*/
/* 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================*/
#include <stdio.h>

#include <EGUI/Dialog.h>

#include <Image/TimePanel.h>
#include <Image/Movie.h>
#include <Image/Image.h>

#include <E3D/XGUI.h>

#ifndef _E3D3DWindow_h
#include <E3D/3DWindow.h>
#endif


static Arg		Args[256];
static Cardinal		ArgCnt;


Widget		E3dp_TimePanelW=NULL;
EaTimePanel*	E3dp_TimePanel=NULL;



/*======================================*/
/* TimePanel callback-handler		*/
/*======================================*/
static void _CB_Time(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 EaTimePanelCallbackStruct*	LTimePanelCBS;
 EaTimePanel*			LTimePanel;
 E3dScene*			LScene=E3d_Scene;
 double				LFrame;


 LTimePanel=(EaTimePanel*)LGUIItem;
 LTimePanelCBS=(EaTimePanelCallbackStruct*)LCallData;

 switch(LTimePanelCBS->Reason)
 {
  case EaCR_SET_CURRENT_FRAME:
   LFrame=LTimePanelCBS->Frame;
   if(LScene->Frame!=LFrame)
   {
    unsigned int	LC, LN=LScene->NumOfAnimations,
			LChanged;


    LScene->Frame=LFrame;

// The SetFrameProcs should set the flags of this field to tell us what changed
//
    LScene->Changed=0;

    if(LN)
    {
     E3dAnimation**	LAnimations=LScene->Animations;
     E3dAnimation*	LAnimation;
     E3dAnimationClass*	LClass;

     for(LC=0;LC<LN;LC++)
     {
      LAnimation=LAnimations[LC];
      LClass=LAnimation->Class;

      if(LClass->SetFrameProc) LClass->SetFrameProc(LAnimation, LFrame);
     }
    }

    LChanged=LScene->Changed;

    E3dp_WindowsRedrawByChangeFlags(LChanged);


// Call Scene callbacks
//
/*
    if(LModels)
    {
     LCBS.Reason=LReason;
     LCBS.Models=LModels;
     LCBS.NumOfModels=LNumOfModels;
     E3d_CallCallbacks(LScene, LScene->Callbacks, LScene->NumOfCallbacks, &LCBS);
     EFree(LModels);
    }
*/
   }
  break;
 }
}

extern Widget	Ea_CreateTimeCodeDisplay(EaTimePanel* LTimePanel, Widget LParentW);


/*======================================*/
/* Turn TimePanels on/off		*/
/*======================================*/
void E3dp_SetTimePanel(E3dPanel* L3DPanel, EBool LSwitch, EBool LSwitchExt)
{
 if(E3dp_TimePanel==NULL)
 {
  EXtStart;
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNshadowType, XeSHADOW_OUT);
  EXtSetArg(XeNbackground, MenuBackgroundColor);
  if((E3dp_TimePanel=Ea_TimePanelCreate("TimePanel", L3DPanel->TopMatrixW, Args, ArgCnt, 0, 0, 299, 30.0, EaSLIDER_FRAME_INT, LSwitch, FALSE))!=NULL)
  {
   Ea_TimePanelAddCallback(E3dp_TimePanel, _CB_Time, (EPointer)L3DPanel);
   E3dp_TimePanelW=E3dp_TimePanel->TopMatrixW;

// Add the time-code display to the StatusPanel
//
   L3DPanel->TimeExtPanelMatrixW=Ea_CreateTimeCodeDisplay(E3dp_TimePanel, L3DPanel->StatusPanelW);

   XtManageChild(E3dp_TimePanel->SliderPanelW);
   if(LSwitch) XtManageChild(E3dp_TimePanelW);
  }
 }
 else
 {
  if(LSwitch||LSwitchExt)
  {
//   Ea_TimePanelsSwitch(E3dp_TimePanel, LSwitch, LSwitchExt);
   XtManageChild(E3dp_TimePanelW);	//XtManageChild(L3DPanel->TimeExtPanelMatrixW);
  }
  else
  {
   XtUnmanageChild(E3dp_TimePanelW);	//XtUnmanageChild(L3DPanel->TimeExtPanelMatrixW);
  }
 }

 E3dp_Prefs.TimePanelOn=LSwitch;E3dp_Prefs.TimeExtPanelOn=LSwitchExt;
}
