/*======================================================================*/
/* Color library GUI							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1995-Sep-12 22:43:11					*/
/*									*/
/* ColorPanel Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef	_EColorPanel_h
#define	_EColorPanel_h

#include <Color/ColorWheel.h>
#include <EGUI/EGUI.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern EcRGBAiColor	Ec_DefaultColors[];


#define	EcSLIDER_WIDTH	16
#define	EcSLIDER_LENGTH	22


#define Ec_MAX_NUM_OF_COLORS	65536	// Max 16-bit palette

// Color definition modes
//
enum
{
 EcSLIDERS_RGBA=0,
 EcSLIDERS_HSVA
};

// Color-component representation modes
//
enum
{
 EcINTEGER_0_255=0,
 EcINTEGER_0_65535,
 EcFLOAT_0_1
};

typedef struct
{
 Widget			TopMatrixW,
			ColCmdRowColW, CopyColW, ExgColW, SpreadColW, LightM,
			PaletteFrameW, PaletteDrawW,
			DrawColorsFrameW, ColorSwatchDrawW,
			RScaleW, GScaleW, BScaleW, AScaleW; 
 void			(*ColorChangedCallback)();
 EPointer		ColorChangedCallbackClientData;
 int			ComponentType;
 int			NumOfAllocatedColors;			// Number of colors allocated
 int			NumOfColors, Depth;			// Current number of colors and bitplane depth in the current palette
 EcRGBAiColor*		RGBAiColors;				// The array of colors in the palette
 EcRGBAfColor*		RGBAfColors;				// The array of colors in the palette
 Colormap		X_Colormap;				// Associated X Colormap of this ColorPanel
 unsigned long*		X_PixelValues;				// Pointer to the current array of X11 color pixel values
 int			PaletteWidth, PaletteHeight, PaletteColumns, PaletteRows;
 int			ColButtWidth, ColButtHeight;
 int			DrawColor0, DrawColor1, DrawColor2;
 EcColorWheelRec*	ColorWheel;
 EBool			AlphaOn;
 EBool			Truecolor;				// All the drawing widgets have truecolor visual
 EBool			PaletteValid;
} EcColorPanelRec;


typedef struct
{
 int		reason;
 int		NumOfColors;	// Number of colors that were changed
 int*		ColorIDs;	// IDs of colors that were changed
} EcColorPanelCallbackStruct;

// Callbacks
//
typedef void	(*EcColorPanelCallbackProc)(EcColorPanelRec*, EPointer, EPointer);



extern Pixmap		Ec_RedRampPixmap, Ec_GreenRampPixmap, Ec_BlueRampPixmap, Ec_AlphaRampPixmap;
extern EguiItem		EGUI_ColorDialogCreate(char* LTitle, EguiItem LParent, int LColorType, EBool LEditAlpha, void (*LColorChangedCallback)(EcColorPanelRec*, EPointer, EPointer), EPointer LColorChangedClientData);

extern EcColorPanelRec*	Ec_VaCreateColorPanel(Widget LParentW, char* LName, ...);
extern void		Ec_FreeColorPanel(EcColorPanelRec* LColorPanel);
extern void		Ec_FreeColorPanels();

extern void		Ec_ColorPanelUpdateColorSwatches(EcColorPanelRec* LColorPanel);

extern void		Ec_ColorPanelSetRGBfColor(EcColorPanelRec* LColorPanel, int LColorIndex, EcRGBfColor* LRGBfColorIn);
extern void		Ec_ColorPanelSetRGBAfColor(EcColorPanelRec* LColorPanel, int LColorIndex, EcRGBAfColor* LRGBAfColorIn);
extern void		Ec_ColorPanelSetRGBAiColor(EcColorPanelRec* LColorPanel, int LColorIndex, EcRGBAiColor* LRGBAiColorIn);

extern void		Ec_ColorDialogSetRGBAiColor(EguiItem LDialog, int LColorIndex, EcRGBAiColor* LRGBAiColorIn);


extern Widget		Ec_CreateRGBfColorSwatch(char* LName, Widget LParentW, Widget* LLabeWRet, Widget LTAW, EcRGBfColor* LRGBfColor, XtCallbackProc LCallback, XtPointer LClientData);
extern Widget		Ec_CreateRGBAiColorSwatch(char* LName, Widget LParentW, Widget* LLabeWRet, Widget LTAW, EcRGBAiColor* LRGBAiColor, XtCallbackProc LCallback, XtPointer LClientData);

extern EBool		Ec_ResizePalette();
extern void		Ec_SetPaletteColors();
extern EBool		Ec_SetupColorPanel(EcColorPanelRec* LColorPanel, int LNumOfColors, int LDepth, Colormap LXColormap, EcRGBAiColor* LColors, unsigned long* LPixelValues);
extern EBool		Ec_RedrawColorPanel(EcColorPanelRec* LColorPanel);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EColorPanel_h
