/*======================================================================*/
/* X Window specific color functions					*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Oct-21 22:32:48					*/
/*									*/
/* ColorLib Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EXColor_h
#define _EXColor_h

#include <EParam.h>

#include <Color/Color.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


extern Pixel	Ec_XGetColor(Display* LDisplay, Colormap LColormap, char* LColorName);
extern Pixel	Ec_XGetRGBColor(Display* LDisplay, Colormap LColormap, int LR, int LG, int LB);

extern Pixel	Ec_XGetRGBiColor(Display* LDisplay, Colormap LColormap, EcRGBiColor* LColor);

extern Pixel	Ec_XGetRGBAiColor(Display* LDisplay, Colormap LColormap, EcRGBAiColor* LColor);
extern Pixel	Ec_XGetRGBfColor(Display* LDisplay, Colormap LColormap, EcRGBfColor* LColor);
extern Pixel	Ec_XGetRGBAp8Color(Display* LDisplay, Colormap LColormap, EcRGBAp8Color LColor);

extern void	Ec_XStoreSetRGBColor(Display* LDisplay, Colormap LColormap, unsigned long LPixelValue, int LR, int LG, int LB);
extern void	Ec_XStoreRGBp8Color(Display* LDisplay, Colormap LColormap, Pixel LPixelValue, EcRGBAp8Color LColor);

extern void	Ec_XStoreRGBColorShade(Display* LDisplay, Colormap LColormap, unsigned long LPixelV, int LR, int LG, int LB, double LFactor);

extern void	Ec_XStoreRGBAiColor(Display* LDisplay, Colormap LColormap, Pixel LPixelValue, EcRGBAiColor* LColor);
extern void	Ec_XStorePRGBAColor(Display* LDisplay, Colormap LColormap, Pixel LPixelValue, EcRGBAp8Color LColor);

extern void	Ec_XStoreRGBAiColorShade(Display* LDisplay, Colormap LColormap, Pixel LPixelValue, EcRGBAiColor* LColor, double LBrightnessFactor);
extern void	Ec_XStoreRGBAp8ColorShade(Display* LDisplay, Colormap LColormap, Pixel LPixelValue, EcRGBAp8Color LColor, double LBrightnessFactor);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EXColor_h
