/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Generic "Animation" header file					*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Nov-03 23:12:12					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DAnimation_h
#define _E3DAnimation_h


/*
#ifndef _E3DPolygon_h
#include <E3D/Polygon.h>
#endif
*/
#ifndef _EResource_h
#include <EResource.h>
#endif

#ifndef _E3DTypes_h
#include <E3D/Types.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Animation types
//
typedef struct E3dAnimation_S	E3dAnimation;

typedef void	(*E3dAnimationSetFrameProc)(E3dAnimation*, double);
typedef void	(*E3dAnimationFreeProc)(E3dAnimation*);



typedef struct
{
 char*				Name;
 unsigned int			StructSize;
 E3dAnimationSetFrameProc	SetFrameProc;		/* This function is called when the current frame changes				*/\
 E3dAnimationFreeProc		FreeProc;		/* This function is called when the Animation is getting destroyed			*/\
 EResource*			Resources;		/* Resource list									*/\
} E3dAnimationClass;


#define E3dAnimationCore()\
 E3dAnimationClass*		Class;\
 unsigned int			RefCnt;			/* Reference count for freeing (how many structures (Models, Geometries etc.) reference this Animation)	*/\
 double				LastFrame;		/* The last frame when this structure was updated					*/\
 int				Active


// Generic structure for Animation
//
struct E3dAnimation_S
{
 E3dAnimationCore();
};



// Key frame
//
typedef struct
{
 int	Type;
 double	Time;
} E3dKeyFrame;


// FCurve (key-frame) animation
//
typedef struct
{
 E3dAnimationCore();

 unsigned int	NumOfKeyFrames;
 E3dKeyFrame**	KeyFrames;
} E3dFCurveAnimation;



// From Animation.c
//
extern E3dAnimation*		E3d_AnimationAllocate(E3dAnimationClass* LClass);
extern void			E3d_AnimationFree(E3dAnimation* LAnimation);
extern E3dAnimationClass*	E3d_AnimationClassRegister(E3dAnimationClass* LClassTemplate);
extern E3dAnimationClass*	E3d_AnimationClassFindByName(char* LName);
extern void			E3d_AnimationClassDeactivate(E3dAnimationClass* LClass);
extern void			E3d_AnimationClassRemove(E3dAnimationClass* LClass);
extern E3dAnimation*		E3d_AnimationByClass(E3dAnimation** LAnimations, unsigned int LNumOfAnimations, E3dAnimationClass* LClass);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DAnimation_h
