/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Faces header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1998-Jun-06 23:18:19					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DFace_h
#define _E3DFace_h


#ifndef _E3DPolygon_h
#include <E3D/Polygon.h>
#endif	// _E3DPolygon_h

#ifndef _E3DSpline_h
#include <E3D/Spline.h>
#endif	// _E3DSpline_h


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



typedef struct
{
// E3dGeometry part
//
 E3dGeometryCore();


// E3dFace part
//
 E3dSpline*		Exterior;	// Exterior contour
 unsigned int		NumOfHoles;
 E3dSpline**		Holes;		// Array of E3dSpline pointers defining holes

 E3dMaterial*		Material;
 E3dMaterial*		DrawingMaterial;

// For drawing the Face
//
 E3dVector		Normal;

#ifdef USEOpenGL
 E3dGLCoordinate	GLNormal[3];
#endif	// USEOpenGL

 unsigned int		NumOfVertices;
 E3dVertex*		Vertices;
 unsigned int		NumOfTriangles;
 E3dTriangle*		Triangles;
} E3dFace;


/*----------------------------------------------------------------------*/
/* Patch (Bezier, BSpline, NURBS etc.)					*/
/*----------------------------------------------------------------------*/
typedef struct
{
// E3dGeometry part
//
 E3dGeometryCore();


// E3dPatch part
//
 int			PatchType;
 unsigned int		Degree;
 E3dSpline**		Sides;		// Patch sides
 unsigned int		NumOfSides;
} E3dPatch;
/*----------------------------------------------------------------------*/



/*------------------------------------------------------*/
/* Function prototypes					*/
/*------------------------------------------------------*/
extern E3dFace*		E3d_FaceAllocate(char* LName);
extern void		E3d_FaceFree(E3dFace* LFace);

extern E3dFace*		E3d_FaceClone(E3dFace* LFace, E3dFace* LDFace, int LFlags);

extern void		E3d_FaceConvertToPolygon(E3dFace* LFace, E3dPolygon* LPolygon, int LVertexOffset, EBool LInverse);

extern int		E3d_FaceTesselate(E3dFace* LFace);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DFace_h
