/*==============================================================*/
/* E3D library							*/
/*								*/
/* File I/O header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Dec-24 23:17:15				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef	_E3DIO_h
#define	_E3DIO_h

#include <float.h>

#ifndef _E3DScene_h
#include <E3D/Scene.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


#define E3dFileFormatNONE		NULL
#define E3dFileFormatFROM_EXTENSION	NULL	// Get format from filename extension
#define E3dFileFormatAUTOMATIC		NULL	// Automatic format recognition (for reading)

// Filter types
//
#define	E3dFileTypeNONE			0
#define E3dFileTypeMODEL		1
#define E3dFileTypeHIERARCHY		(1<<1)
#define E3dFileTypeSCENE		(1<<2)
#define E3dFileTypeMODEL_ANIMATION	(1<<3)
#define E3dFileTypeVERTEX_ANIMATION	(1<<4)
#define E3dFileTypeMATERIAL		(1<<5)
#define E3dFileTypeLIGHT		(1<<6)


typedef EBool	(*E3dCheckProc)(char*, FILE*);
typedef int	(*E3dReadProc)(char*, FILE*, void**);
typedef int	(*E3dWriteProc)(char*, void*, unsigned char);

typedef int	(*E3dModelReadProc)(char*, FILE*, E3dModel**);
typedef int	(*E3dModelWriteProc)(char*, E3dModel*, unsigned char);

typedef int	(*E3dSceneReadProc)(char*, FILE*, E3dScene**);
typedef int	(*E3dSceneWriteProc)(char*, E3dScene*, unsigned char);


typedef struct E3dIOModule
{
 char*			Name;
 char**			FileNameExtensions;	// File name extensions
 unsigned int		DataTypes;		// E3dFileTypeMODEL, E3dFileTypeSCENE etc...
 E3dCheckProc		CheckProc;		// Function to check if a file is in this format
 E3dReadProc		ReadProc;		// Function to read a 3D file
 E3dWriteProc		WriteProc;		// Function to write to file
} E3dIOModule;



extern E3dIOModule**	E3d_3DModelFileFormats;
extern unsigned int	E3d_NumOf3DModelFileFormats;

extern E3dIOModule**	E3d_3DHierarchyFileFormats;
extern unsigned int	E3d_NumOf3DHierarchyFileFormats;

extern E3dIOModule**	E3d_3DSceneFileFormats;
extern unsigned int	E3d_NumOf3DSceneFileFormats;


extern int		E3d_InitFileIO(char* LPath, char* LFileName, void (*LLogFunction)(int, char*, char*, ...));

extern E3dIOModule*	E3d_GetIOFilterFromFileNameExtension(char* LExtension, E3dIOModule** LFormats, unsigned int LNumOfFormats);


extern char*		E3d_GetBaseFileName(char* LFileName, char* LNameRet, unsigned int LMaxLen);


extern void*		E3d_3DModelIOFilterAdd(char* LName, E3dCheckProc LCheckFunction, E3dModelReadProc LReadFunction, E3dModelWriteProc LWriteFunction, char** LFileNameExtensions);
extern void		E3d_3DModelIOFilterRemove(void* LFileFormat);
extern void		E3d_3DModelIOFilterDeactivate(void* LFileFormat);

extern void*		E3d_3DHierarchyIOFilterAdd(char* LName, E3dCheckProc LCheckFunction, E3dModelReadProc LReadFunction, E3dModelWriteProc LWriteFunction, char** LFileNameExtensions);

extern void		E3d_3DHierarchyIOFilterRemove(void* LFileFormat);
extern void		E3d_3DHierarchyIOFilterDeactivate(void* LFileFormat);

extern void*		E3d_3DSceneIOFilterAdd(char* LName, E3dCheckProc LCheckProc, E3dSceneReadProc LReadProc, E3dSceneWriteProc LWriteProc, char** LFileNameExtensions);
extern void		E3d_3DSceneIOFilterRemove(void* LFileFormat);
extern void		E3d_3DSceneIOFilterDeactivate(void* LFileFormat);


extern int		E3d_ModelReadFromFile(char* LFileName, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet, E3dModel** LModel);
extern int		E3d_ModelWriteToFile(char* LFileName, char* LNameReturn, int LNameMaxLen, E3dModel* LModel, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet);

extern int		E3d_HierarchyReadFromFile(char* LFileName, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet, E3dModel** LModel);
extern int		E3d_HierarchyWriteToFile(char* LFileName, char* LNameReturn, int LNameMaxLen, E3dModel* LModel, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet);

extern int		E3d_SceneReadFromFile(char* LFileName, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet, E3dScene** LScene);
extern int		E3d_SceneWriteToFile(char* LFileName, char* LNameReturn, int LNameMaxLen, E3dScene* LModel, E3dIOModule* LFileFormat, E3dIOModule** LFileFormatRet);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif	// _E3DIO_h
