/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Generic "Item" header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-11 23:02:45					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DItem_h
#define _E3DItem_h

#ifndef _E3DModel_h
#include <E3D/Model.h>
#endif


#ifndef _E3DPolygon_h
#include <E3D/Polygon.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Item types
//
#define E3dITEM_NONE		0x00000
#define E3dITEM_WORLD_POSITION	0x00001		// No object type in particular, just tell the callback function the 3D position picked in world-space (e.g. for drawing a Spline)
#define E3dITEM_MODEL		0x00002
#define E3dITEM_BRANCH		0x00004
#define E3dITEM_TREE		0x00008
#define E3dITEM_LIGHT		0x00010
#define E3dITEM_GEOMETRY	0x00020
#define E3dITEM_SPLINE		0x00040
#define E3dITEM_FACE_CONTOUR	0x00080		// A Spline that's either the Exterior or a Hole contour of a Face
#define E3dITEM_SPLINE_SEGMENT	0x00100
#define E3dITEM_SPLINE_KEY	0x00200
#define E3dITEM_BEZIER_PREVIOUS	0x00400
#define E3dITEM_BEZIER_NEXT	0x00800
#define E3dITEM_FACE		0x01000
#define E3dITEM_MESH		0x02000
#define E3dITEM_POLYGROUP	0x04000
#define E3dITEM_POLYGON		0x08000
#define E3dITEM_EDGE		0x10000
#define E3dITEM_VERTEX		0x20000
#define E3dITEM_MATERIAL	0x40000

#define E3dITEM_POINT	(E3dITEM_VERTEX|E3dITEM_SPLINE_KEY)		// Vertex, Spline key etc.

#define E3dITEM_ALL	0x3FFFF
#define E3dITEM_ANY	0x3FFFF


#define E3dItemCore()\
 int	Type


// Generic structure for picking, selecting caching for modification, undo/redo etc.
//
typedef struct
{
 E3dItemCore();
} E3dAnyItem;


// Material
//
typedef struct
{
 E3dItemCore();

 E3dMaterial*	Material;
} E3dMaterialItem;


#define E3dGeoItemCore()\
 E3dItemCore();\
\
 unsigned int	Z1;\
 E3dModel*	Model;\
 E3dGeometry*	Geometry


// Just a Model
//
typedef struct
{
 E3dGeoItemCore();
} E3dGeoItem;


// Mesh, PolyGroup, Polygon, Vertex etc.
//
typedef struct
{
 E3dGeoItemCore();

 E3dPolyGroup*	PolyGroup;		// A PolyGroup in a Mesh
 int		PolygonIndex;		// Index of a Polygon in a PolygGroup

 E3dVertex*	Vertex;
 int		PointIndex;
} E3dPolyItem;


// Mesh or PolyGroup Edge
//
typedef struct
{
 E3dGeoItemCore();

 E3dPolyGroup*	PolyGroup;		// A PolyGroup in a Mesh
 int		PolygonIndex;		// Index of a Polygon in a PolygGroup

 E3dEdge*	Edge;
 int		EdgeIndex;
} E3dEdgeItem;


// Spline, Spline segment, Spline CV, Face etc.
//
typedef struct
{
 E3dGeoItemCore();

// If Geometry (in E3dGeoItemCore) is a Spline, this field will be the same.
// If Geometry is a Face, this will point to a Spline Contour of that Face
//
 E3dSpline*	Spline;
 int		ContourIndex;

 void*		CV;			// A Spline Control Vertex
 int		PointIndex;
} E3dSplineItem;



// Generic structure for picking, selecting caching for modification, undo/redo etc.
// It's in a union to have a unified size to avoid memory fragmentation
//
typedef union
{
 int		Type;		// This is always the first field...

 E3dPolyItem	GeoItem;
 E3dPolyItem	PolyItem;
 E3dSplineItem	SplineItem;
} E3dItem;




#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DItem_h
