/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Light source header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-24 23:17:03					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DLight_h
#define _E3DLight_h


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#ifndef _E3DPolygon_h
#include <E3D/Polygon.h>
#endif


enum
{
 E3dLIGHT_POINT=1,
 E3dLIGHT_SPOT,
 E3dLIGHT_INFINITE,
 E3dLIGHT_SUN
};

#ifndef _E3dLight
#define _E3dLight
typedef struct E3dLight_S	E3dLight;
#endif

struct E3dLight_S
{
 unsigned int		RefCnt;			// Reference count

 char*			Name;			// Light name
 char*			Prefix;			// Light prefix
 char*			FileName;		// Light file name with path
 E3dModel*		Model;			// Pointer to the Node structure

 int			Type;			// Light source type
 E3d3DPosition		Position;		// Light source position
 E3d3DPosition		CamTransPosition;	// Light source position transformed with the camera transformation matrix
 E3dVector		Direction;		// Light source direction from world origin (infinite lights) transformed with the camera transformation matrix
 E3dVector		CamTransDirection;	// Light source direction from world origin (infinite lights) transformed with the camera transformation matrix
 EcRGBfColor		Color;			// Color of the light source
 E3d3DPosition		SchemPosition;		// Position on schematic view

 float			ConstAttenuation,
			LinAttenuation,
			QuadraticAttenuation,
 			ShadowBrightness;	// If a point is in shadow from this light, its diffuse color will be multiplied by this value
};


typedef struct
{
 E3dModelInfoCore();

// E3dLightInfo part
//
 E3dLight*	Light;
} E3dLightInfo;


#ifdef USEOpenGL
typedef struct
{
 float		Ambient[4];
 float		Diffuse[4];
 float		Specular[4];
 float		Position[4];
 float		SpotDirection[4];
 float		SpotExponent, SpotCutOff;
 float		ConstAttenuation, LinAttenuation, QuadraticAttenuation;
} E3dGLLight;
#endif // USEOpenGL
/*----------------------------------------------------------------------*/


/*--------------------------------------------------------------*/
/* Global variables						*/
/*--------------------------------------------------------------*/
extern E3dLightInfo	E3d_LightModelInfo;

/*--------------------------------------------------------------*/
/* Function prototypes						*/
/*--------------------------------------------------------------*/
extern void		E3d_LightDefault(E3dLight* LLight);
extern E3dLight*	E3d_LightAllocate(void);
extern void		E3d_LightFree(E3dLight* LLight);
extern void		E3d_LightRefresh(E3dLight* LLight, E3dMatrix LCameraTransMatrix);
extern E3dModelInfo*	E3d_LightCreateModelInfo(E3dLight* LLight);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DLight_h

