/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Splines header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1998-May-27 23:27:34					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DNURBS_h
#define _E3DNURBS_h


#ifndef _E3DModel_h
#include <E3D/Model.h>
#endif	// _E3DModel_h


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*----------------------------------------------------------------------*/
/* NURBS								*/
/*----------------------------------------------------------------------*/
#define         E3dNRB_UNIFORM		0
#define         E3dNRB_OPEN_UNIFORM	1
#define         E3dNRB_NON_UNIFORM	2
#define         E3dNRB_CHORD_LENGTH	3
#define         E3dNRB_CENTRIPETAL	4

// Open/close NURBS information
#define		E3dNRB_CLS_NRM		   0x00000001
#define		E3dNRB_CLS_PRS		   0x00000002
#define		E3dNRB_CLS_LIN		   0x00000004


typedef struct
{
 double		X, Y, Z, W;	// Honmogeneous coordinates
 unsigned int	Flags;		// Internal use
} E3dNurbsPoint;


typedef struct
{
 int     	Order;     	// Order in this direction (degree+1)
 unsigned int	NumOfPoints;  	// Number of points for NURBS
 unsigned int	NumOfKnots;   	// (closed) ? noPoints+1 :
				//	     (noPoints+order-2)
 double*	Knots;    	// Array of dimension NumOfKnots
 double		Start;     	// (closed) ? knots[0]:knots[order-2]
 double		End;       	// (closed) ? knots[noKnots-1]:
				//            knots[noKnots-order+1]
 EBool		Closed;		// TRUE if closed, FALSE otherwise
} E3dNurbsDir;


typedef struct
{
 int		GeoType;	// Geometry type
 unsigned int	RefCnt;		// Reference count for freeing (how many structures reference this mesh)
 char*		Name;
 void*		GeoInfo;	// Pointer to type specific info structure (e.g. torus radii, segments etc.)

 E3dNurbsDir	Dir;
 int		Uniformity;	// uniform,open-uniform, non-uniform 
 short		Rational;	// TRUE if curve is rational
 E3dNurbsPoint*	Points;        	// noPoints
 int		CloseInfo;	// Closing information
				// normal, preserved, linear
 int		Steps;		// Number of display steps
} E3dNurbsCrv;


typedef struct
{
 short		Boundary;      	// TRUE if CompCrv is a boundary
 int		NumOfCurves;	// Number of component curves
 E3dNurbsCrv**	Curves;      	// Array of dimension noCurves
 int		NumOfPoints;	// # of points
 E3dVector*	Points; 	// Array of noPoints
} E3dNurbsCompCrv;


typedef struct
{
 int			GeoType;	// Geometry type
 unsigned int		RefCnt;		// Reference count for freeing (how many structures reference this mesh)
 char*			Name;
 void*			GeoInfo;	// Pointer to type specific info structure (e.g. torus radii, segments etc.)

 E3dNurbsDir		UDir;
 E3dNurbsDir		VDir;

 unsigned int		NumOfPoints;

 int			Uniformity;
 short			Rational;
 E3dNurbsPoint*		Points;		// UDir.NumOfPoints X VDir.NumOfPoints
 int			Flag;

// Trimming
 short			AutoBorder;	// TRUE if boundary is entire domain
					// In this case, the trim curves must
					// only be holes.
     
 int            	NumOfTrims;	// Number of trim curves  
 E3dNurbsCompCrv**	Trims;		// Array of size noTrims
 int			USteps;		// U wireframe, SHADES & rend. step
 int			VSteps;		// V wireframe, SHADES & rend. step
 int	        	UCurve;		// U no. of drawing curve
 int	        	VCurve;		// V no. of drawing curve

 short			UBottom;	// Automatic capping
 short			VBottom; 
 short			UTop;
 short			VTop;    

 int			UCloseInfo;	// Closing information:
 int			VCloseInfo;	// Normal, preserved, linear
} E3dNurbsSrf;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DNURBS_h
