/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Select-related functions header file					*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Sep-12 23:19:18					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DSelect_h
#define _E3DSelect_h


#ifndef _E3DFace_h
#include <E3D/Face.h>
#endif	// _E3DFace_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


// Selection targets
//
enum
{
 E3dSELTG_NONE=0,
 E3dSELTG_MODEL,
 E3dSELTG_GEOMETRY
};


/*--------------------------------------*/
/* From Select.c			*/
/*--------------------------------------*/
extern void		E3d_SelectModelGeometries(E3dModel* LModel);
extern void		E3d_UnselectModelGeometries(E3dModel* LModel, E3dGeometry* LSkipThisGeometry, int LFlags);

extern void		E3d_SelectMeshPolyGroup(E3dMesh* LMesh, E3dPolyGroup* LPolyGroup, EBool LUnselectTheRest);

extern E3dModel*	E3d_ModelTreeToggleSelection(E3dModel* LModel, EBool LUnselectTheRest);
extern EBool		E3d_SplineSegmentToggleSelection(E3dSpline* LSpline, unsigned int LSegment, EBool LUnselectTheRest);

extern EBool		E3d_FaceContourToggleSelection(E3dFace* LFace, int LContourIndex, E3dSpline* LSpline, EBool LUnselectTheRest);


/*--------------------------------------*/
/* From Panel/Select.c			*/
/*--------------------------------------*/
extern int		E3d_SelectionTarget;

extern E3dPolygon*	E3d_SelectTogglePolygonSelection(E3dModel* LModel, E3dGeometry* LGeometry, E3dPolyGroup* LPolyGroup, E3dPolygon* LPolygon, EBool LUnselectTheRest);


extern E3dModel*	E3d_ModelNodeToggleSelection(E3dModel* LModel, EBool LUnselectTheRest);
extern E3dModel*	E3d_ModelBranchToggleSelection(E3dModel* LModel, EBool LUnselectTheRest);

extern E3dModel*	E3d_SelectModelBranch(E3dModel* LBranchRootModel, EBool LUnselectTheRest);
extern E3dModel*	E3d_SelectModelTree(E3dModel* LModel, EBool LUnselectTheRest);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DSelect_h
