/*======================================================================*/
/* Tag operations header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-09 23:33:09					*/
/*									*/
/* 3DPanel(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DTagOps_h
#define _E3DTagOps_h



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


#define _M_UndoTagTransform()\
   {\
    E3dGeometry*		LGeometry;\
    E3dGeometryCallbackStruct	LCBS;\
\
    for(LGmC=0;LGmC<LShapeN;LGmC++, LShapeSnapshot++)\
    {\
     LGeometry=LShapeSnapshot->Geometry;\
     switch(LGeometry->GeoType)\
     {\
      caseE3dMESH():\
       {\
	E3dSnapshotVertex*	LSnapshotVertex=((E3dMeshVerticesSnapshot*)LShapeSnapshot)->SnapshotVertices;\
	E3dVertex*		LVertices=((E3dMesh*)LGeometry)->Vertices;\
	E3dVertex*		LVertex;\
	unsigned int		LVC=((E3dMeshVerticesSnapshot*)LShapeSnapshot)->NumOfPoints;\
\
	do\
	{\
	 LVertex=LVertices+LSnapshotVertex->Index;\
	 LVertex->X=LSnapshotVertex->X;\
	 LVertex->Y=LSnapshotVertex->Y;\
	 LVertex->Z=LSnapshotVertex->Z;\
	 LSnapshotVertex++;\
	} while(--LVC);\
\
	E3d_GeometryUpdateForDisplay(LGeometry, E3dGF_SHAPE|E3dGF_NORMALS|E3dGF_REMAP_TEXTURES);\
       }\
      break;\
\
      case E3dGEO_SPLINE:\
       {\
	E3dSpline*	LSpline=(E3dSpline*)LGeometry;\
\
	_UnTransformSplineTags(LSpline, (E3dSplineCVsSnapshot*)LShapeSnapshot, E3dDO_X|E3dDO_Y|E3dDO_Z);\
\
	E3d_SplineCreateLinearSegments(LSpline);\
	E3d_SplineUpdateSegmentLengths(LSpline, LSpline->NumOfStepsForLength);\
\
/* Collect Output interfaces into a non-repeating array, so for example the "Skin" tool's	*/\
/* InputChanged method will only get called once, even if many of its Splines change		*/\
\
	for(LOC=0;LOC<(LSpline->NumOfOutputs);LOC++) ELst_AddPointerAChk((void***)(&LOutputs), &LNumOfOutputs, &LNumOfOutputsAllocated, 4, LSpline->Outputs[LOC]);\
       }\
      break;\
\
      case E3dGEO_FACE:\
       {\
	E3dFace*		LFace=(E3dFace*)LGeometry;\
	E3dSplineCVsSnapshot*	LCVsSnapshot=((E3dFaceCVsSnapshot*)LShapeSnapshot)->SplineCVsSnapshots;\
	unsigned int		LSC, LNumOfSplines=((E3dFaceCVsSnapshot*)LShapeSnapshot)->NumOfSplineCVsSnapshots;\
\
	for(LSC=0;LSC<LNumOfSplines;LSC++, LCVsSnapshot++)\
	{\
	 _UnTransformSplineTags(LCVsSnapshot->Spline, LCVsSnapshot, E3dDO_X|E3dDO_Y|E3dDO_Z);\
	 E3d_SplineCreateLinearSegments(LCVsSnapshot->Spline);\
	 E3d_SplineUpdateSegmentLengths(LCVsSnapshot->Spline, LCVsSnapshot->Spline->NumOfStepsForLength);\
	}\
\
/* Free these and E3d_DrawFace() or E3d_GetRenderTriangles() etc. will call E3d_FaceTesselate() when necessary	*/\
\
/* This will speed things up when there are no Windows with Solid display modes	*/\
\
	if(LFace->Vertices) { EFree(LFace->Vertices);LFace->Vertices=NULL;LFace->NumOfVertices=0; }\
	if(LFace->Triangles) { EFree(LFace->Triangles);LFace->Triangles=NULL;LFace->NumOfTriangles=0; }\
\
/* Collect Output interfaces into a non-repeating array, so for example the "Skin" tool's	*/\
/* InputChanged method will only get called once, even if many of its Splines change		*/\
\
	for(LOC=0;LOC<(LFace->NumOfOutputs);LOC++) ELst_AddPointerAChk((void***)(&LOutputs), &LNumOfOutputs, &LNumOfOutputsAllocated, 4, LFace->Outputs[LOC]);\
       }\
      break;\
     }\
    }\
\
    if(LOutputs)\
    {\
     LCBS.Reasons=E3dGF_SHAPE|E3dGF_NORMALS|E3dGF_REMAP_TEXTURES;\
     E3d_CallOutputs(NULL, LOutputs, LNumOfOutputs, &LCBS);\
     EFree(LOutputs);\
    }\
    E3dp_Redraw3DWindows(E3dDF_ALL, E3dVM_NORMAL3D);\
    return(E3dCHG_SHAPE);\
   }





/*----------------------------------------------*/
/* From TransformPanel.c			*/
/*----------------------------------------------*/
extern void	_UnTransformSplineTags(E3dSpline* LSpline, E3dSplineCVsSnapshot* LSplineCVsSnapshot, unsigned int LAxes);





#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DTagOps_h
