/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Undo/redo								*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Aug-06 23:49:54					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DUndo_h
#define _E3DUndo_h

#ifndef _EUndo_h
#include <EUndo.h>
#endif

#ifndef _E3DScene_h
#include <E3D/Scene.h>
#endif

#ifndef _E3DShape_h
#include <E3D/Shape.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Operator codes
//
enum
{
 E3dOP_TRANSFORM=1,
 E3dOP_NODE,
 E3dOP_BRANCH,
 E3dOP_TREE
};


// Status Content codes
//
enum
{
 E3dACTION_3DTRANSFORM=1,
 E3dACTION_3DTRANSLATION,
 E3dACTION_PARENT_CONNECTION
};



typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorNodeTranslation part
//
 E3d3DPosition	Translation;
 E3dModel*	Model;
} E3dOperatorTranslatePoint;



typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorNodeTranslation part
//
 E3d3DPosition	Translation;
 E3dModel*	Model;
} E3dOperatorNodeTranslation;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorPointsChange part
//
 unsigned int			NumOfShapeSnapshots;
 E3dShapeSnapshot*		ShapeSnapshots;
} E3dOperatorPointsChange;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorScaleModels part
//
 E3dCoordinate			X, Y, Z;
 unsigned int			TransformAxes;
 unsigned int			NumOfModels;
 E3dModel**			Models;
 E3d3DPosition*			TransformBases;
} E3dOperatorScaleModels;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorRotateModels part
//
 E3dCoordinate			X, Y, Z;
 unsigned int			TransformAxes;
 unsigned int			NumOfModels;
 E3dModel**			Models;
 E3dRotation*			TransformBases;
} E3dOperatorRotateModels;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorTranslateModels part
//
 E3dCoordinate			X, Y, Z;
 E3dCoordinate			GridSnapToValX, GridSnapToValY, GridSnapToValZ;
 unsigned int			TransformAxes;
 unsigned int			NumOfModels;
 E3dModel**			Models;
 E3d3DPosition*			TransformBases;
 EBool				GridSnapToX, GridSnapToY, GridSnapToZ;
} E3dOperatorTranslateModels;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorScaleTags part
//
 E3dCoordinate			X, Y, Z;
 unsigned int			TransformAxes;
 unsigned int			NumOfShapeSnapshots;
 E3dShapeSnapshot*		ShapeSnapshots;
} E3dOperatorScaleTags, E3dOperatorTranslateTags;


typedef struct
{
// EOperator part
//
 EOperatorCore();

// E3dOperatorRotateTags part
//
 E3dMatrix			Matrix;
 unsigned int			NumOfShapeSnapshots;
 E3dShapeSnapshot*		ShapeSnapshots;
} E3dOperatorRotateTags;



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DUndo_h
