/*======================================================================*/
/* ECrypt								*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1995-May-03 23:59:32					*/
/*									*/
/* ECrypt(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _ECrypt_h
#define _ECrypt_h

#include <EGUI/EGUI.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#define	ECrNONE			-1

#define ECrAlgorithm0		37
#define ECrVersion		 1
#define	ECrMAX_MAGICLENGTH	 9			// A magic number maximalis hossza
#define	ECrMagicLength		 4			// A magic number hossza
#define	ECrVersionLength	 2			// A verzioszam hossza
#define	ECrModeLength		 4			// A file mode hossza
#define	ECrTimeLength		 4			// A file mode hossza

enum { ECrCHECKWF_NONE=0,ECrCHECKWF_FILE1,ECrCHECKWF_FILE2,ECrCHECKWF_FILE3,ECrCHECKWF_FILE4,ECrCHECKWF_FILE5 };

/*------------------------------------------------------------------------------*/
/* Length of info-block's informative part: info-block length, algorythm	*/
/* alternators, magic numbers, version, file mode, ATime, MTime, CTime		*/
/*------------------------------------------------------------------------------*/
#define	ECrMinInfoLength	(2+ECrMAX_PASSWORDLENGTH+ECrMagicLength+ECrVersionLength+ECrModeLength+ECrTimeLength+ECrTimeLength+ECrTimeLength)

enum
{
 ECrDECRYPT_SUCCESS=0,
 ECrNOT_RECOGNIZED,
 ECrNO_MEMORY,
 ECrFILE_ERROR
};

#define	ECrInfoOffset		87			// Az info blokk a file elejetol itt kezdodik

#define	ECrMAX_PASSWORDLENGTH	16

enum { ECrPASSWORD_REMOVED=0,ECrPASSWORD_ON,ECrPASSWORD_OFF,ECrTIMER_RESET };

#ifdef _ECrypt0_c
#else
extern int		ECr_CCnt;
extern char		ECr_Jelszo[ECrMAX_PASSWORDLENGTH];

extern int		ECr_CheckPWWithFile;
extern char		ECr_CheckFile1[256];
extern char		ECr_CheckFile2[256];
extern char		ECr_CheckFile3[256];
extern char		ECr_CheckFile4[256];
extern char		ECr_CheckFile5[256];

extern EBool		ECr_RestoreTimeAfterEnc,ECr_RestoreTimeAfterDec;

extern void		ECr_PopupPasswordDialog(Widget LParentW,char* LTitle,void (*LCallbackFunct)(),void (*LEventDispFunc)(EguiEvent*));

extern unsigned long	ECr_PasswordTimeOut;
extern XtIntervalId	ECr_PasswordIntervalId;
extern void		(*ECr_CallbackFunct)();

extern EBool		ECr_IsEncrypted(register char* LPassword,FILE* LInFile,register long LFileLength,register int* LInfoOffsetR,register int* LInfoLengthR,register int* LAlgorithmR,register char* LAlternatorsR,register char* LInfoBlockR);
extern EBool		ECr_SaveEncrypted(char* LPassword,char* LFileBuffer,unsigned long LFileLength,FILE* LOutFile,int LSalt);
extern int		ECr_DecryptToMemory(char* LPassword,FILE* LInFile,char** LBuffer,unsigned long* LLength,char* LInfoBlockPtr);

#endif // _ECrypt0_c

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _ECrypt_h
