/*==============================================================*/
/* EGUI library header file					*/
/*								*/
/* - Dialog-box related stuff					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Oct-05 23:03:28				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy				*/
/*==============================================================*/

#ifndef _EGUIDialog_h
#define _EGUIDialog_h


#include <EGUI/PushButton.h>
#include <EGUI/Shell.h>
#include <ENet.h>


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


#define MAX_FILESELDIALOGNUM	16
#define MAX_MESSAGENUM		16	// Max number of separate message dialogs

#define EguiFSGEO_LISTS	1
#define EguiFSGEO_ALL	0xFF

#define	EguiNEW			-2


#define	MAX_NUM_OF_DIALOGBUTTONS	 8
#define	MAX_ADDEDFORMSPERDIALOG	 	 4
#define	MAX_ADDEDLABELSPERDIALOG	 4
#define	MAX_ADDEDTEXTSPERDIALOG	 	 4


typedef struct
{
 int			Type;
#ifdef EGUIXe
 Widget			MessageBoxW, WorkAreaW;
 Widget			IconLabelW, MessageLabelW;
#endif // EGUIXe
 int			NumOfButtons;
 EguiItem*		Buttons;
 EguiCallbackList	OkCallback, CancelCallback;
} EguiDialogPart;

typedef struct
{
 EguiCorePart		Core;
 EguiShellPart		Shell;
 EguiDialogPart		Dialog;
} EguiDialogRec;


typedef int		EdFSDialogGrpID;

#define	EdMAX_NUM_OF_HOSTS		   256

/*--------------------------------------*/
/* For Folder panels			*/
/*--------------------------------------*/
typedef struct
{
 char	Name[64];
 Widget	ButtonW, FolderW;
 EBool	Open;
} EGUIFolder;


typedef struct
{
 EnHost*	Host;
} EdNetDialogCallbackStruct;

enum
{
 EguiDIALOG_ERROR,
 EguiDIALOG_INFORMATION,
 EguiDIALOG_MESSAGE,
 EguiDIALOG_QUESTION,
 EguiDIALOG_TEMPLATE,
 EguiDIALOG_NETWORK_CONNECTION,
 EguiDIALOG_WORKING,
 EguiDIALOG_WARNING,
 EguiDIALOG_PROMPT,
 EguiDIALOG_SELECTION,
 EguiDIALOG_FILESELECTION
};


// Dialog box child identifiers
//
enum
{
 EguiDIALOG_MAIN=0,
 EguiDIALOG_WORK_AREA,
 EguiDIALOG_DIR_TEXT,
 EguiDIALOG_FILE_TEXT,
 EguiDIALOG_DIR_LIST,
 EguiDIALOG_FILE_LIST,
 EguiDIALOG_FILTER_LIST,
 EguiDIALOG_CUSTOM_ITEM,
 EguiDIALOG_MESSAGE_LABEL
};


enum
{
 EguiALIGNMENT_BEGINNING,
 EguiALIGNMENT_CENTER,
 EguiALIGNMENT_END
};


enum
{
 EguiPLACE_NONE=0,
 EguiPLACE_TOP,
 EguiPLACE_ABOVE_FILENAME,
 EguiPLACE_BOTTOM
};


// Some standard dialog callback reasons
//
enum
{
 EguiOK=0,
 EguiAPPLY,
 EguiRESET,
 EguiCANCEL,
 EguiHELP,
 EguiREFRESHDIR,
 EguiLISTTOGGLE,
 EguiDIRLISTTOGGLE,
 EguiHOSTLISTTOGGLE,
 EguiADD,EguiADDRESS,EguiDEL,EguiSELECT,
 EguiCLEAR,
 EguiBUTTON0,EguiBUTTON1,EguiBUTTON2,EguiBUTTON3,EguiBUTTON4,EguiBUTTON5,EguiBUTTON6,EguiBUTTON7,
 EguiLIST_SELECT,
 EguiCUSTOM0		// Basis of Custom client data
};


enum
{
 EguiCR_OK=0,
 EguiCR_APPLY,
 EguiCR_RESET,
 EguiCR_CANCEL,
 EguiCR_HELP,
 EguiCR_REFRESHDIR,
 EguiCR_LISTTOGGLE,
 EguiCR_DIRLISTTOGGLE,
 EguiCR_HOSTLISTTOGGLE,
 EguiCR_ADD,EguiCR_ADDRESS,EguiCR_DEL,EguiCR_SELECT,
 EguiCR_CLEAR,
 EguiCR_BUTTON0,EguiCR_BUTTON1,EguiCR_BUTTON2,EguiCR_BUTTON3,EguiCR_BUTTON4,EguiCR_BUTTON5,EguiCR_BUTTON6,EguiCR_BUTTON7,
 EguiCR_LIST_SELECT,
 EguiCR_CUSTOM0		// Basis of Custom client data
};


enum
{
 EguiSHADOW_ETCHED_IN=0,
 EguiSHADOW_OUT,
 EguiSHADOW_IN,
 EguiSINGLE_LINE_TOP,
 EguiSINGLE_LINE,
 EguiDOUBLE_LINE,
 EguiSINGLE_DASHED_LINE,
 EguiDOUBLE_DASHED_LINE,
 EguiNO_LINE
};


/*------------------------------*/
/* Font allocation		*/
/*------------------------------*/
enum
{
 EguiLABEL_FONT=0,
 EguiMENU_FONT,
 EguiLIST_FONT,
 EguiTEXT_FONT,
 EguiNUM_FONT
};


 
#define EdFSDialogGrpNONE		-2
#define EdFSDialogGrpNEW		-1

// From include/EGUI/PluginManager.c
//
extern Pixmap	EGUI_DArrowPixmap,EGUI_DArrowHPixmap,
  		EGUI_LArrowPixmap, EGUI_LArrowHPixmap,
  		EGUI_RArrowPixmap, EGUI_RArrowHPixmap;


extern int	EGUI_ScaleWidth, EGUI_SliderLength, EGUI_SliderWidth;

extern void	EGUI_FreeStringArray(char** LArray, unsigned int LNumOfEntries);

extern void	EGUI_VaSetDialogValues(EguiItem LDialog, ...);


extern void	EGUI_InitDialogs(EguiItem LParent, Pixel LBackgroundCol, Pixel LButtonCol, Pixel LActiveCol, Pixel LTroughCol, Pixel LForegroundCol, Pixel LTopShadowCol, Pixel LBottomShadowCol, Pixel LWBackgroundCol, Pixel LWTroughCol, Pixel LWForegroundCol, Pixel LWTopShadowCol, Pixel LWBottomShadowCol, Pixel LTextFieldBackgroundCol, Pixel LTextFieldForegroundCol, Pixel LTextFieldFocusCol, Pixel LSelectCol);
extern int	EGUI_FontListInitialize(int LWhichFontList, char* LFontName);
extern int	EGUI_FontListAddEntry(int LWhichFontList, char* LEntryName, char* LFontName);

extern Widget	EGUI_DialogGetChild(EguiItem LDialog, int LChild);

extern void	EGUI_CenterWidgetToWidget(Widget, Widget);
extern void	EGUI_VaChangeDialogColors(int, ...);
extern void	EGUI_RestoreDialogColors(void);
extern void	EGUI_SetPushButtonArgs(Dimension LMarginLeft, Dimension LMarginRight, Dimension LMarginTop, Dimension LMarginBottom, ArgList LArgs, Cardinal* LArgCnt);
extern void	EGUI_SetToggleButtonArgs(Dimension LMarginLeft, Dimension LMarginRight, Dimension LMarginTop, Dimension LMarginBottom, ArgList LArgs, Cardinal* LArgCnt);
extern void	EGUI_SetFolderButtonArgs(Dimension LMarginLeft, Dimension LMarginRight, Dimension LMarginTop, Dimension LMarginBottom, ArgList LArgs, Cardinal* LArgCnt);

extern void	EGUI_VaSetListValues(Widget, ...);
extern void	EGUI_VaGetListValues(Widget, ...);
extern void	EGUI_ListDeleteSelectedItems(Widget);
extern Widget	EGUI_DialogGetChild(EguiItem LDialog, int LChild);

extern EguiItem	EGUI_CreateDialog(int LType, char* LName, EguiItem LParent, EguiArgList LArgList, int LArgCount);
extern EguiItem	EGUI_VaCreateDialog(int LType, char* LName, EguiItem LParent, ...);
extern void	EGUI_DestroyDialog(EguiItem LDialog);

extern void	EGUI_VaGetDialogValues(EguiItem LDialog, ...);

extern void	EGUI_SetHostListFromString(char*);
extern void	EGUI_RefreshHostList(EguiItem LDialog);
extern void	EGUI_CenterWVert(Widget LW0, int LH0, Widget LW1, int LH1, int LOffset, EBool LDoAll);


extern void	_EGUICB_FolderOpenClose(EguiItem LI, EPointer LClientData, EPointer LCallData);

extern Widget	EGUI_CreateDrawer(Widget LParentW, EGUIFolder* LFolder, char* LName, int LShadowThickness, EBool LCreateTopMatrix, EBool LOpen);

extern Widget	EGUI_CreateFolder(char* LTitle, Widget LParentW, ArgList Args, Cardinal ArgCnt);
extern void	EGUI_FolderSetWorkArea(Widget LFolderW, Widget LWAW);
extern void	EGUI_FreeFolder(Widget LFolderW);

extern Widget	EGUI_ConnectListW, EGUI_ConnectNameTW, EGUI_ConnectAddressTW;
extern EnHost	EGUI_Hosts[EdMAX_NUM_OF_HOSTS];

extern int	EGUI_NumOfHosts;
extern EBool	EGUI_ShowAddress;

extern void	EGUI_ExposeWidget(Widget LWidget);
extern void	EGUI_VaPutQuestion(char* LQuestion, ...);
extern void	EGUI_VaPutSingleMessage(char* LMessage, ...);
extern Widget	EGUI_VaPutSingleWorkingMessage(char* LMessage, ...);
extern void	EGUI_RemoveSingleMessageWithTimer(unsigned long LMSecs, void (*LFunction)());
extern void	EGUI_RemoveSingleMessage();
extern void	EGUI_RemoveQuestion();
extern EguiItem	EGUI_VaPutWorkingMessage(Widget LParentW, int LWMessageID, char* LMessage, ...);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif	// _EGUIDialog_h
