/*==============================================================*/
/* EGUI library 						*/
/*								*/
/* Dialog private header file					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jun-11 22:10:23				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EGUIDialogP_h
#define _EGUIDialogP_h

#include <stdarg.h>		// For varargs

#include <EGUI/Dialog.h>
#include <EGUI/ShellP.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern EguiItem		_EGUI_ParentItem, _EGUI_CenterToItem;
extern Widget		_EGUI_ParentW, _EGUI_CenterToWidget;

extern char*		_EGUI_DefFilterList;
extern char		_EGUI_Path[MAXPATHLEN+1];			// For EGUI_VaOpenFileSelDialog
extern char		_EGUI_File[MAXPATHLEN+1];
extern int		_EGUI_FilterListVisibleItemCount,
			_EGUI_FileListVisibleItemCount,
			_EGUI_HostListVisibleItemCount,
			_EGUI_CustomItemType,			// Type of the custom Item (Form, Matrix widget etc.) in the FileSelBox
			_EGUI_CustomItemPlacement;		// Where to insert a custom Item (Form or Matrix widget) in the FileSelBox

extern EdFSDialogGrpID*	_EGUI_FSBoxGrpRet;

extern EBool		_EGUI_CreateForm, _EGUI_ShowLists;

extern void	EGUI_GetDialogVarArgs(va_list LDArgs,int LType);
extern void	EGUI_DestroyDialog(EguiItem LItem);
extern void	EGUI_DialogAddChild(EguiItem LItem, char* LName, Arg* Args, Cardinal ArgCnt);

extern EguiItem	_EGUI_CreateThatDialog(int LType, char* LName, EguiClassRec* LClass, EguiItem LParent);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EGUIDialogP_h
