/*==============================================================*/
/* EGUI library 						*/
/*								*/
/* FileSelectionBox private header file				*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-05 22:17:08				*/
/*								*/
/* Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================*/

#ifndef _FSBoxP_h
#define _EGUIColorDialogP_h

#include <EGUI/FSBox.h>
#include <EGUI/DialogP.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef struct
{
 Widget			ManagerW;
 Widget			FilterMatrixW, FilterTextW, FilterListBW,
			ListsMatrixW, FileLabelW, FileTextW;
 Widget			FilterListFormW, FilterListW;
 Widget			DirListW, FileListW, DirListLabelW, FileListLabelW, CustomItemW;
 Widget			FocusWidget;
 int			VScrollbarXSize;
 int			FileListXSize, ListXMargin, CustomItemPlacement, CustomItemType;
 int			XSizeDiff, YSizeDiff;
 unsigned int		XSizeWithLists, YSizeWithLists;
 unsigned int		DispFlags;
 char			DirFilter[MAXPATHLEN+1];
 char			Path[MAXPATHLEN+1];
 char			File[MAXPATHLEN+1];
 EdirDirEnt*		DirEntries;
 unsigned int		NumOfEntries, MaxNumOfEntries, NumOfDirs;
 char*			TmpFilterList;
 EBool			Mapped, DirListOn, FileListOn, ShowLists;
 EBool			ShowFullPaths, FilterListOn, PrgChangedSize, PrgChangedDirFilter, PrgChangedFile;
} EguiFileSelBoxPart;

typedef struct
{
 EguiCorePart		Core;
 EguiShellPart		Shell;
 EguiDialogPart		Dialog;
 EguiFileSelBoxPart	FSBox;
} EguiFileSelBoxRec;



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _FSBoxP_h
