/*======================================================================*/
/* EGUI: a platform-independent GUI API					*/
/*									*/
/* EGUIPushButton: public header file					*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1995-Nov-18 01:18:33					*/
/*									*/
/* EGUI(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EGUIPushButton_h
#define _EGUIPushButton_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#include <EGUI/EGUI.h>
#include <Image/Image.h>

typedef struct
{
 int		Reason;
 unsigned int	State;		// Modifier keys
} EguiPushButtonCallbackStruct;


#ifdef EGUIXe
extern void	_EGUIXtCB_PushButton(Widget LW, XtPointer LClientData, XtPointer LCallData);
#endif // EGUIXe

#ifdef WIN32
#endif // WIN32

extern EguiItem	EGUI_CreatePushButton(char* LName, EguiItem LParent, EguiArgList LArgs, int LArgCnt);
extern EguiItem	EGUI_AddPushButton(char* LLocation, char* LName, char LMnemonic, char* LAccel, char* LAccelText, EBool LCreateOptionsButton, char* LToolTip, EguiCallbackProc LCallback, EPointer LClientData);
extern EguiItem	EGUI_AddPushButtonImg(char* LLocation, char* LName, char LMnemonic, char* LAccel, char* LAccelText, EBool LCreateOptionsButton, char* LToolTip, EguiCallbackProc LCallback, EPointer LClientData, EpImage* LLabelImage, EpImage* LActiveImage, EpImage* LArmImage);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EGUIPushButton_h
