/*==============================================================*/
/* EGUI library 						*/
/*								*/
/* Shell public header file					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jun-24 23:09:22				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/

#ifndef _Shell_h
#define _Shell_h

#include <EGUI/EGUIP.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Window manager hints flags
//

#ifdef _EGUI_Xt_Xe
// Bit definitions for wmHints.flags
//
#define EguiWM_HINTS_FUNCTIONS		MWM_HINTS_FUNCTIONS
#define EguiWM_HINTS_DECORATIONS	MWM_HINTS_DECORATIONS
#define EguiWM_HINTS_INPUT_MODE		MWM_HINTS_INPUT_MODE
#define EguiWM_HINTS_STATUS		MWM_HINTS_STATUS

// Bit definitions for wmHints.functions
//
#define EguiWM_FUNC_ALL			MWM_FUNC_ALL
#define EguiWM_FUNC_RESIZE		MWM_FUNC_RESIZE
#define EguiWM_FUNC_MOVE		MWM_FUNC_MOVE
#define EguiWM_FUNC_MINIMIZE		MWM_FUNC_MINIMIZE
#define EguiWM_FUNC_MAXIMIZE		MWM_FUNC_MAXIMIZE
#define EguiWM_FUNC_CLOSE		MWM_FUNC_CLOSE
#define EguiWM_FUNC_QUIT_APP		MWM_FUNC_QUIT_APP	// for 4Dwm

// Bit definitions for wmHints.decorations
//
#define EguiWM_DECOR_ALL		MWM_DECOR_ALL
#define EguiWM_DECOR_BORDER		MWM_DECOR_BORDER
#define EguiWM_DECOR_RESIZEH		MWM_DECOR_RESIZEH
#define EguiWM_DECOR_TITLE		MWM_DECOR_TITLE
#define EguiWM_DECOR_MENU		MWM_DECOR_MENU
#define EguiWM_DECOR_MINIMIZE		MWM_DECOR_MINIMIZE
#define EguiWM_DECOR_MAXIMIZE		MWM_DECOR_MAXIMIZE
#else

// Bit definitions for wmHints.flags
//
#define EguiWM_HINTS_FUNCTIONS		(1L << 0)
#define EguiWM_HINTS_DECORATIONS	(1L << 1)
#define EguiWM_HINTS_INPUT_MODE		(1L << 2)
#define EguiWM_HINTS_STATUS		(1L << 3)

// Bit definitions for wmHints.functions
//
#define EguiWM_FUNC_ALL			(1L << 0)
#define EguiWM_FUNC_RESIZE		(1L << 1)
#define EguiWM_FUNC_MOVE		(1L << 2)
#define EguiWM_FUNC_MINIMIZE		(1L << 3)
#define EguiWM_FUNC_MAXIMIZE		(1L << 4)
#define EguiWM_FUNC_CLOSE		(1L << 5)
#define EguiWM_FUNC_QUIT_APP		(1L << 23)	// For 4Dwm

// Bit definitions for wmHints.decorations
//
#define EguiWM_DECOR_ALL		(1L << 0)
#define EguiWM_DECOR_BORDER		(1L << 1)
#define EguiWM_DECOR_RESIZEH		(1L << 2)
#define EguiWM_DECOR_TITLE		(1L << 3)
#define EguiWM_DECOR_MENU		(1L << 4)
#define EguiWM_DECOR_MINIMIZE		(1L << 5)
#define EguiWM_DECOR_MAXIMIZE		(1L << 6)

#endif // _EGUI_Xt_Xe

enum
{
 EguiNOT_DISPLAYED=0,
 EguiICONIZED,
 EguiDISPLAYED
};


enum
{
 EguiSTACKING_ANY=0,
 EguiSTACKING_PRIORITY1,
 EguiSTACKING_PRIORITY2,
 EguiSTACKING_PRIORITY3
};

#define EGUISHELL_ALLOCSTEP		4

typedef struct
{
 Widget		W;
 Dimension	XSize;
} EWidthAlignRec;


typedef struct
{
 Pixmap			IconPixmap;
 Window			IconWindow;
 Widget			ShellW;
} EguiShellPart;

typedef struct
{
 EguiCorePart		Core;
 EguiShellPart		Shell;
} EguiShellRec;



extern EguiItem	EGUI_CreateShell(char* LName, EguiItem LParent, EguiArgList LArgList, int LArgCount);
extern void	EGUI_FreeShells(void);

extern EBool	EGUI_ShellGetGeometry(EguiItem LShell, int* LXRet, int* LYRet,unsigned int* LXSizeRet, unsigned int* LYSizeRet);
extern int	EGUI_ShellDisplayStatus(EguiItem LShell);
extern void	EGUI_RaiseShell(EguiItem LShell);
extern void	EGUI_IconifyShell(EguiItem LShell);
extern void	EGUI_ShellSetStackingPriority(EguiItem LShell, int LPri);
extern void	EGUI_DisplayShell(EguiItem LShell);
extern void	EGUI_DisplayShellIconified(EguiItem LShell);
extern void	EGUI_UndisplayShell(EguiItem LShell);
extern void	EGUI_MoveShell(EguiItem LShell, int LX, int LY);
extern void	EGUI_ResizeShell(EguiItem LShell, unsigned int LXSize, unsigned int LYSize);
extern void	EGUI_ConfigureShell(EguiItem LShell, int LX, int LY, unsigned int LXSize, unsigned int LYSize);

extern EBool	EGUI_HandleTruecolorIcons(XEvent* LEvent);
extern void	EGUI_ShellAddIcon(EguiItem LShell, Pixmap LPixmap, Pixmap LTruecolorPixmap);

extern void	EGUI_DestroyShell(EguiItem LShell);

extern void	EGUI_CenterShellToItem(EguiItem LSh, EguiItem LCenterToItem);
extern void	EGUI_CenterShellToWidget(EguiItem LSh, Widget LCenterToWidget);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif	// _Shell_h
