/*======================================================================*/
/* EGUI: a platform-independent GUI API					*/
/*									*/
/* EGUIToggleButton: public header file					*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Aug-17 23:18:33					*/
/*									*/
/* EGUI(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EGUIToggleButton_h
#define _EGUIToggleButton_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#include <EGUI/EGUI.h>
#include <Image/Image.h>

typedef struct
{
 int		Reason;
 unsigned int	State;		// Modifier keys
 EBool		Set;
} EguiToggleButtonCallbackStruct;


#ifdef EGUIXe
extern void	_EGUIXtCB_ToggleButton(Widget LW, XtPointer LClientData, XtPointer LCallData);
#endif // EGUIXe


extern EguiItem	EGUI_CreateToggleButton(char* LName, EguiItem LParent, EguiArgList LArgs, int LArgCnt);
extern EguiItem	EGUI_AddToggleButton(char* LLocation, EBool LDefault, char* LName, char LMnemonic, char* LAccel, char* LAccelText, EBool LCreateOptionsButton, char* LToolTip, EguiCallbackProc LCallback, EPointer LClientData);
extern EguiItem	EGUI_AddToggleButtonImg(char* LLocation, char* LName, char LMnemonic, char* LAccel, char* LAccelText, EBool LCreateOptionsButton, char* LToolTip, EguiCallbackProc LCallback, EPointer LClientData, EpImage* LLabelImage, EpImage* LActiveImage, EpImage* LArmImage);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EGUIToggleButton_h
