/*==============================================================*/
/* E library							*/
/*								*/
/* - List management functions					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Oct-21 23:33:11				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _ELists_h
#define _ELists_h

#include <sys/types.h>
#include <string.h>


#ifndef _ETypes_h
#include <ETypes.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


enum
{
 EPtrFIRST=1,
 EPtrADDED,
 EPtrREALLOCATED
};


extern EBool	ELst_AddPointer(void*** LListPtr, unsigned int* LNumOfPointers, void* LNewPtr);
extern EBool	ELst_AddPointerAt(void*** LListPtr, int LIndex, unsigned int* LNumOfPointers, void* LNewPtr);
extern EBool	ELst_AddPointerChk(void*** LListPtr, unsigned int* LNumOfPointers, void* LNewPtr);
extern EBool	ELst_AddPointerA(void*** LListPtr, unsigned int* LNumOfPointers, unsigned int* LNumOfPointersAllocated, unsigned int LAllocStep, void* LNewPtr);
extern EBool	ELst_AddPointerAChk(void*** LListPtr, unsigned int* LNumOfPointers, unsigned int* LNumOfPointersAllocated, unsigned int LAllocStep, void* LNewPtr);

extern EBool	ELst_RemovePointer(void*** LListPtr, unsigned int* LNumOfPointers, void* LThePtr);
extern EBool	ELst_RemovePointerA(void*** LListPtr, unsigned int* LNumOfPointers, unsigned int* LNumOfPointersAllocated, void* LThePtr);

extern int	ELst_GetIndexOfPointer(void** LList, unsigned int LNumOfPointers, void* LThePtr);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _ELists_h
