/*==============================================================*/
/* Plugins							*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Oct-23 23:32:45				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EPlugins_h
#define _EPlugins_h

#include <EParam.h>
#include <EPrefs.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef struct EPlugin_S	EPlugin;


// Plugin structure
//
struct EPlugin_S
{
 int		LockCount;			// The plugin is in use, don't unload it
 void*		DLHandle;			// DL handle associated with the DSO (necessary for unloading the DSO)
 int		(*InitFunction)(EPlugin*);	// Function to call at program start in the DSO
 int		(*ExitFunction)();		// Name of the function to call when unloading the plugin
 char		Name[256];
 char		DSOName[256];			// Name of the Dynamic Shared Object (DSO)
 char*		PathName;			// Path where the DSO was found
 char*		ErrorMessage;			// If there was a problem loading this plugin...
 EResource*	Resources;			// List of resources (settings) set by Plugin_Init()
 char*		ResourceFileName;
};


extern int	E_PluginInit(void* LItem, void* LTmpData);
extern int	E_PluginGetValue(void* LP, void* LTmpData, char* LCmdStr, char* LValStr);
extern int	E_PluginLoad(void* LItems, unsigned int LNumOfItems, void* LItem, char* LPathName, void* LTmpData, void (*LLogFuntion)(int, char*, char*, ...));
extern int	E_PluginUnload(EPlugin* LPlugin);
extern int	E_PluginFree(EPlugin* LPlugin);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EPlugins_h
