/*==============================================================================*/
/* DESCRIPTION:	Resource header file						*/
/*										*/
/* AUTHOR:	Gabor Nagy 							*/
/* DATE:	1996-Dec-17 23:27:31						*/
/*										*/
/* Copyright (C) 1999 by Sony Computer Entertainment. All rights reserved.	*/
/*==============================================================================*/
#ifndef _EResource_h
#define _EResource_h


#ifdef __cplusplus
extern "C" {
#endif



// For byte-order independent network/file I/O and preferences I/O
//

// Resource types
//
enum
{
 EResNULL=0,
 EResBOOLEAN,
 EResCHAR,
 EResUCHAR,
 EResSHORT,
 EResUSHORT,
 EResINT,
 EResUINT,
 EResLINT,
 EResULINT,
 EResFLOAT16,
 EResFLOAT32,
 EResFLOAT64,
 EResSTRING,		// Statically allocated string (char name[])
 EResSTRINGPTR,		// String pointer (dynamically allocated string)
 EResSET,
 EResFLEX_PTRS,
 EResFLEX_STRUCT,
 EResRESERVED0,
 EResRESERVED1,
 EResRESERVED2,
 EResRESERVED3,
 EResRESERVED4,
 EResRESERVED5,
 EResCUSTOM,
};


#define EResNONE	EResNULL
#define EResSEMMI	EResNULL


typedef int	(*EResResourceHandlerProc)(void*, void*, void*, int);

// Resource-handler actions
//
enum
{
 EResCOPY=1,
 EResPACK_SIZE,		// Tell how many bytes are necessary to pack a resource into a binary image
 EResPACK,		// Pack a resource into a machine-independent binary image
 EResUNPACK		// Unpack a resource from a machine-independent binary image
};


typedef struct
{
 char*	Name;
 int	Type;
 void*	VariableAddress;
 void*	ExtData;
} EResource;


extern int	ERes_BinaryImageSize(EResource* LResources, void* LStructureAddress);
extern int	ERes_ToBinaryImage(EResource* LResources, void* LStructureAddress, unsigned char** LResourcesBinaryImage, unsigned int* LBytesAllocatedPtr);
extern int	ERes_FromBinaryImage(EResource* LResources, void* LStructureAddress, unsigned char* LResourcesBinaryImage);
extern int	ERes_Copy(EResource* LResources, void* LStructureAddressS, void* LStructureAddressD);


#ifdef __cplusplus
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EResource_h
