/*==============================================================================*/
/* 2DPanel header file								*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1996-Jan-05 23:53:25						*/
/*										*/
/* 2DPanel and 2DLib Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _E2DWindow_h
#define _E2DWindow_h

#ifndef USEOpenGL
#define USEOpenGL
#endif
#include <GL/gl.h>
#include <GL/glx.h>
#include <Xe/GLDraw.h>

#include <EGUI/Dialog.h>

#include <Image/Picture.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



// What changed in an input of a Tool, for undo/redo etc.
//
#define EpCHG_XPOSITION		0x000001
#define EpCHG_YPOSITION		0x000002
#define EpCHG_ZPOSITION		0x000004
#define EpCHG_XSIZE		0x000010
#define EpCHG_YSIZE		0x000020
#define EpCHG_ZSIZE		0x000040
#define EpCHG_R_CONTENT		0x000100
#define EpCHG_G_CONTENT		0x000200
#define EpCHG_B_CONTENT		0x000400
#define EpCHG_A_CONTENT		0x000800
#define EpCHG_Z_CONTENT		0x001000
#define	EpCHG_COLORINDEX8IMAGE	0x010000
#define	EpCHG_COLORINDEX16IMAGE	0x020000
#define	EpCHG_COLORINDEX32IMAGE	0x040000
#define EpCHG_RGBA8IMAGE	0x080000
#define EpCHG_RGBA16IMAGE	0x100000

#define	EpCHG_SUBIMAGE		0x200000// If only a part of the image changed, this is OR-ed to the flags

#define EpCHG_DONT_PROPAGATE	0x400000
#define	EpCHG_POSITION		(EpCHG_XPOSITION|EpCHG_YPOSITION|EpCHG_ZPOSITION)
#define EpCHG_SIZE		(EpCHG_XSIZE|EpCHG_YSIZE|EpCHG_ZSIZE)
#define EpCHG_CONTENT		(EpCHG_R_CONTENT|EpCHG_G_CONTENT|EpCHG_B_CONTENT|EpCHG_A_CONTENT|EpCHG_Z_CONTENT)



//--------------------------------
// AREAS
//--------------------------------

typedef int	EpAreaID;	// For area selection

#define EpMAX_NUM_OF_AREAS		   256	// Max number of sub-areas displayable on a window


enum
{
 EpAREA_RECTANGULAR,
 EpAREA_FREEHAND,
 EpAREA_SPLINE_CONTOUR
};


// Area states
//
#define EpAREA_HIDDEN	1
#define EpAREA_VISIBLE	(1<<1)
#define EpAREA_ACTIVE	(1<<2)
#define EpAREA_ALL	(EpAREA_HIDDEN|EpAREA_VISIBLE|EpAREA_ACTIVE)


//----------------------------------------------------------------------------------------
// A sub-area to indicate a cropping area, a subimage, a brush to pick up etc.
//----------------------------------------------------------------------------------------
typedef struct
{
 int			Shape;		// Shape (see the enum above)
 int			State;
 EpAreaID		ID;		// Unique ID of the Area
 EpPicture*		Picture;	// The Picture the Area is relative to
 long			IX,IY;		// Picture-relative, hardware and zoom-factor...
 unsigned long		IXSize,IYSize;	// ...independent coordinates
 long			X,Y;		// Window-relative, hardware dependent coordinates
 unsigned long		XSize,YSize;	// Depend on zoom-factor unlike IXSize and IYSize!
 EpCallbackProc		Callback;	// Address of callback-function (for change detection)
 EPointer		ClientData;	// Clientdata for callback-function
} EpArea;





#define EpINFOP_SIZE		0x01
#define EpINFOP_CURSOR		0x02
#define EpINFOP_CHANNELS	0x04
#define EpINFOP_UNDODISPLAY	0x08
#define EpINFOP_MESSAGE_LABEL	0x10
#define EpINFOP_ALL		0x1F

#define EpWFLAG_OUTER_FRAME		0x01
#define EpWFLAG_INNER_FRAME		0x02
#define EpWFLAG_INFOPANEL_CREATE	0x04
#define EpWFLAG_INFOPANEL_ON		0x08
#define EpWFLAG_ZOOMPANEL_CREATE	0x10
#define EpWFLAG_ZOOMPANEL_ON		0x20
#define EpWFLAG_ALL			0x3F

//------------------------------------------------
// Window callback reasons
//------------------------------------------------
enum
{
 EpCR_PICTURE_MOVED=0,		// Picture was scrolled
 EpCR_ZOOM_CHANGED		// Zoom was changed
};


//------------------------
// Sub-image
//------------------------
typedef struct
{
 char		Name[64];
 long		X, Y;				// Window-relative coordinates
 unsigned long	XSize, YSize;
} EpSubImage;


#define EpPICTYPE_NONE		0
#define EpPICTYPE_MONOCHROME	1
#define EpPICTYPE_GRAYSCALE	(1<<1)
#define EpPICTYPE_COLORINDEX	(1<<2)
#define EpPICTYPE_DIRECTCOLOR	(1<<3)

#define EpNONE		-1


#define EpWIDGET_NONE		0		// DrawWidget types
#define EpWIDGET_COLORINDEX	(1<<1)
#define EpWIDGET_12BIT		(1<<2)
#define EpWIDGET_15BIT		(1<<3)
#define EpWIDGET_16BIT		(1<<4)
#define EpWIDGET_24BIT		(1<<5)
#define EpWIDGET_ALL		0x3F


//--------------------------------
// Window Modes
//--------------------------------
enum { EpWM_VIEW=0,EpWM_PAINT };

// Window display types (EpWDT_COLORINDEX and EpWDT_TRUECOLOR are hardware independent values)
//
enum
{
 EpWDT_NONE = 0,
 EpWDT_COLORINDEX,
 EpWDT_TRUECOLOR,
 EpWDT_8BIT_COLORINDEX,
 EpWDT_12BIT_RGB,EpWDT_12BIT_RGB_DITHERED,
 EpWDT_15BIT_RGB,EpWDT_15BIT_RGB_DITHERED,
 EpWDT_16BIT_RGB,EpWDT_16BIT_RGB_DITHERED,
 EpWDT_24BIT_RGB
};


enum
{
 EpPTR_NORMAL=0,
 EpPTR_ZOOM,
 EpPTR_DRAW,
 EpPTR_AREA_TOP_LEFT,EpPTR_AREA_TOP_RIGHT,EpPTR_AREA_BOTTOM_RIGHT,EpPTR_AREA_BOTTOM_LEFT,
 EpPTR_AREA_LEFT,EpPTR_AREA_RIGHT,EpPTR_AREA_TOP,EpPTR_AREA_BOTTOM,EpPTR_AREA_MOVE
};

typedef struct EpWindow_S	EpWindow;

//--------------------------------
// 2DWindow
//--------------------------------
struct EpWindow_S
{
 char			Name[64];
 char			CurrentDir[256];
 int			Mode;				// Mode of the window ( EpWM_VIEW or EpWM_PAINT )
 int			DisplayType;			// Display type of the window (EpWDT_COLORINDEX or EpWDT_TRUECOLOR)
 int			ExactDisplayType;		// Exact display type of the window (EpWDT_8BIT_COLORINDEX, EpWDT_12BIT_RGB etc)
 int			ActiveWidget;			// Active Drawing Widget
 EBool			Alive;
 EBool			DoubleBuffering;
 short			ShowChannels;
 int			Origin;
 int			PointerMode, GrabMode;
 int			PtrXOffset, PtrYOffset;		// For grabbing (area frame, control point, etc.)
 int			PrevMX, PrevMY;
 Widget			ActiveDrawWidget;		// The Widget ID of the active drawing Widget
 Widget			ShellW, MainW,			// Container widgets of this window
			HMatrixW;			// Horizontal Matrix Widget for the Drawing widget in a frame and the ZoomPanel
 Widget			DrawFrameW;
 Widget			DColorIndexW,			// The Drawing widgets
			D12BitW,
			D15BitW,
			D16BitW,
			D24BitW;
 int			XOffset, YOffset;
 int			Zoom, ZoomIndex;
 EBool			GridOn;
 unsigned int		GridColorIndex;
 EcRGBAiColor		GridRGBColor;
 unsigned int		XSize, YSize;
 int			Depth;
 EcRGBAiColor		BackgroundRGBAiColor;
 unsigned int		BackgroundCIColor;
 Colormap		XColormap;			// X Colormap of this window
 Colormap		GLXColormap;			// X Colormap of this window's colorindex GL window
 unsigned int		EUptodateFlags;			// These flags indicate which buffers are up-to-date

 int			SourceX, SourceY,
			CopyXSize, CopyYSize,
			DestX, DestY;
 EpPicture*		Picture;			// Pointer of the picture assigned to this window

 EpImage*		DisplayBuffer;			// Used if not all channels (RGBA) are on



 int			NumOfAreas;
 EpArea			Areas[EpMAX_NUM_OF_AREAS];	// Sub-areas
 EpArea*		ActArea;

 unsigned long		Flags;
 unsigned long		InfoPanelFlags;
 EBool			InfoPanelOn;
 Widget			InfoPanelMatrixW, PointerXW, PointerYW, SizeLabelW,
			ShowRW, ShowGW, ShowBW, ShowAW, UndoBufferDisplayW, NameLabelW;
 Widget			DoubleBufferMW;
 GLXContext		WGLXContext;
 unsigned int		NumOfPictureMovedCallbacks;
 EpCallbackRec*		PictureMovedCallbacks;
 unsigned int		NumOfZoomChangedCallbacks;
 EpCallbackRec*		ZoomChangedCallbacks;
 EBool			ZoomPanelOn, UseExposeBuffer;
 Widget			ZoomPanelMatrixW, ZoomScaleW;
 EpWindow*		Prev;
 EpWindow*		Next;
};

#define EpWINDOW_NONE	((EpWindow*)0)
#define	EpWINDOW_ALL	((EpWindow*)1)



typedef void	(*EpAreaCallbackProc)(EpWindow*, EpAreaID, long,long, unsigned long, unsigned long, EPointer LClientData);



extern void		Ep_WindowCallPictureMovedCallbacks(EpWindow* LPWindow);
extern void		Ep_WindowCallZoomChangedCallbacks(EpWindow* LPWindow);

extern void		Ep_WindowRedraw(EpWindow* LPWindow, EBool LDoGLXwinset);

extern EpWindow*	Ep_CreatePictureWindow(char* LName, Widget LPanelW, int LDisplayType, EBool LCreatePicture, int LWindowMode, unsigned int LWindowFlags, unsigned int LInfoPanelFlags);
extern EpWindow*	Ep_CreateViewWindow(char* LName, Widget LPanelW, int LDisplayType, EBool LCreatePicture, unsigned int LWindowFlags);
extern EpWindow*	Ep_CreatePaintWindow(char* LName, Widget LPanelW, int LDisplayType, EBool LCreatePicture, unsigned int LWindowFlags);

extern void		Ep_WindowPrintMessage(EpWindow* LPWindow, int LType, unsigned int LTime, char* LMessage, ...);
extern void		Ep_WindowsPrintMessage(int LType, unsigned int LTime, char* LMessage, ...);

extern void		Ep_WindowAddCallback(EpWindow* LPWindow, unsigned int LType, EpCallbackProc LFunction, EPointer LClientData);
extern void		Ep_WindowRemoveCallback(EpWindow* LPWindow, unsigned int LType, EpCallbackProc LFunction, EPointer LClientData);





extern void		Ep_AreasUpdateCoordinates(EpWindow* LPWindow, unsigned long LStateMask);
extern void		Ep_AreasDraw(EpWindow* LPWindow, unsigned long LStateMask);
extern void		Ep_AreasUndraw(EpWindow* LPWindow, unsigned long LStateMask);

// Display/XX.c
//
extern void		Ep_WindowSetDrawWidget(EpWindow* LPWindow);


extern EpWindow*	EpCurrent_Window;

extern void		Ep_WindowFullRedraw(EpWindow* LPWindow);
extern void		Ep_WindowCenterPicture(EpWindow* LPWindow, EpPicture* LPicture);
extern void		Ep_WindowCenterPictureToXY(EpWindow* LPWindow, int LX, int LY);

extern int		Ep_WindowReadPicture(EpWindow* LPWindow, char* LFileName, EpImageIOFormat* LFileFormat);
extern int		Ep_WindowWritePicture(EpWindow* LPWindow, char* LFileName, EpImageIOFormat* LFileFormat);

extern void		Ep_2DWindowFitToItsPicture(EpWindow* L2DWindow, int LMarginXSize, int LMarginYSize, EBool LAdjustZoom);

extern void		Ep_DrawPictureOnWindow(EpWindow* LPWindow);


//--------------------------------
// Panel/InfoPanel.c
//--------------------------------
extern void		Ep_WindowSetInfoPanel(EpWindow* LPWindow, EBool LSwitch);
extern void		Ep_WindowUpdateInfoPanel(EpWindow* LPWindow);


//--------------------------------
// Panel/GUI.c
//--------------------------------
extern			void Ep_WindowSetZoomPanel(EpWindow* LPWindow, EBool LSwitch);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _E2DWindow_h
