/*======================================================================================*/
/* 2DPanel header file									*/
/*											*/
/* AUTHOR:	Gabor Nagy								*/
/* DATE:	1996-Jan-05 23:41:29							*/
/*											*/
/* 2DPanel(TM) and 2DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================*/
#ifndef _EPicPanel_h
#define _EPicPanel_h

#ifndef EpGUI
#define EpGUI
#endif

#include <Image/Tools.h>

#ifndef USEOpenGL
#define USEOpenGL
#endif
#include <GL/gl.h>
#include <GL/glx.h>
#include <Xe/GLDraw.h>

#include <EInput.h>
#include <EGUI/Dialog.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


// Identifiers for built-in functions
//
enum
{
 EpCR_90DEGREE_LEFT,
 EpCR_90DEGREE_RIGHT,
 EpCR_FLIP_HORIZONTAL,
 EpCR_FLIP_VERTICAL,
 EpCR_INVERT
};


#define	MAX_NUMOFCOUNTABLECOLORS	500000

#define EpZOOMMULT			    12		// Divisible by 2, 3 and 4
#define EpMAX_ZOOMINDEX			    27
#define EpMAX_SUBIMAGENUM		    64


// Network status of EPicturePanel
//
enum
{
 EpONLINE=0,
 EpEXPECTING_IMAGE,
 EpSENDING_IMAGE
};


// IDs of "busy" dialogs with progress indicator
//
enum
{
 EpQFWORKINGDIALOGID=0,
 EpCROPANIM_WORKINGDIALOGID
};


#ifndef EX
#define EX	0
#define EY	1
#endif

#define EpM_GLVertex2i(v)	glVertex2i((v)[EX],(v)[EY])


#define EpGLPIXELFORMAT		GL_RGBA
#define EpGLPIXELTYPE		GL_UNSIGNED_BYTE

// Status values
//
enum
{
 EpNORMAL=0,
 EpGET_VIMAGE_DIALOG_ON,
 EpSEND_IMAGE_DIALOG_ON,
 EpEXIT_REMOTE_APP_DIALOG_ON,
 EpERROR_MESSAGE_ON
};

#define EpFULL_XSIZE	0xFFFFFFFE
#define EpFULL_YSIZE	0xFFFFFFFD
#define EpFULL_SIZE	0xFFFFFFFC

/*----------------------------------------------*/
/* Image representation in COLORINDEX mode	*/
/*----------------------------------------------*/
enum
{
 EpCIMODE_COLORREDUCTION,	// Colorindex (automatic color reduction)
 EpCIMODE_GRAYSCALE,		// Grayscale
 EpCIMODE_TRICKRGB,		// 'Trick' RGB
 EpCIMODE_TRICKRGB2		// 'Trick' RGB-2
};



enum
{
 EpGRAB_NONE=0,EpGRAB_AREAFRAME
};


enum
{
 EpORIG_TOP_LEFT=0,
 EpORIG_TOP_RIGHT,
 EpORIG_BOTTOM_LEFT,
 EpORIG_BOTTOM_RIGHT
};




typedef struct
{
 EpImageIOFormat*	ImageSaveFormat;				// Image file format for saving
 EBool			SaveAlpha;					// Save Alpha channel when possible
 int			JPEGQFactor;					// JPEG quality factor for saving an image
 EBool			MenuBarOn, InfoPanelOn, DrawModePanelOn,
			ColorPanelOn, TimePanelOn, TimeExtPanelOn,
			VideoPanelOn, ZoomPanelOn;
 EcRGBAiColor		BackgroundRGBAiColor;				// RGB color of the background of the Drawing Widget
 EcRGBAiColor		MarginRGBAiColor;				// Color of added areas
 int			WindowDisplayType;				// Type of windows (WT_TRUECOLOR or WT_COLORINDEX)
 int			DefPicXOffset, DefPicYOffset,
			DefPicXSize, DefPicYSize;
 int			DefPicDepth, DefNumOfColors;
 EBool			DoubleBuffering;
 EBool			QuickRedo;					// Don't free UnodStatus after undo, to allow fast redo
 EBool			TurboColorCount;				// Fast count of different colors in an image by keeping flags of already found colors (needs 2 MB of RAM)
 EBool			TurboLuma;					// Fast luma calculation by using a pre-generated luma-table for all the 1677712 colors (needs 16 MB of RAM)
 int			ColorIndexSubMode;
 int			UndoLevels;
 int			GrayScaleNumOfColors, TrickRGBNumOfColors;
 float			TrickRGBBrightness;
 EBool			FilteredDownZoom, TrickRGBAutoBrightness;
 EBool			CenterToNew;
 EBool			KeepFileSelBoxAfterOk, GetFileFormatFromImage;
 char			PicFileSelBoxFilterList[4096];
 char			NetName[64];
 char			LogFile[256];
 char			ResourcePath[256];
 char			PluginPath[256];
 char			FileIOPluginPath[256];
 char			Hosts[8192];
} EpPrefRec;


typedef struct
{
 Widget	MainW;
} EpPanel;



#define EpM_FillGLRectangle(X,Y,W,H,WW,WH)	glScissor((X),(WH)-(Y)-(H),(W),(H)),glClear(GL_COLOR_BUFFER_BIT)



extern void		Ep_GetPointerPosition(EpWindow* LPWindow, int* LX, int* LY);
extern void		Ep_Log(int LType,char* LPrefix,char* LMessage, ...);



extern EBool		Ep_ToolAllowInteractivePropagation;


extern Widget		Ep_TopWidget, Ep_ParentWidget;

extern EguiItem		Ep_TopShell;

extern Cursor		Ep_NormalCursor, Ep_BusyCursor,
			Ep_FourArrowsCursor,
			Ep_TopLeftCursor, Ep_TopRightCursor, Ep_BottomRightCursor, Ep_BottomLeftCursor,
			Ep_LeftCursor, Ep_RightCursor, Ep_TopCursor, Ep_BottomCursor,
			Ep_CrosshairCursor, Ep_ZoomCursor;

extern int		Ep_GHType;

extern EpWindow*	Ep_PictureWindows;
extern EpWindow*	Ep_LastPictureWindow;
extern EpWindow*	Ep_LastCurrentPictureWindow;
extern EpWindow*	Ep_MainPictureWindow;


extern Colormap		Ep_TruecolorColormap;
extern Window		Ep_IconTmpWindow;

extern Pixmap		Ep_SliderPixmapH,Ep_SliderMaskH;
extern int		Ep_SliderWidth,Ep_SliderLength;

extern EpPrefRec	Ep_Prefs;

extern char*		Ep_Trans(char*);

extern void		Ep_InitPreferences();

extern void		Ep_WindowRefreshName(EpWindow*);
extern void		Ep_PictureRefreshName(EpPicture*);


/*------------------------------*/
/* Panel/PicPanel.c		*/
/*------------------------------*/
extern unsigned int	Ep_ScreenXSize, Ep_ScreenYSize;

extern EBool		Ep_UpdatePalette(unsigned int LNumOfColors, EcRGBAiColor* LColors, unsigned long* LPixelValues);
extern EpPanel*		Ep_2DPanelInitialize(EguiItem LTopShell, Widget LParentW, void (*LEventLoopFunction)(EguiEvent*), void (*LExitFunction)(void), int (*LToolClassRegisterFunction)(EpToolClass*), int (*LToolClassRemoveFunction)(EpToolClass*));
extern void		Ep_FreePicturePanel();
extern void		Ep_SetPaletteColors(EpWindow* LPWindow, EpPicture* LPicture);
extern EBool		Ep_WindowSetZoomFactor(EpWindow* LPWindow, int LZoom);


/*------------------------------*/
/* Panel/Plugins.c		*/
/*------------------------------*/
extern void		Ep_LoadPlugins(char* LPath, char* LFileName);


/*------------------------------*/
/* Panel/SaveImageAs.c		*/
/*------------------------------*/
extern void		Ep_SaveImageAs(EpImage* LImage, char* LDialogTitle, EguiItem LTopShell, void (*LDialogCloseCallback)());


/*------------------------------*/
/* Panel/Undo.c			*/
/*------------------------------*/
extern void		Ep_Undo(EpPicture* LPicture);
extern void		Ep_Redo(EpPicture* LPicture);


/*------------------------------*/
/* Panel/Display/xxxx.c		*/
/*------------------------------*/
extern void		Ep_WindowDrawPicture(EpWindow* LPWindow);




extern char*		GHIDs[];
extern int		Ep_GetGraphicHardwareType();
extern int		Ep_Status;
extern XVisualInfo*	Ep_TrueColorVisuals;
extern int		Ep_NumOfTrueColorVisuals;
extern int		Ep_GLColorIndexSngPlanes,Ep_GLColorIndexDblPlanes;
extern EBool		Ep_XTruecolorAvailable;
extern EBool		Ep_GLColorIndexAvailable,Ep_GLColorIndexDoubleAvailable;
extern EBool		Ep_GLRGB12Available,Ep_GLRGB12DoubleAvailable;
extern EBool		Ep_GLRGB15Available,Ep_GLRGB15DoubleAvailable;
extern EBool		Ep_GLRGB16Available,Ep_GLRGB16DoubleAvailable;
extern EBool		Ep_GLRGB24Available,Ep_GLRGB24DoubleAvailable;

extern char		Ep_AppName[32];


extern void		Ep_Sync(void);
extern void		Ep_CenterPictureWindow(EpWindow* LPWindow, int LX, int LY);
extern void		Ep_WindowCenterToPicture(EpWindow* LPWindow, EpPicture* LPicture);
extern void		Ep_ExposePictureWindow(EpWindow* LPWindow);
extern void		Ep_UpdateSubPictureOnWindow(EpWindow* LPWindow, EpPicture* LPicture, int LX, int LY, int LXSize, int LYSize);
extern void		Ep_SetCursor(EpWindow*,Cursor);
extern void		Ep_UpdatePictureOnWindow(EpWindow*, EBool, EBool);
extern void		Ep_UpdateWindowsOfPicture(EpPicture*);
extern void		Ep_RefreshWindow(EpWindow*,EBool);
extern void		Ep_RefreshWindowsOfPicture(EpPicture*);
extern void		Ep_WindowUpdateDisplayBuffer(EpWindow* LPWindow, int LBuffers);

extern void		Ep_AreasUndraw(EpWindow* LPWindow, unsigned long LStateMask);
extern void		Ep_AreasRedraw(EpWindow* LPWindow, unsigned long LStateMask);
extern void		Ep_AreasUpdate(EpWindow* LPWindow, unsigned long LStateMask);
extern EpAreaID		Ep_AreaAdd(EpWindow* LPWindow, EpPicture* LPicture, int LX, int LY, unsigned int LXSize,unsigned int LYSize, int LShape, int LState, EpAreaCallbackProc LCallback, EPointer LClientData);
extern EBool		Ep_AreaRemove(EpWindow*,int);
extern EBool		Ep_AreaGetGeometry(EpWindow*, int, int*, int*, unsigned int*, unsigned int*);
extern EBool		Ep_AreaSetGeometry(EpWindow*, int, int, int, unsigned int, unsigned int);


extern void		Ep_CreateColorIndexPicture(EpWindow* LPWindow, EpPicture* LPicture, EBool LInteractive,EBool (*Ep_UpdatePalette)(unsigned int, EcRGBAiColor*, unsigned long*));

extern void		Ep_ReadAndInitPlugins(char* LPath, char* LFileName);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EPicPanel_h
