/*======================================================================================*/
/* 2DPanel header file									*/
/*											*/
/* EpPicture: A higher-level structure, built on EpImage, supporting:			*/
/* - Position										*/
/* - Callbacks										*/
/*											*/
/*											*/
/* AUTHOR:	Gabor Nagy								*/
/* DATE:	1996-Dec-12 21:45:56							*/
/*											*/
/* 2DPanel(TM) and 2DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================*/
#ifndef _EPicture_h
#define _EPicture_h

#include <Image/Image.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef void(*EpCallbackProc)(void*, EPointer, EPointer);

typedef struct
{
 EpCallbackProc	Function;
 EPointer	ClientData;
} EpCallbackRec;



typedef struct EpPicture
{
 int			RefCnt;

 EpImageIOFormat*	FileFormat;			// File format of the Picture

 unsigned long		PixelValues[EpMAX_COLORNUM];	// PixelValues of colors for XeDrawing

 double			XOffset, YOffset;
 unsigned int		VirtualXSize, VirtualYSize;
 unsigned int		UptodateFlags;			// These flags indicate which buffers are up-to-date

 unsigned int		NumOfContentChangedCallbacks;
 EpCallbackRec*		ContentChangedCallbacks;
 unsigned int		NumOfSizeChangedCallbacks;
 EpCallbackRec*		SizeChangedCallbacks;
 unsigned int		NumOfPointerButtonCallbacks;
 EpCallbackRec*		PointerButtonCallbacks;
 unsigned int		NumOfPointerMotionCallbacks;
 EpCallbackRec*		PointerMotionCallbacks;

 EpImage*		Image;
 Pixmap			XPixmap;			// X pixmap of the Image

 char			Changed;			// '-' or '*' depending on whether the image is modified
} EpPicture;




typedef struct
{
 int		Reason;
 int		Button;		// For BUTTON
 unsigned long	State;		// For MOTION (Modifier and button masks)
 int		PointerX, PointerY;
} EpPictureCallbackStruct;


/*----------------------------------------------*/
/* Picture callback types			*/
/*----------------------------------------------*/
enum
{
 EpCR_CONTENT_CHANGED=0,	// Picture content changed
 EpCR_SIZE_CHANGED,		// Picture size changed
 EpCR_POINTER_BUTTON,		// Pointer button pressed or released on Picture
 EpCR_POINTER_MOTION		// Pointer moved on Picture
};

/*----------------------------------------------*/
/* Picture callback reasons			*/
/*----------------------------------------------*/
enum
{
 EpCR_BUTTON_PRESS,	// Pointer button pressed
 EpCR_BUTTON_RELEASE,	// Pointer button released
 EpCR_MOTION		// Pointer moved on Picture
};


/*----------------------------------------------*/
/* Picture.c					*/
/*----------------------------------------------*/
extern EpPicture*	Ep_PictureCreate(unsigned int LXSize, unsigned int LYSize, unsigned long LFlags);
extern EpPicture*	Ep_PictureCreateFromImage(EpImage* LImage, unsigned long LFlags);

extern void		Ep_PictureFree(EpPicture* LPicture);
extern int		Ep_PictureResize(EpPicture* LPicture, unsigned long LNewXSize, unsigned long LNewYSize, unsigned long LFlags, EBool LFreeOld);

extern void		Ep_PictureCallContentChangedCallbacks(EpPicture* LPicture);
extern void		Ep_PictureCallSizeChangedCallbacks(EpPicture* LPicture, EBool LCallContentChanged);
extern void		Ep_PictureAddCallback(EpPicture* LPicture, unsigned int LType, EpCallbackProc LFunction, EPointer LClientData);
extern void		Ep_PictureRemoveCallback(EpPicture* LPicture, unsigned int LType, EpCallbackProc LFunction, EPointer LClientData);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EPicture_h
