/*==============================================================================*/
/* Time panel									*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1996-Nov-01 23:25:19						*/
/*										*/
/* Time-panel(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _ETimeP_h
#define _ETimeP_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

typedef struct
{
 EguiCallbackProc	CallbackProc;
 EPointer		ClientData;
} EaTimePanelCallbackRec;

enum
{
 EaSLIDER_FRAME_INT=1,
 EaSLIDER_FRAME_DOUBLE,
 EaSLIDER_SECONDS_DOUBLE
};


typedef struct
{
 double				Frame, FramesPerSecond,
				Time,
				StartFrame, EndFrame, FrameStep;
 Widget				TopMatrixW,
				ExtPanelW, FramesPerSecW,
				TimeCodeFrameW, TimeCodeDrawW,
				SliderPanelW,
				SliderW, StartFrameW, EndFrameW,
				PlayModeFrameW,
				REWBW, BACKBW, STOPBW, PLAYBW, LOOPBW, PLAYPingpongBW, FFBW;

 EaTimePanelCallbackRec*	Callbacks;
 int				NumOfCallbacks;

 XtIntervalId			TimerId;

 unsigned char			SliderType, PlayMode;
 EBool				PanelExtOn, LoopOn, PingpongOn;
} EaTimePanel;


typedef struct
{
 int		Reason;
 unsigned char	PlayMode, PreviousPlayMode;
 double		FramesPerSecond;
 double		Frame, StartFrame, EndFrame, Time;
} EaTimePanelCallbackStruct;


/*----------------------*/
/* Play modes		*/
/*----------------------*/
enum
{
 EaPM_STOP=0,
 EaPM_BACK,
 EaPM_PLAY,
 EaPM_LOOP,
 EaPM_PINGPONG
};


enum
{
 EaCR_SET_CURRENT_FRAME,
 EaCR_SET_START_FRAME,
 EaCR_SET_END_FRAME,
 EaCR_SET_FRAMES_PER_SEC,
 EaCR_SET_PM_TO_STOP,
 EaCR_SET_PM_TO_BACK,
 EaCR_SET_PM_TO_PLAY,
 EaCR_RESET_TIMECODE,
 EaCR_SET_RELATIVE_MODE
};


extern void		Ea_RefreshTimeCode(EaTimePanel* LTimePanel);
extern void		Ea_SetPlayMode(EaTimePanel* LTimePanel, int LPlayMode);
extern void		Ea_TimePanelsSwitch(EaTimePanel* LTimePanel, EBool LPanelOn, EBool LExtPanelOn);
extern EaTimePanel*	Ea_TimePanelCreate(char* LName, Widget LParentW, ArgList LArgs, Cardinal LArgCnt, double LCurrentFrame, double LStartFrame, double LEndFrame, double LFramesPerSecond, char LSliderType, EBool LPanelOn, EBool LExtPanelOn);
extern void		Ea_TimePanelFree(EaTimePanel* LTimePanel);

extern void		Ea_TimePanelAddCallback(EaTimePanel* LTimePanel, EguiCallbackProc LCallbackProc, EPointer LClientData);

extern void		Ea_TimePanelSetTime(EaTimePanel* LTimePanel, double LFrame);
extern void		Ea_TimePanelSetRangeAndTime(EaTimePanel* LTimePanel, double LStartTime, double LEndTime, double LTime);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _ETimeP_h
