/*======================================================================*/
/* 2DLib								*/
/*									*/
/* Undo/redo								*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Jun-22 23:49:54					*/
/*									*/
/* 2DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EpUndo_h
#define _EpUndo_h

#ifndef _EUndo_h
#include <EUndo.h>
#endif



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif




/*==============================================================*/
/* Generic Image content change Operator record			*/
/* This operator simply caches the "before" and "after" images.	*/
/*==============================================================*/
typedef struct
{
// EOperator part
//
 EOperatorCore();

// EpOperatorImageContent part
//
 unsigned int		Flags;
 EpPicture*		Picture;
 EpColorIndex8Pixel*	OldColorIndex8Image;
 EpColorIndex16Pixel*	OldColorIndex16Image;
 EpColorIndex32Pixel*	OldColorIndex32Image;
 EpRGBA8Pixel*		OldRGBA8Image;
 EpRGBA16Pixel*		OldRGBA16Image;
 EpColorIndex8Pixel*	NewColorIndex8Image;
 EpColorIndex16Pixel*	NewColorIndex16Image;
 EpColorIndex32Pixel*	NewColorIndex32Image;
 EpRGBA8Pixel*		NewRGBA8Image;
 EpRGBA16Pixel*		NewRGBA16Image;
} EpOperatorImageContent;



typedef struct
{
// EOperator part
//
 EOperatorCore();

// EpOperatorImageSize part
//
 unsigned int		Flags;
 EpPicture*		Picture;
 int			OldX, Y;
 unsigned int		OldXSize, YSize;
 EpColorIndex8Pixel*	OldColorIndex8Image;
 EpColorIndex16Pixel*	OldColorIndex16Image;
 EpColorIndex32Pixel*	OldColorIndex32Image;
 EpRGBA8Pixel*		OldRGBA8Image;
 EpRGBA16Pixel*		OldRGBA16Image;
 int			NewX, NewY;
 unsigned int		NewXSize, NewYSize;
 EpColorIndex8Pixel*	NewColorIndex8Image;
 EpColorIndex16Pixel*	NewColorIndex16Image;
 EpColorIndex32Pixel*	NewColorIndex32Image;
 EpRGBA8Pixel*		NewRGBA8Image;
 EpRGBA16Pixel*		NewRGBA16Image;
} EpOperatorImageSize;



extern EOperator*	Ep_AddOperatorContentChange(char* LName, EpImage* LBeforeImage, EpImage* LAfterImage, unsigned int LFlags);;
extern unsigned int	EpOp_ImageContent(EOperator* LOperatorIn, int LOperation);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EpUndo_h
